package net.zomis.mario.probability;

    public class CombinationGenerator
    {
        int n;
        int k;
        double numLeft;
        double total;
        int[] combination;
        
        public double getTotal() {
        	return this.total;
        }
        
        public double getLeft() {
        	return this.numLeft;
        }

        public CombinationGenerator(int n, int k)
        {
            this.n = n;
            this.k = k;
            combination = new int[n];
            for (int i = 0; i < n; i++)
            {
                combination[i] = i;
            }

            total = Combinatory.BinomialCoefficient(n, k);
            numLeft = total;
        }

        public boolean HasMore()
        {
            return numLeft != 0;
        }

        public int[] GetNext()
        {
            if (numLeft == total)
            {
                numLeft--;
                return combination;
            }

            int i = n - 1;
            while (combination[i] == k - n + i)
            {
                i--;
            }
            combination[i] = combination[i] + 1;
            for (int j = i + 1; j < n; j++)
            {
                combination[j] = combination[i] + j - i;
            }
            numLeft--;

            return combination;
        }
    }
