package net.zomis.mario.probability;

@Deprecated
public class BigDouble// implements Comparable
{
	int[] num = new int[capacity];
	int intLength = 0;
	int decLength = 0;
	boolean positive = true;

	static final int capacity = 150; // 0 - 139 . 140 - 149
	static final int point = 140;
	static final int b = 65536;  // Base
	static final int shift = 16; // 2 ^ 16 = 65536
	static final double EPSILON = 0.000001;

	//     #region - Constructors -

	public BigDouble()
	{

	}
	public BigDouble(int _int)
	{
		positive = (_int >= 0);

		if (_int < b)
		{
			this.num[point - 1] = _int;
			this.intLength = (_int == 0) ? 0 : 1;
			return;
		}

		int i;
		for (i = point - 1; _int > 0; i--)
		{
			this.num[i] = _int % b;
			_int >>= shift;
		}
		this.intLength = point - i - 1;
	}
	public BigDouble(double number)
	{
		int i;
		double aux;
		double _int = Math.floor(number);
		double _dec = number - _int;

		// Integer part
		for (i = point - 1; i >= 0 && _int > 0; i--)
		{
			this.num[i] = (int)(_int % b);
			_int = Math.floor(_int / b);
		}
		intLength = point - i - 1;

		// Decimal part
		for (i = point; _dec > 0 && i < capacity; i++)
		{
			aux = Math.floor(_dec * b);
			this.num[i] = (int)aux;
			_dec = _dec * b - aux;

			if (this.num[i] > 0)
				decLength = i - point + 1;
		}

		positive = (number >= 0);
	}
	public BigDouble(BigDouble bigDouble)
	{
		int index = point - bigDouble.intLength;
		int length = bigDouble.decLength + bigDouble.intLength;
		for(int i=index;i<length;i++) bigDouble.num[i]=this.num[i];
		//http://msdn.microsoft.com/en-us/library/aa310864%28v=vs.71%29.aspx
		this.positive = bigDouble.positive;
		this.intLength = bigDouble.intLength;
		this.decLength = bigDouble.decLength;
	}
	private BigDouble(BigDouble bigDouble, int ini, int fin)
	{
		for (int i = fin - ini; i >= 0; i--)
		{
			num[point - i - 1] = bigDouble.num[fin - i];
		}
		this.intLength = fin - ini + 1;
	}

	//        #endregion

	public int get(int index) { return num[index]; }
	public void set(int index, int value) { num[index] = value; }

	public static BigDouble Factorial(int n)
	{
		if (n == 0 || n == 1)
			return new BigDouble(1);
		return new BigDouble(Multy(new BigDouble(n),Factorial(n - 1)));
	}

	@Override
	public String toString()
	{
		StringBuilder stringBuilder = new StringBuilder();

		if (this.positive)
		{
			stringBuilder.append("+");
		}
		else
		{
			stringBuilder.append("-");
		}

		int i;
		for (i = point - this.intLength; i < point; i++)
		{
			stringBuilder.append(((Integer)num[i]).toString(/*"000000"*/) + " ");
		}
		stringBuilder.append(". ");
		for (; i < point + this.decLength; i++)
		{
			stringBuilder.append(((Integer)num[i]).toString(/*"000000"*/) + " ");
		}

		return stringBuilder.toString();
	}
	public double ToDouble()
	{
		int i;
		double ent = 0;
		double dec = 0;

		for (i = point - this.intLength; i < point; i++)
		{
			ent *= b;
			ent += this.num[i];
		}
		for (i = point + this.decLength - 1; i >= point; i--)
		{
			dec += this.num[i];
			dec /= b;
		}

		return ent + dec;
	}

	//        #region - Operators -

	public static BigDouble add(BigDouble left, int right)
	{
		return add(left, new BigDouble(right));
	}
	public static BigDouble add(BigDouble left, BigDouble right)
	{
		BigDouble bigDouble = new BigDouble();
		bigDouble.intLength = (left.intLength > right.intLength) ? left.intLength : right.intLength;
		bigDouble.decLength = (left.decLength > right.decLength) ? left.decLength : right.decLength;
		int partial_sum;
		int carry = 0;
		int i;
		int iFin = point - bigDouble.intLength;
		for (i = point + bigDouble.decLength - 1; i >= iFin; i--)
		{
			partial_sum = left.num[i] + right.num[i] + carry;
			carry = partial_sum >= b ? 1 : 0;
			bigDouble.num[i] = partial_sum - carry * b;
		}

		if (carry == 1)
		{
			bigDouble.num[i] = carry;
			bigDouble.intLength++;
		}

		return bigDouble;
	}

	public static BigDouble Minus(BigDouble left, int right)
	{
		return Minus(left,new BigDouble(right));
	}
	public static BigDouble Minus(BigDouble left, BigDouble right)
	{
		BigDouble result;

		if (isBig(right,left))
		{
			result = Minus(right,left);
			result.positive = false;

			return result;
		}

		result = new BigDouble();
		result.decLength = (left.decLength > right.decLength) ? left.decLength : right.decLength;

		int partial_sub;
		int borrow = 0;

		int fin = point - left.intLength;
		for (int i = point + result.decLength - 1; i >= fin; i--)
		{
			partial_sub = left.num[i] - right.num[i] - borrow;
			result.num[i] = partial_sub < 0 ? partial_sub + b : partial_sub;
			borrow = partial_sub < 0 ? 1 : 0;

			if (partial_sub != 0)
			{
				if (i < point)
					result.intLength = point - i;
			}
			else
			{
				if (i == point + result.decLength - 1 && result.decLength != 0)
					result.decLength--;
			}
		}

		return result;
	}

	public static BigDouble Multy(BigDouble left, int right)
	{
		return Multy(left,new BigDouble(right));
	}
	// Solo multiplica parte entera
	public static BigDouble Multy(BigDouble left, BigDouble right)
	{
		int i, j;
		BigDouble result = new BigDouble();
		result.positive = (left.positive == right.positive);
		result.intLength = left.intLength + right.intLength;

		int finI = point - right.intLength;
		int finJ = point - left.intLength;

		for (i = point - 1; i >= finI; i--)
		{
			for (j = point - 1; j >= finJ; j--)
			{
				result.num[i + j - point + 1] += left.num[j] * right.num[i];
			}
		}

		finI = point - result.intLength;
		for (i = point - 1; i >= finI; i--)
		{
			if (result.num[i] > b)
			{
				result.num[i - 1] += result.num[i] / b;
				result.num[i] %= b;
			}
		}
		if (result.num[point - result.intLength] == 0)
		{
			result.intLength--;
		}

		return result;
	}

	public static BigDouble Divide(BigDouble left, int divisor) throws Exception
	{
		if (left.intLength == 0)
			return new BigDouble(0);

		if (divisor > b)
			throw new Exception("Not supported");

		BigDouble dividend = new BigDouble(left);
		BigDouble quotient = new BigDouble();
		quotient.intLength = dividend.intLength;

		int partial_quotient;
		int iFin = point + dividend.decLength;
		for (int i = point - dividend.intLength; i < iFin; i++)
		{
			partial_quotient = dividend.num[i] / divisor;
			dividend.num[i] -= partial_quotient * divisor;
			quotient.num[i] = partial_quotient;
			if (i < capacity - 1)
				dividend.num[i + 1] += dividend.num[i] << shift;
			dividend.num[i] = 0;
		}

		if (quotient.num[point - dividend.intLength] == 0)
		{
			quotient.intLength--;
		}

		return quotient;
	}
	/*        public static BigDouble operator /(BigDouble left, BigDouble right)
        {
            if (left.intLength == 0)
                return new BigDouble(0);

            if (right.intLength > 1)
            {
                throw new Exception("Not supported");
                //return Divide(left, right);
            }

            BigDouble dividend = new BigDouble(left);
            BigDouble divisor = new BigDouble(right);
            BigDouble quotient = new BigDouble();
            quotient.intLength = dividend.intLength;

            int partial_quotient;
            int iFin = point + dividend.decLength;
            for (int i = point - dividend.intLength; i < iFin; i++)
            {
                partial_quotient = dividend.num[i] / divisor.num[point - 1];
                dividend.num[i] -= partial_quotient * divisor.num[point - 1];
                quotient.num[i] = partial_quotient;
                if (i < capacity - 1)
                    dividend.num[i + 1] += dividend.num[i] << shift;
                dividend.num[i] = 0;
            }

            if (quotient.num[point - dividend.intLength] == 0)
            {
                quotient.intLength--;
            }

            return quotient;
        }
	 */

	public static boolean isBig(BigDouble left, BigDouble right)
	{
		if (left.intLength > right.intLength)
			return true;

		if (left.intLength < right.intLength)
			return false;

		for (int i = point - left.intLength; i < capacity; i++)
		{
			if (left.num[i] == right.num[i])
				continue;

			return (left.num[i] > right.num[i]);
		}

		return false;
	}
	public static boolean isSmall(BigDouble left, BigDouble right)
	{
		if (left.intLength < right.intLength)
			return true;

		if (left.intLength > right.intLength)
			return false;

		for (int i = point - left.intLength; i < capacity; i++)
		{
			if (left.num[i] == right.num[i])
				continue;

			return (left.num[i] < right.num[i]);
		}

		return false;
	}

	public static BigDouble Divide(BigDouble left, BigDouble right)
	{
		BigDouble dividend = new BigDouble(left);
		BigDouble divisor = new BigDouble(right);
		BigDouble quotient = new BigDouble();
		BigDouble mul;

		int divisorLength = divisor.intLength;
		int dividendLength = dividend.intLength;
		int cont = 0;
		int ini, fin;
		int i, j;

		for (i = dividendLength - divisorLength; i >= 0; i--)
		{
			ini = point - i - dividendLength - cont;
			fin = point - i - 1;
			quotient.num[point - i - 1] = Substract(dividend, new BigDouble(left, ini, fin));
			mul = Multy(divisor, quotient.num[point - i]);
			for (j = 0; j < i; j++)
			{
				mul=Multy(mul,b);
			}
			dividend = Minus(dividend,mul);
			cont = (quotient.num[point - i] == 0) ? 1 : 0;
		}

		return quotient;
	}
	private static int Substract(BigDouble left, BigDouble right)
	{
		int cont = -1;

		do
		{
			left = Minus(left,right);
			cont++;
		} while (left.positive);

		return cont;
	}

	//        #endregion

	//        #region IEquatable<BigDouble> Members

	public boolean equals(BigDouble other)
	{
		return Math.abs(((BigDouble)Minus(this,other)).ToDouble()) < EPSILON;
	}
	@Deprecated
	public int compareTo(Object arg0) {
		return 0;
	}
}
