package net.zomis.mario.classes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Map.Entry;

/// <summary>
/// Esta clase permite guardar objetos de tipo desconocido pertenecientes a un grupo
/// </summary>
public class UnknownPoint/*
 * :IEquatable<UnknownPoint>
 */ {

    public int row, col;
    public Map<Integer, Integer> times;
    public boolean tempMine;
    public int adjacentTempMines;
    public ArrayList<Integer> relKnown;
    public ArrayList<Integer> relZone;
    public ArrayList<Integer> relUnknown;
    public int[][] adjacents;    //cantidad de minas en la respuesta,cantidad de adyacentes
    private int maximumAdjacentMines = -1;

    public UnknownPoint(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public UnknownPoint(Point p) {
        this.row = p.row;
        this.col = p.col;
    }

    public UnknownPoint(int row, int col, int rel) {
        times = new HashMap<Integer, Integer>(5);
        relKnown = new ArrayList<Integer>(8);
        relUnknown = new ArrayList<Integer>(8);
        relZone = new ArrayList<Integer>(8);

        this.row = row;
        this.col = col;
        this.tempMine = false;

        relKnown.add(rel);
    }

    public int MaxAdjacentMines() {
//			get
//			{
        if (maximumAdjacentMines != -1) {
            return maximumAdjacentMines;
        }

        maximumAdjacentMines = 0;
        for (int i = adjacents[0].length - 1; i > 0; i--) {
            for (int j = 0; j < adjacents.length; j++) {
                if (adjacents[j][ i] != 0) {
                    maximumAdjacentMines = i;
                    return i;
                }
            }
        }

        return maximumAdjacentMines;
//			 }
    }

    public int TotalTimes() {
//			get 
//			{
        int totalTimes = 0;

        for (Entry<Integer, Integer> keyValuePair : times.entrySet()) {
//            for (int i = 0; i < times.size(); i++) {
            totalTimes += keyValuePair.getValue();
        }

        return totalTimes;
//			}
    }

    public Point pointValue() {
        return new Point(row, col);
    }

    //    public static explicit operator Point(UnknownPoint obj)
    //   {
    //      return new Point(obj.row, obj.col);
    //     }
    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        
        stringBuilder.append("(" + this.row + "," + this.col + ")");
        
        int i, j;

        for (int k = 0; k < times.size(); k++) {
//            stringBuilder.append("\t[{0}] {1}", k, times.get(k));
        	if (times.containsValue(k)) {
//        		if (times == null) throw new NullPointerException();
//        		if (times.get(k) == null) throw new NullPointerException(k + " stored with null value");
        		
        		stringBuilder.append("\t[" + k + "] value " + times.get(k));
        	}
        }

        stringBuilder.append("\r\n\t\t\tKnownRelated\t(");
        for (i = 0; i < relKnown.size(); i++) {
            stringBuilder.append("" + relKnown.get(i));
            if (i != relKnown.size() - 1) {
                stringBuilder.append(",");
            }
        }
        stringBuilder.append(")");

        if (relZone.size() > 0) {
            stringBuilder.append("\r\n\t\t\tZoneRelated\t(");
            for (i = 0; i < relZone.size(); i++) {
                stringBuilder.append(relZone.get(i));
                if (i != relZone.size() - 1) {
                    stringBuilder.append(",");
                }
            }
            stringBuilder.append(")");
        }

        if (relUnknown.size() > 0) {
            stringBuilder.append("\r\n\t\t\tUnknownRelated\t(");
            for (i = 0; i < relUnknown.size(); i++) {
                stringBuilder.append(relUnknown.get(i));
                if (i != relUnknown.size() - 1) {
                    stringBuilder.append(",");
                }
            }
            stringBuilder.append(")");
        }

        if (adjacents != null) {
            stringBuilder.append("\r\n\t\t\tAdjacents\r\n");
            for (i = 0; i < adjacents.length; i++) {
                stringBuilder.append("\t\t\t");
                for (j = 0; j < adjacents[0].length; j++) {
                    stringBuilder.append(((Integer) adjacents[i][ j]).toString()/*
                             * .PadLeft(4)
                             */);
                }
                stringBuilder.append("\n");
            }
        }
        stringBuilder.append("\n");

        return stringBuilder.toString();
    }

    //       #region IEquatable<UnknownPoint> Members
    @Override
    public boolean equals(Object other) {
    	if (!(other instanceof UnknownPoint)) return false;
    	UnknownPoint up = (UnknownPoint) other;
        return (up.row == this.row && up.col == this.col);
    }
//        #endregion
}
