package net.zomis.mario.classes;

import java.util.Arrays;

public class Square implements Comparable<Square>
{
	public Boolean mine;
	public Integer value;
	public int virtualValue;
	public double[] probability;
	public Double firstExpectedValue;
	public Double expectedValue;
	public double[] expectedValues;
	public double[] payoff;
	public double std;
	public double bombExpectedValue;
	public double[] bombProbability;
	public Enums.Placement placement;
	public int adjacents;
	public int adjacentMines;
	public int adjacentFixedMines;
	public int adjacentValues;
	public int adjacentsOpenSea;
	public int inGroup;
	public boolean inZone;
	public int region;
	
	@Override
	public int compareTo(Square other) {
		if (this.firstExpectedValue > other.firstExpectedValue)
			return 1;
		if (this.firstExpectedValue < other.firstExpectedValue)
			return -1;
		
		return 0;
	}

	@Override
	public String toString() {
		return "Square [mine=" + mine + ", value=" + value + ", virtualValue="
				+ virtualValue + ", probability="
				+ Arrays.toString(probability) + ", firstExpectedValue="
				+ firstExpectedValue + ", expectedValue=" + expectedValue
				+ ", expectedValues=" + Arrays.toString(expectedValues)
				+ ", payoff=" + Arrays.toString(payoff) + ", std=" + std
				+ ", bombExpectedValue=" + bombExpectedValue
//				+ ", bombProbability=" + Arrays.toString(bombProbability) // too much information and not very interesting.
				+ ", placement=" + placement + ", adjacents=" + adjacents
				+ ", adjacentMines=" + adjacentMines + ", adjacentFixedMines="
				+ adjacentFixedMines + ", adjacentValues=" + adjacentValues
				+ ", adjacentsOpenSea=" + adjacentsOpenSea + ", inGroup="
				+ inGroup + ", inZone=" + inZone + ", region=" + region + "]";
	}

	public void javaGarbage() {
		this.bombProbability = null;
		this.expectedValue = null;
		this.expectedValues = null;
		this.firstExpectedValue = null;
		this.mine = null;
		this.payoff = null;
		this.probability = null;
		this.value = null;
	}
}