package net.zomis.minesweeper.analyze.endgame;

import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class PlayerUtils {

	public static MinesweeperPlayingPlayer getNextPlayer(MinesweeperPlayingPlayer player) {
		int index = player.getIndex() - 1;
		if (index < 0) index += player.getMap().getPlayingPlayers().size();
		return player.getMap().getPlayingPlayers().get(index);
	}
	public static MinesweeperPlayingPlayer getLastPlayer(MinesweeperPlayingPlayer player) {
		int index = player.getIndex() - 1;
		if (index < 0) index += player.getMap().getPlayingPlayers().size();
		return player.getMap().getPlayingPlayers().get(index);
	}
	
	/**
	 * @deprecated Just keeping this method for reference. Use {@link #getNextPlayer(MinesweeperPlayingPlayer)} or {@link #getLastPlayer(MinesweeperPlayingPlayer)} instead.
	 * @param player
	 * @return
	 */
	@Deprecated
	public static MinesweeperPlayingPlayer getOpponent(MinesweeperPlayingPlayer player) {
		if (player.getMap().getPlayingPlayers().size() != 2) throw new IllegalStateException("Only works on maps with two players.");
		for (MinesweeperPlayingPlayer pp : player.getMap().getPlayingPlayers()) {
			if (pp != player) return pp;
		}
		return null;
	}

}
