package net.zomis.minesweeper.aiscore.mario;

import net.zomis.mario.classes.Square;
import net.zomis.minesweeper.ais.MarioAnalyze;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class RealMarioEVScorer extends AbstractScorer {
	private MarioAnalyze	mario;

	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
//		MarioAnalyze mario = scores.getAnalyze(MarioAnalyze.class);
		Square square = mario.getSquare(field);
		
//		 Check if field is open field group, if it is then ignore it.
		if (MarioTools.isMarioOpenField(square)) return 0; // TODO: Does this cause any problems? Line was remmed but is needed for 06 here: 0122_a1_______x_-12ba_21______x__-_a_3a1__2_b1_x__-2b___2__bb______-__1__b_2_____x__-x____233b1___x__-__1__2ab_______x-___a_a__1___xx__-__1_b_2___1_x_x_-1___2_2b2b1_x___-_bb__b____1__x__-b__b3abb________-__224343ba____x_-___b_b1__3_____x-__3b5_____x___x_-___bx_____x_____
		
		if (data.getProbabilities()[0] == 1.0) return 0; // Fix: Let another scorer deal with this. Mario code does not check safe open fields that good.
		
		if (!marioGivesInfo(square)) return data.getMineProbability();
		
		double expectedValue = data.getMineProbability() * (square.payoff[9] + square.expectedValues[9]);
//		Logger.getLogger(getClass()).info(field + " Base " + expectedValue);
		
		// TODO: AI Penalty for 1/2, 2/3, 3/4... ? At least 2/3. Mario seems to be able to handle 1/2 pretty good at least. See: 012a2123a2___1b1-01b33a2aa41_1221-012b3234aa1_1a1_-1122a11a321_111_-1b1111111_______-332_____________-aa1_____________-221__xx______x__-_______________x-________________-x__x______x___x_-x____13x3a5xx_x_-_____a_a__xxx__x-____xa_1_x______-_aaaa____x______-x_x____x_x_xx__x
	    double[] probability = data.getProbabilities();
		for (int k = 0; k < probability.length; k++) {
			double evk = square.expectedValues[k];
			if (evk > 0.1) evk -= 0.01; // Adjust expected value a little.
			expectedValue -= probability[k] * (square.payoff[k] + evk); // use my calculation of probabilities, which is 100% accurate.
//			Logger.getLogger(getClass()).info(field + " Decreasing with " + k + ": " + probability[k] + " * " + square.payoff[k] + " + " 
//					+ evk + " (originally " + square.expectedValues[k] + ") down to a total of " + expectedValue);
		}

		if (mario.getBot().getBoard().MaxExpectedValue() < 0) {
			return 0.1 * expectedValue;
		}
		
		return expectedValue * 1.8;
	}

	private boolean marioGivesInfo(Square square) {
		return square.firstExpectedValue != null || square.expectedValue != null;
	}

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		this.mario = scores.getAnalyze(MarioAnalyze.class);
		return this.weaponIsClick(scores.getWeapon()); // && this.getMario().getBoard().MaxExpectedValue() > 0;
	}
}
