package net.zomis.minesweeper.ais.otherscorers;

import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class FieldGroupSizeScorer extends AbstractScorer {

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return weaponIsClick(scores.getWeapon());
	}

	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		FieldGroup<MinesweeperField> fg = scores.getAnalyze().getAnalyze().getGroupFor(field);
		if (fg == null) return -1;
		
		return fg.size();
	}

}
