package net.zomis.minesweeper.scores;

import java.util.HashMap;
import java.util.Map;

import net.zomis.minesweeper.game.MinesweeperField;


public class FieldScore implements Comparable<FieldScore> {
	private int rank;
	private double score;
	private final MinesweeperField field; // should this one exist?
	private Map<Scorer, Double> specificScorers; // TODO: Only use specific scorers if the fieldscores is detailed.
	private double	normalized;
	
	public FieldScore(MinesweeperField field) {
		this.field = field;
	}

	public FieldScore(FieldScore copy) {
		this.field = copy.field;
		if (copy.specificScorers != null)
			this.specificScorers = new HashMap<Scorer, Double>(copy.specificScorers);
		this.score = copy.score;
	}
	
	boolean removeScore(Scorer scorer) {
		if (this.specificScorers != null) {
			Double value = this.specificScorers.remove(scorer);
			if (value != null)
				this.score -= value;
			return value != null;
		}
		throw new IllegalStateException();
	}
	
	void addScore(AbstractScorer scorer, double score, double weight) {
		double add = score * weight;
		this.saveScore(scorer, add);
	}
	
	private void saveScore(Scorer scorer, double score) {
		this.score += score;
		if (scorer != null) {
			if (this.specificScorers == null) this.specificScorers = new HashMap<Scorer, Double>();
			this.specificScorers.put(scorer, score);
		}
	}

	void setRank(int rank) {
		this.rank = rank;
	}
	void setNormalized(double normalized) {
		this.normalized = normalized;
	}

	@Override
	public int compareTo(FieldScore other) {
		return Double.compare(this.score, other.score);
	}

	public double getScore() {
		return this.score;
	}

	public MinesweeperField getField() {
		return this.field;
	}

	void giveExtraScore(PostScorer scorer, double bonus) {
		this.saveScore(scorer, bonus);
	}
	
	public int getRank() {
		return rank;
	}

	public double getNormalized() {
		return this.normalized;
	}

	public Map<Scorer, Double> getScoreMap() {
		return this.specificScorers;
	}
}
