package net.zomis.minesweeper.ais;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class OptimizeMyBomb extends AbstractScorer {

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return this.weaponIsClick(scores.getWeapon()) && scores.getPlayer().canUseWeapon(MinesweeperMove.STANDARD_BOMB);
	}
	@Override
	public double getScoreFor(MinesweeperField field,
			ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		// 112a3a10122101a2-a24b41213ab2233b-_b4b_12b3b32ba32-2b423a33432123a2-112b22a2ba1__13b-111111122321__2b-b100000001b1__11-111110000111_122-_1_x111101___2aa-_x___2a201x___a3-_1__13b201___2__-____2b311111a111-___13b212a22122b-2222a432b3b112b2-ab3a4aa313221b21-223b33a201a11110
		
		return - (BombTools.getBombProbability(field, scores.getAnalyze().getAnalyze()) / 10000);
	}
}
