package net.zomis.mario.classes;

import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;


public class Enums
{
	public enum Placement {
		CORNER(3), BORDER(5), CENTER(8);

		public final int value;

		Placement(int value) {
			this.value = value;
		}

	}

	public enum LogLevel {
		TRACE(1), DEBUG(2), INFO(3),ERROR(4) ;

		public final int value;

		LogLevel(int value) {
			this.value = value;
		}

	}
	public enum Difficult { VERY_EASY, EASY, MEDIUM, HARD, VERY_HARD, VERY_HARD_NO_SIMULATE }
	public enum EventType { SIMULATION, PROGRESS, INFO, DEBUG, WARNING, ERROR }
	public enum PlayerColor { BLUE, RED;

		public static PlayerColor colorFor(MinesweeperPlayingPlayer playingPlayer) {
			if (playingPlayer == null) return null;
			if (playingPlayer.getIndex() < 0) return null;
			if (PlayerColor.values().length <= playingPlayer.getIndex()) return null;
			return PlayerColor.values()[playingPlayer.getIndex()];
		}
	}
	public enum PlayerTurn { BLUE, RED }
	public enum ClickType { OBVIOUS_MINE, NOT_SO_OBVIOUS_MINE, MAX_FIRST_EXPECTED_VALUE, MAX_EXPECTED_VALUE, RANDOM, UNKNOWN }
	public enum Status { GENERAL, SHOWING_EV }
	public enum PlayerType { HUMAN, BOT }
}