package net.zomis.mario.classes;

// using PerfCounter;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import java.util.logging.Logger;

import net.zomis.mario.classes.MinesweeperFlags.ZonePoint;
import net.zomis.mario.mfeais.NightmareTools;
import net.zomis.mario.probability.Combinatory;
import net.zomis.minesweeper.analyze.InterruptCheck;
import net.zomis.minesweeper.analyze.NoInterrupt;
import net.zomis.minesweeper.analyze.RuntimeTimeoutException;


//	public delegate void BoardEventHandler(Board sender, String description, Enums.EventType eventType);
//	public delegate void BoardEventLogHandler(Board sender, String description, Enums.LogLevel logLevel);
public class Board {

    private final InterruptCheck interruptCheck;

    public boolean FASTMODE;
    public static int MINES = 51;
    public static int DIMH = 16;
    public static int DIMV = 16;
    public int MAXLEVEL;
    public boolean PARETO = false;
    char[][] logicBoard;
    boolean emptyBoard;
    /**
     * An array of all squares on the board. Organized by square[y][x]
     * @see Square
     */
    public Square[][] square;
    boolean[][] obviousMines;
    boolean[][] obviousNotMines;
    boolean[][] notSoObviousMines;
    boolean[][] notSoObviousNotMines;
    int obviousMinesCount;
    int obviousNotMinesCount;
    int notSoobviousMinesCount;
    int notSoobviousNotMinesCount;
    List<Group> groups;
    List<Permutation> permutations;
    List<Frequency[]> answersFrequencies;
    List<Region> regions;
    int initialMines, initialRedMines, initialBlueMines, foundMines;
    double leftMines;
    Double maxFirstExpectedValue, minFirstExpectedValue;
    Double maxExpectedValue, minExpectedValue;
    Configuration configuration = Configuration.SolverConfig();
//		Configuration.Config configuration = Program.solverConfiguration;
    int openSeaCount;
    boolean[][] openSea;
    double totalCases;
    int level;
    public boolean solved;
    boolean firstStep, lastStep;

//		#region  - Properties -
    public char[][] LogicBoard() {
        return this.logicBoard;
    }

    public int[][] InitialAdjacents() {
        int[][] rtn = new int[DIMV][DIMH];

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                rtn[i][j] = (int) square[i][j].placement.value;
            }
        }

        return rtn;
    }

    public int[][] Adjacents() {
        int[][] rtn = new int[DIMV][DIMH];

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                rtn[i][j] = square[i][j].adjacents;
            }
        }

        return rtn;
    }

    public double[][][] Probability() {
        double[][][] rtn = new double[DIMV][DIMH][10];

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                for (int k = 0; k < 10; k++) {
                    rtn[i][j][k] = square[i][j].probability[k];
                }
            }
        }

        return rtn;
    }

    public double[][][] BombProbability() {
        double[][][] bombProbability = new double[DIMV][DIMH][26];

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                for (int k = 0; k <= 25; k++) {
                    bombProbability[i][j][k] = square[i][j].bombProbability[k];
                }
            }
        }

        return bombProbability;
    }

    public double[][][] Payoff() // I add () later.
    {
//			get
//			{
        double[][][] rtn = new double[DIMV][DIMH][10];

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                for (int k = 0; k < 10; k++) {
                    rtn[i][j][k] = square[i][j].payoff[k];
                }
            }
        }

        return rtn;
//			}
    }

    public double[][] Std() //same.
    {
//			get
//			{
        double[][] rtn = new double[DIMV][DIMH];

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                rtn[i][j] = square[i][j].std;
            }
        }

        return rtn;
    }
//		}

    public double[][] ExpandStd(double[][] value) //same.
    {
//			set
//			{
        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                square[i][j].std = value[i][j];
            }
        }
//			}
        return value;
    }

    public double[][] ExpandPayoff(double[][] value) //same.
    {
//			set
//			{
        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                if (square[i][j].probability[0] > 0D) {
                    square[i][j].payoff[0] = value[i][j];
                }
            }
        }
//			}
        return value;
    }

    public double MaxFirstExpectedValue() //same.
    {
    	if (this.maxFirstExpectedValue == null) return 0;
//			get
//			{
        return this.maxFirstExpectedValue.doubleValue();
//			}
    }

    public double MinFirstExpectedValue() //same. 
    {
//			get
//			{
        return this.minFirstExpectedValue.doubleValue();
//			}
    }

    public double MaxExpectedValue() //same.
    {
    	if (this.maxExpectedValue == null) return 0;
//			get
//			{
        return this.maxExpectedValue.doubleValue();
//			}
    }

    public double MinExpectedValue() //same.
    {
    	if (this.minExpectedValue == null) return 0;
//			get
//			{
        return this.minExpectedValue.doubleValue();
//			}
    }

    public boolean[][] MaxFirstExpectedValuePoints() //same.
    {
//			get
//			{
        if (!firstStep) {
            FirstStep();
        }
        if (!lastStep) {
            LastStep();
        }

        int i, j;
        double maxExpectedValue;
        if (maxFirstExpectedValue == null) maxExpectedValue = 0;
        else maxExpectedValue = maxFirstExpectedValue.doubleValue();
        boolean[][] maxFirstExpectedValuePoints = new boolean[DIMV][DIMH];

        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                if (square[i][j].firstExpectedValue != null) {
                    maxFirstExpectedValuePoints[i][j] = (square[i][j].firstExpectedValue.doubleValue() == maxExpectedValue);
                }
            }
        }

        return maxFirstExpectedValuePoints;
//			}
    }

    public boolean[][] MinFirstExpectedValuePoints() //same.
    {
//			get
//			{
        if (!firstStep) {
            FirstStep();
        }
        if (!lastStep) {
            LastStep();
        }

        int i, j;
        double minExpectedValue;
        if (minFirstExpectedValue == null) minExpectedValue = 0;
        else minExpectedValue = minFirstExpectedValue.doubleValue();
        boolean[][] minFirstExpectedValuePoints = new boolean[DIMV][DIMH];

        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                if (square[i][j].firstExpectedValue != null) {
                    minFirstExpectedValuePoints[i][j] = (square[i][j].firstExpectedValue.doubleValue() == minExpectedValue);
                }
            }
        }

        return minFirstExpectedValuePoints;
//			}
    }

    public boolean[][] MaxExpectedValuePoints() //same.
    {
//			get
//			{
        if (!firstStep) {
            FirstStep();
        }
        if (!lastStep) {
            LastStep();
        }

        int i, j;
        double maxExpectedValue;
        if (this.maxExpectedValue == null) maxExpectedValue = 0;
        else maxExpectedValue = this.maxExpectedValue.doubleValue();
        boolean[][] maxSecondExpectedValuePoints = new boolean[DIMV][DIMH];

        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                if (square[i][j].expectedValue != null) {
                    maxSecondExpectedValuePoints[i][j] = (square[i][j].expectedValue.doubleValue() == maxExpectedValue);
                }
            }
        }

        return maxSecondExpectedValuePoints;
//			}
    }

    public boolean[][] BestMaxExpectedValuePoints() //same.
    {
//			get
//			{
        boolean[][] points = new boolean[DIMV][DIMH];
        ArrayList<Square> squares = new ArrayList<Square>(); //was List before.
        int cant;
        double auxExpectedValue;

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                if (square[i][j].firstExpectedValue != null) {
                    squares.add(square[i][j]);
                }
            }
        }

        cant = (int) Math.ceil(squares.size() * 0.2);
        auxExpectedValue = squares.get(cant).firstExpectedValue.doubleValue();

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                points[i][j] = (square[i][j].firstExpectedValue != null) && (square[i][j].firstExpectedValue >= auxExpectedValue);
            }
        }

        return points;
//			}
    }

    public Double[][] FirstExpectedValue() //same.
    {
//			get
//			{
        Double[][] rtn = new Double[DIMV][DIMH];

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                rtn[i][j] = square[i][j].firstExpectedValue;
            }
        }

        return rtn;
//			}
    }

    public Double[][] SecondExpectedValue() //same.
    {
//			get
//			{
        Double[][] rtn = new Double[DIMV][DIMH];

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                rtn[i][j] = square[i][j].expectedValue;
            }
        }

        return rtn;
//			}
    }

    public List<Point> ExpandableSquares() //same.
    {
//			get
//			{
        ArrayList<Point> points = new ArrayList<Point>();
        LookForOpenSea();

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                if (square[i][j].adjacents == square[i][j].placement.value) {
                    points.add(new Point(i, j));
                }
            }
        }

        return points;
//			}
    }

    public Double[][][] ExpectedValues() //same.
    {
//			get
//			{
        Double[][][] rtn = new Double[DIMV][DIMH][10];

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                for (int k = 0; k < 10; k++) {
                    rtn[i][j][k] = square[i][j].expectedValues[k];
                }
            }
        }

        return rtn;
//			}
    }

    public boolean[][] OpenSea() //same.
    {
        return this.openSea;
    }

    public int openSeaCount() //same.
    {
        return this.openSeaCount;
    }

    public int FoundedMines() //same.
    {
        return this.foundMines;
    }

    public int InitialMines() //same.
    {
        return this.initialMines;
    }

    public int BlueMines() //same.
    {
        return this.initialBlueMines;
    }

    public int RedMines() //same.
    {
        return this.initialRedMines;
    }

    public boolean[][] ObviousMines() //same.
    {
//			get
//			{
        if (!this.firstStep) {
            FirstStep();
        }

        return this.obviousMines;
//			}
    }

    public int obviousMinesCount() //same.
    {
//			get
//			{
        if (!this.firstStep) {
            FirstStep();
        }

        return obviousMinesCount;
//			}
    }

    public boolean[][] ObviousNotMines() //same.
    {
//			get
//			{
        if (!this.firstStep) {
            this.FirstStep();
        }

        return this.obviousNotMines;
//			}
    }

    public int obviousNotMinesCount() //same.
    {
//			get
//			{
        if (!this.firstStep) {
            this.FirstStep();
        }

        return obviousNotMinesCount;
//			}
    }

    public boolean[][] NotSoObviousMines() //same.
    {
//			get
//			{
        if (!this.firstStep) {
            FirstStep();
        }

        return this.notSoObviousMines;
//			}
    }

    public int notSoobviousMinesCount() //same.
    {
//			get
//			{
        int cont = 0;

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                if (notSoObviousMines[i][j]) {
                    cont++;
                }
            }
        }

        notSoobviousMinesCount = cont;

        return cont;
//			}
    }

    public boolean[][] NotSoObviousNotMines() //same.
    {
//			get
//			{
        if (!this.firstStep) {
            this.FirstStep();
        }

        return this.notSoObviousNotMines;
//			}
    }

    public int NotSoobviousNotMinesCount() //same.
    {
//			get
//			{
        if (!this.firstStep) {
            this.FirstStep();
        }

        return notSoobviousNotMinesCount;
//			}
    }

    public List<Group> Groups() //same.
    {
//			get
//			{
        if (!this.firstStep) {
            FirstStep();
        }
        return this.groups;
//			}
    }

    public int[][] Regions() //same.
    {
//			get
//			{
        int[][] regions = new int[DIMV][DIMH];
        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                regions[i][j] = square[i][j].region;
            }
        }
        return regions;
//			}
    }
//		#endregion
//		#region - Events -
    public /*
             * event
             */ BoardEventHandler OnEvent;
    public /*
             * event
             */ BoardEventLogHandler OnEventLog;

    private void onEvent(String description, Enums.EventType eventType) {
        if (this.OnEvent != null) {
            OnEvent.onEvent(this, description, eventType);
        }
    }

    private void onEvent(double progress, Enums.EventType eventType) {
        if (this.OnEvent != null) {
            OnEvent.onEvent(this, ((Double) progress).toString(), eventType);
        }
    }

    private void onEventLog(String description, Enums.LogLevel logLevel) {
        if (this.OnEventLog != null) {
            OnEventLog.onEvent(this, description, logLevel);
        }
    }

//		#endregion
    public Board(InterruptCheck interruptCheck) {
        this.interruptCheck = interruptCheck;
        this.MAXLEVEL = 1;
        this.level = 1;

        InitializeBoardMemory();
    }

/*    public Board(char[][] logicBoard) {
        this(logicBoard, 1, 1);
    }*/

    public Board(InterruptCheck interruptCheck, char[][] logicBoard, int level, int MAXLEVEL) {
        this.interruptCheck = interruptCheck;
        this.logicBoard = logicBoard;
        this.level = level;
        this.MAXLEVEL = MAXLEVEL;

        InitializeBoardMemory();
        InitializeLogicBoard();
    }

//		#region - Preliminary Steps -
    void InitializeBoardMemory() {
        FASTMODE = configuration.FASTMODE;
        MINES = configuration.MINES;
        DIMH = configuration.DIMH;
        DIMV = configuration.DIMV;

        PARETO = configuration.PARETO;

        this.leftMines = MINES;
        this.solved = false;
        this.firstStep = false;
        this.lastStep = false;

        square = new Square[DIMV][DIMH];
        initSquares();
        obviousMines = new boolean[DIMV][DIMH];
        obviousNotMines = new boolean[DIMV][DIMH];
        notSoObviousMines = new boolean[DIMV][DIMH];
        notSoObviousNotMines = new boolean[DIMV][DIMH];
        openSea = new boolean[DIMV][DIMH];

        groups = new ArrayList<Group>(10);
        regions = new ArrayList<Region>(5);
        permutations = new ArrayList<Permutation>(10);
        answersFrequencies = new ArrayList<Frequency[]>(10);

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                square[i][j].probability = new double[10];
                /*
                 * for (int k = 0; k < 10; k++) { square[i][j].probability[k] =
                 * 0D; }
                 */
                square[i][j].payoff = new double[10];
                square[i][j].expectedValues = new double[10];
                square[i][j].bombProbability = new double[26];

                if ((i == 0 && (j == 0 || j == DIMH - 1)) || (i == (DIMV - 1) && (j == 0 || j == (DIMH - 1)))) {
                    square[i][j].placement = Enums.Placement.CORNER;
                } else if (i == 0 || i == (DIMV - 1) || j == 0 || j == (DIMH - 1)) {
                    square[i][j].placement = Enums.Placement.BORDER;
                } else {
                    square[i][j].placement = Enums.Placement.CENTER;
                }
            }
        }
    }

    private void initSquares() {
		for (int i = 0; i < this.square.length; i++)
			for (int j = 0; j < this.square[i].length; j++) {
				this.square[i][j] = new Square();
			}
	}

	void InitializeLogicBoard() {
        int cont = 0;
        int j;
        for (int i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                switch (logicBoard[i][j]) {
                    case '?':
                        cont++;
                        break;
                    case '0':
                    case '1':
                    case '2':
                    case '3':
                    case '4':
                    case '5':
                    case '6':
                    case '7':
                    case '8':
                        square[i][j].value = (Integer) (logicBoard[i][j] - 48);
                        square[i][j].virtualValue = square[i][j].value.intValue();
                        square[i][j].mine = false;
                        break;
                    case 'b':
                        initialMines++;
                        initialBlueMines++;
                        square[i][j].mine = true;
                        break;
                    case 'r':
                        initialMines++;
                        initialRedMines++;
                        square[i][j].mine = true;
                        break;
                    case 'm':
                        initialMines++;
                        square[i][j].mine = true;
                        break;
                    case 'w':
                        square[i][j].mine = false;
                        break;
                    default:
//							onEvent("Wrong Board", Enums.EventType.ERROR);
                        break;
                }
            }
        }
        this.leftMines = MINES - initialMines;
        this.emptyBoard = (cont == DIMH * DIMV);
    }

//		#endregion
    public void Solve() {
		onEvent("Starting", Enums.EventType.INFO);

        FirstStep();
        firstStep = true;

        LastStep();
        additionalStep();

        solved = true;

        onEvent("Finished", Enums.EventType.INFO);
    }

//		#region - First Step -
    void FirstStep() {
    	onEvent("size() Adjacents", Enums.EventType.INFO);
        CountAdjacents();
        onEventLog("size()Adjacents", Enums.LogLevel.TRACE);

        onEvent("Obvious Mines", Enums.EventType.INFO);
        FindObviousMines();
        onEventLog("Obvious Mines", Enums.LogLevel.DEBUG);

        onEvent("Groups", Enums.EventType.INFO);
        LookForGroups();
        onEventLog("LookForGroups", Enums.LogLevel.TRACE);

        if (groups.size() > 0) {
            onEvent("Zones", Enums.EventType.INFO);
            LookForZones();
            onEventLog("LookForZones", Enums.LogLevel.TRACE);

            InitializeAdjacencyArrays();

            onEvent("Not So Obvious Mines", Enums.EventType.INFO);
            FindNotSoObviousMines();
            foundMines += notSoobviousMinesCount;
            onEventLog("FindNotSoObviousMines", Enums.LogLevel.TRACE);
        }

        onEvent("First Step", Enums.EventType.DEBUG);
    }

    void InitializeAdjacencyArrays() {
        int maxMines;
        int j;
        for (int i = 0; i < groups.size(); i++) {
            maxMines = groups.get(i).maximumMines + 1;
            for (j = 0; j < groups.get(i).unknown.size(); j++) {
                groups.get(i).unknown.get(j).adjacents = new int[maxMines][Math.min(maxMines, 9)];
            }
            for (j = 0; j < groups.get(i).zone.size(); j++) {
                groups.get(i).zone.get(j).adjacents = new int[maxMines][Math.min(maxMines, 9)];
            }
        }
    }

    void FindObviousMines() {
        ObviousNot();
        ObviousYes();

        foundMines = obviousMinesCount;
        leftMines -= obviousMinesCount;
    }

    // Nota: No optimize los ifs dentro de los for, debido a que 
    // no funcionaria el caso de tableros con un solo renglon o una 
    // sola columna
    void CountAdjacents() {
        int i, j;

        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                // size() adjacents
                if (square[i][j].mine == null || !square[i][j].mine) {
                    if (i != 0) {
                        if (j != 0) {
                            square[i - 1][ j - 1].adjacents++;
                        }
                        square[i - 1][ j].adjacents++;
                        if (j != DIMH - 1) {
                            square[i - 1][ j + 1].adjacents++;
                        }
                    }

                    if (j != 0) {
                        square[i][ j - 1].adjacents++;
                    }
                    if (j != DIMH - 1) {
                        square[i][ j + 1].adjacents++;
                    }

                    if (i != DIMV - 1) {
                        if (j != 0) {
                            square[i + 1][ j - 1].adjacents++;
                        }
                        square[i + 1][ j].adjacents++;
                        if (j != DIMH - 1) {
                            square[i + 1][ j + 1].adjacents++;
                        }
                    }
                } // size() adjacent mines
                else if (square[i][j].mine.booleanValue()) {
                    if (i != 0) {
                        if (j != 0) {
                            square[i - 1][ j - 1].adjacentMines++;
                            square[i - 1][ j - 1].adjacentFixedMines++;
                            square[i - 1][ j - 1].virtualValue--;
                        }
                        square[i - 1][ j].adjacentMines++;
                        square[i - 1][ j].adjacentFixedMines++;
                        square[i - 1][ j].virtualValue--;
                        if (j != DIMH - 1) {
                            square[i - 1][ j + 1].adjacentMines++;
                            square[i - 1][ j + 1].adjacentFixedMines++;
                            square[i - 1][ j + 1].virtualValue--;
                        }
                    }

                    if (j != 0) {
                        square[i][ j - 1].adjacentMines++;
                        square[i][ j - 1].adjacentFixedMines++;
                        square[i][ j - 1].virtualValue--;
                    }
                    if (j != DIMH - 1) {
                        square[i][ j + 1].adjacentMines++;
                        square[i][ j + 1].adjacentFixedMines++;
                        square[i][ j + 1].virtualValue--;
                    }

                    if (i != DIMV - 1) {
                        if (j != 0) {
                            square[i + 1][ j - 1].adjacentMines++;
                            square[i + 1][ j - 1].adjacentFixedMines++;
                            square[i + 1][ j - 1].virtualValue--;
                        }
                        square[i + 1][ j].adjacentMines++;
                        square[i + 1][ j].adjacentFixedMines++;
                        square[i + 1][ j].virtualValue--;
                        if (j != DIMH - 1) {
                            square[i + 1][ j + 1].adjacentMines++;
                            square[i + 1][ j + 1].adjacentFixedMines++;
                            square[i + 1][ j + 1].virtualValue--;
                        }
                    }
                }

                // size() adjacent values
                if (square[i][j].value != null && square[i][j].value.doubleValue() > 0) {
                    if (i != DIMV - 1) {
                        if (j != 0) {
                            square[i + 1][ j - 1].adjacentValues++;
                        }
                        square[i + 1][ j].adjacentValues++;
                        if (j != DIMH - 1) {
                            square[i + 1][ j + 1].adjacentValues++;
                        }
                    }

                    if (j != 0) {
                        square[i][ j - 1].adjacentValues++;
                    }
                    if (j != DIMH - 1) {
                        square[i][ j + 1].adjacentValues++;
                    }

                    if (i != 0) {
                        if (j != 0) {
                            square[i - 1][ j - 1].adjacentValues++;
                        }
                        square[i - 1][ j].adjacentValues++;
                        if (j != DIMH - 1) {
                            square[i - 1][ j + 1].adjacentValues++;
                        }
                    }
                }
            }
        }
    }

    void ObviousNot() {
        int i, j;

        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMV; j++) {
                if (square[i][j].value == null || square[i][j].adjacentMines == 0 || square[i][j].value != square[i][j].adjacentMines) {
                    continue;
                }

                if (i != 0) {
                    if (j != 0) {
                        addObviousNotMine(i - 1, j - 1);
                    }
                    addObviousNotMine(i - 1, j);
                    if (j != DIMH - 1) {
                        addObviousNotMine(i - 1, j + 1);
                    }
                }

                if (j != 0) {
                    addObviousNotMine(i, j - 1);
                }
                if (j != DIMH - 1) {
                    addObviousNotMine(i, j + 1);
                }

                if (i != DIMV - 1) {
                    if (j != 0) {
                        addObviousNotMine(i + 1, j - 1);
                    }
                    addObviousNotMine(i + 1, j);
                    if (j != DIMH - 1) {
                        addObviousNotMine(i + 1, j + 1);
                    }
                }
            }
        }
    }

    boolean ObviousNot(int y, int x) {
        if (square[y][x].adjacents == 0) {
            return false;
        }

        if (y != 0) {
            if (x != 0) {
                addObviousNotMine(y - 1, x - 1);
            }
            addObviousNotMine(y - 1, x);
            if (x != DIMV - 1) {
                addObviousNotMine(y - 1, x + 1);
            }
        }

        if (x != DIMV - 1) {
            addObviousNotMine(y, x + 1);
        }

        if (x != 0) {
            addObviousNotMine(y, x - 1);
        }

        if (y != DIMH - 1) {
            if (x != 0) {
                addObviousNotMine(y + 1, x - 1);
            }
            addObviousNotMine(y + 1, x);
            if (x != DIMV - 1) {
                addObviousNotMine(y + 1, x + 1);
            }
        }

        return true;
    }

    boolean addObviousNotMine(int y, int x) {
        if (square[y][x].mine != null) {
            return false;
        }

        square[y][x].mine = false;

        obviousNotMines[y][x] = true;
        obviousNotMinesCount++;

        DecreaseAdjacent(y, x);

        return true;
    }

    void addNotSoObviousNotMine(int i, int j) {
        square[i][j].mine = false;

        notSoObviousNotMines[i][j] = true;
        notSoobviousNotMinesCount++;

        DecreaseAdjacent(i, j);
    }

    void ObviousYes() {
        boolean flag;
        int j;

        for (int i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                if (square[i][j].value != null && square[i][j].value.doubleValue() != 0
                        && square[i][j].adjacents != 0
                        && (square[i][j].value.doubleValue() - square[i][j].adjacentMines) == square[i][j].adjacents) {
                    flag = false;

                    if (i != 0) {
                        if (j != 0) {
                            flag = addObviousMine(i - 1, j - 1) || flag;
                        }
                        flag = addObviousMine(i - 1, j) || flag;
                        if (j != DIMH - 1) {
                            flag = addObviousMine(i - 1, j + 1) || flag;
                        }
                    }

                    if (j != 0) {
                        flag = addObviousMine(i, j - 1) || flag;
                    }
                    if (j != DIMH - 1) {
                        flag = addObviousMine(i, j + 1) || flag;
                    }

                    if (i != DIMV - 1) {
                        if (j != 0) {
                            flag = addObviousMine(i + 1, j - 1) || flag;
                        }
                        flag = flag | addObviousMine(i + 1, j);
                        if (j != DIMH - 1) {
                            flag = addObviousMine(i + 1, j + 1) || flag;
                        }
                    }

                    if (flag) {
                        i = (i > 3) ? i - 4 : 0;
                        j = (j > 4) ? j - 5 : -1;
                    }
                }
            }
        }
    }

    boolean addObviousMine(int i, int j) {
        if (square[i][j].mine != null) {
            return false;
        }

        square[i][j].mine = true;
        square[i][j].probability[9] = 1D;

        obviousMines[i][j] = true;
        obviousMinesCount++;

        IncreaseAdjacentMines(i, j);
        DecreaseAdjacent(i, j);

        return CheckAdjacentValues(i, j);
    }

    void addNotSoObviousMine(int i, int j) {
        square[i][j].mine = true;
        square[i][j].probability[9] = 1D;

        notSoObviousMines[i][j] = true;
        notSoobviousMinesCount++;

        IncreaseAdjacentMines(i, j);
        DecreaseAdjacent(i, j);
    }

    boolean CheckAdjacentValues(int i, int j) {
        boolean flag = false;

        for (int xx = -1; xx <= 1; xx++) {
            for (int yy = -1; yy <= 1; yy++)
            if (xx != 0 || yy != 0) { // don't analyze the same square
            	if (isOnMap(i + yy, j + xx)) {
            		Square sq = square[i + yy][j + xx];
            		if (sq.value != null) {
            			if (sq.value > 0 && sq.value == sq.adjacentMines) {
            				flag = ObviousNot(i + yy, j + xx) || flag;
            			}
            		}
            	}
            }
    	}
        
        
        
//        if (j != 0) {
//            if (i != 0) {
//                if (square[i - 1][ j - 1].value.doubleValue() > 0 && square[i - 1][ j - 1].value.doubleValue() == square[i - 1][ j - 1].adjacentMines) {
//                    flag = ObviousNot(i - 1, j - 1) || flag;
//                }
//            }
//            if (square[i][ j - 1].value.doubleValue() > 0 && square[i][ j - 1].value.doubleValue() == square[i][ j - 1].adjacentMines) {
//                flag = ObviousNot(i, j - 1) || flag;
//            }
//            if (i != DIMV - 1) {
//                if (square[i + 1][ j - 1].value.doubleValue() > 0 && square[i + 1][ j - 1].value.doubleValue() == square[i + 1][ j - 1].adjacentMines) {
//                    flag = ObviousNot(i + 1, j - 1) || flag;
//                }
//            }
//        }
//
//        if (i != 0) {
//            if (square[i - 1][ j].value.doubleValue() > 0 && square[i - 1][ j].value.doubleValue() == square[i - 1][ j].adjacentMines) {
//                flag = ObviousNot(i - 1, j) || flag;
//            }
//        }
//        if (i != DIMV - 1) {
//            if (square[i + 1][ j].value.doubleValue() > 0 && square[i + 1][ j].value.doubleValue() == square[i + 1][ j].adjacentMines) {
//                flag = ObviousNot(i + 1, j) || flag;
//            }
//        }
//
//        if (j != DIMH - 1) {
//            if (i != 0) {
//                if (square[i - 1][ j + 1].value.doubleValue() > 0 && square[i - 1][ j + 1].value.doubleValue() == square[i - 1][ j + 1].adjacentMines) {
//                    flag = ObviousNot(i - 1, j + 1) || flag;
//                }
//            }
//            if (square[i][ j + 1].value.doubleValue() > 0 && square[i][ j + 1].value.doubleValue() == square[i][ j + 1].adjacentMines) {
//                flag = ObviousNot(i, j + 1) || flag;
//            }
//            if (i != DIMV - 1) {
//                if (square[i + 1][ j + 1].value.doubleValue() > 0 && square[i + 1][ j + 1].value.doubleValue() == square[i + 1][ j + 1].adjacentMines) {
//                    flag = ObviousNot(i + 1, j + 1) || flag;
//                }
//            }
//        }

        return flag;

    }

    public boolean isOnMap(int yy, int xx) {
    	if (yy < 0) return false;
    	if (xx < 0) return false;
    	if (yy >= DIMV) return false;
    	if (xx >= DIMH) return false;
    	
		return true;
	}

	void IncreaseAdjacentMines(int i, int j) {
        if (i != DIMV - 1) {
            if (j != 0) {
                square[i + 1][ j - 1].adjacentMines++;
                square[i + 1][ j - 1].virtualValue--;
            }
            square[i + 1][ j].adjacentMines++;
            square[i + 1][ j].virtualValue--;
            if (j != DIMH - 1) {
                square[i + 1][ j + 1].adjacentMines++;
                square[i + 1][ j + 1].virtualValue--;
            }
        }

        if (j != 0) {
            square[i][ j - 1].adjacentMines++;
            square[i][ j - 1].virtualValue--;
        }
        if (j != DIMH - 1) {
            square[i][ j + 1].adjacentMines++;
            square[i][ j + 1].virtualValue--;
        }

        if (i != 0) {
            if (j != 0) {
                square[i - 1][ j - 1].adjacentMines++;
                square[i - 1][ j - 1].virtualValue--;
            }
            square[i - 1][ j].adjacentMines++;
            square[i - 1][ j].virtualValue--;
            if (j != DIMH - 1) {
                square[i - 1][ j + 1].adjacentMines++;
                square[i - 1][ j + 1].virtualValue--;
            }
        }
    }

    void DecreaseAdjacent(int i, int j) {
        if (i != 0) {
            if (j != 0) {
                square[i - 1][ j - 1].adjacents--;
            }
            square[i - 1][ j].adjacents--;
            if (j != DIMH - 1) {
                square[i - 1][ j + 1].adjacents--;
            }
        }

        if (j != 0) {
            square[i][ j - 1].adjacents--;
        }
        if (j != DIMH - 1) {
            square[i][ j + 1].adjacents--;
        }

        if (i != DIMV - 1) {
            if (j != 0) {
                square[i + 1][ j - 1].adjacents--;
            }
            square[i + 1][ j].adjacents--;
            if (j != DIMH - 1) {
                square[i + 1][ j + 1].adjacents--;
            }
        }
    }

    void LookForGroups() {
        int i, j;
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                if (square[i][j].adjacentValues != 0 && square[i][j].mine == null) {
                	Integer compare = Integer.valueOf(0);
                	
                    if (i != 0 && j != 0) {
                        if (square[i - 1][ j - 1].value != null && square[i - 1][ j - 1].value > compare && square[i - 1][ j - 1].inGroup == 0) {
                            LookForMoreUnknowns(i - 1, j - 1);
                            continue;
                        }
                    }
                    if (i != 0) {
                        if (square[i - 1][ j].value != null && square[i - 1][ j].value > compare && square[i - 1][ j].inGroup == 0) {
                            LookForMoreUnknowns(i - 1, j);
                            continue;
                        }
                    }
                    if (i != 0 && j != DIMH - 1) {
                        if (square[i - 1][ j + 1].value != null && square[i - 1][ j + 1].value > compare && square[i - 1][ j + 1].inGroup == 0) {
                            LookForMoreUnknowns(i - 1, j + 1);
                            continue;
                        }
                    }
                    if (j != 0) {
                        if (square[i][ j - 1].value != null && square[i][ j - 1].value > compare && square[i][ j - 1].inGroup == 0) {
                            LookForMoreUnknowns(i, j - 1);
                            continue;
                        }
                    }
                    if (j != DIMH - 1) {
                        if (square[i][ j + 1].value != null && square[i][ j + 1].value > compare && square[i][ j + 1].inGroup == 0) {
                            LookForMoreUnknowns(i, j + 1);
                            continue;
                        }
                    }
                    if (i != DIMV - 1 && j != 0) {
                        if (square[i + 1][ j - 1].value != null && square[i + 1][ j - 1].value > compare && square[i + 1][ j - 1].inGroup == 0) {
                            LookForMoreUnknowns(i + 1, j - 1);
                            continue;
                        }
                    }
                    if (i != DIMV - 1) {
                        if (square[i + 1][ j].value != null && square[i + 1][ j].value > compare && square[i + 1][ j].inGroup == 0) {
                            LookForMoreUnknowns(i + 1, j);
                            continue;
                        }
                    }
                    if (i != DIMV - 1 && j != DIMH - 1) {
                        if (square[i + 1][ j + 1].value != null && square[i + 1][ j + 1].value > compare && square[i + 1][ j + 1].inGroup == 0) {
                            LookForMoreUnknowns(i + 1, j + 1);
                            continue;
                        }
                    }
                }
            }
        }
    }

    void LookForMoreUnknowns(int row, int col) {
        int knownIndex = 0;
        Group group = new Group();
        UnknownPoint tempUnknownPoint;

        group.known.add(new KnownPoint(row, col));
        do {
            square[row][ col].inGroup = groups.size() + 1;

            if (row != 0) {
                if (col != 0) {
                    if (square[row - 1][ col - 1].value == null && square[row - 1][ col - 1].adjacentValues > 0 && square[row - 1][ col - 1].mine == null) {
                        tempUnknownPoint = new UnknownPoint(row - 1, col - 1, knownIndex);
                        if (square[row - 1][ col - 1].inGroup == 0) {
                            square[row - 1][ col - 1].inGroup = groups.size() + 1;
                            group.unknown.add(tempUnknownPoint);
                            LookForMoreValues(/*
                                     * ref
                                     */group, row - 1, col - 1);
                        } else {
                            group.unknown.get(group.unknown.indexOf(tempUnknownPoint)).relKnown.add(knownIndex);
                        }
                    }
                }

                if (square[row - 1][ col].value == null && square[row - 1][ col].adjacentValues > 0 && square[row - 1][ col].mine == null) {
                    tempUnknownPoint = new UnknownPoint(row - 1, col, knownIndex);
                    if (square[row - 1][ col].inGroup == 0) {
                        square[row - 1][ col].inGroup = groups.size() + 1;
                        group.unknown.add(tempUnknownPoint);
                        LookForMoreValues(/*
                                 * ref
                                 */group, row - 1, col);
                    } else {
                        group.unknown.get(group.unknown.indexOf(tempUnknownPoint)).relKnown.add(knownIndex);
                    }
                }

                if (col < DIMH - 1) {
                    if (square[row - 1][ col + 1].value == null && square[row - 1][ col + 1].adjacentValues > 0 && square[row - 1][ col + 1].mine == null) {
                        tempUnknownPoint = new UnknownPoint(row - 1, col + 1, knownIndex);
                        if (square[row - 1][ col + 1].inGroup == 0) {
                            square[row - 1][ col + 1].inGroup = groups.size() + 1;
                            group.unknown.add(tempUnknownPoint);
                            LookForMoreValues(/*
                                     * ref
                                     */group, row - 1, col + 1);
                        } else {
                            group.unknown.get(group.unknown.indexOf(tempUnknownPoint)).relKnown.add(knownIndex);
                        }
                    }
                }
            }

            if (row != DIMV - 1) {
                if (col != 0) {
                    if (square[row + 1][ col - 1].value == null && square[row + 1][ col - 1].adjacentValues > 0 && square[row + 1][ col - 1].mine == null) {
                        tempUnknownPoint = new UnknownPoint(row + 1, col - 1, knownIndex);
                        if (square[row + 1][ col - 1].inGroup == 0) {
                            square[row + 1][ col - 1].inGroup = groups.size() + 1;
                            group.unknown.add(tempUnknownPoint);
                            LookForMoreValues(/*
                                     * ref
                                     */group, row + 1, col - 1);
                        } else {
                            group.unknown.get(group.unknown.indexOf(tempUnknownPoint)).relKnown.add(knownIndex);
                        }
                    }
                }

                if (square[row + 1][ col].value == null && square[row + 1][ col].adjacentValues > 0 && square[row + 1][ col].mine == null) {
                    tempUnknownPoint = new UnknownPoint(row + 1, col, knownIndex);
                    if (square[row + 1][ col].inGroup == 0) {
                        square[row + 1][ col].inGroup = groups.size() + 1;
                        group.unknown.add(tempUnknownPoint);
                        LookForMoreValues(/*
                                 * ref
                                 */group, row + 1, col);
                    } else {
                        group.unknown.get(group.unknown.indexOf(tempUnknownPoint)).relKnown.add(knownIndex);
                    }
                }

                if (col != DIMH - 1) {
                    if (square[row + 1][ col + 1].value == null && square[row + 1][ col + 1].adjacentValues > 0 && square[row + 1][ col + 1].mine == null) {
                        tempUnknownPoint = new UnknownPoint(row + 1, col + 1, knownIndex);
                        if (square[row + 1][ col + 1].inGroup == 0) {
                            square[row + 1][ col + 1].inGroup = groups.size() + 1;
                            group.unknown.add(tempUnknownPoint);
                            LookForMoreValues(/*
                                     * ref
                                     */group, row + 1, col + 1);
                        } else {
                            group.unknown.get(group.unknown.indexOf(tempUnknownPoint)).relKnown.add(knownIndex);
                        }
                    }
                }
            }

            if (col != 0) {
                if (square[row][ col - 1].value == null && square[row][ col - 1].adjacentValues > 0 && square[row][ col - 1].mine == null) {
                    tempUnknownPoint = new UnknownPoint(row, col - 1, knownIndex);
                    if (square[row][ col - 1].inGroup == 0) {
                        square[row][ col - 1].inGroup = groups.size() + 1;
                        group.unknown.add(tempUnknownPoint);
                        LookForMoreValues(/*
                                 * ref
                                 */group, row, col - 1);
                    } else {
                        group.unknown.get(group.unknown.indexOf(tempUnknownPoint)).relKnown.add(knownIndex);
                    }
                }
            }

            if (col != DIMH - 1) {
                if (square[row][ col + 1].value == null && square[row][ col + 1].adjacentValues > 0 && square[row][ col + 1].mine == null) {
                    tempUnknownPoint = new UnknownPoint(row, col + 1, knownIndex);
                    if (square[row][ col + 1].inGroup == 0) {
                        square[row][ col + 1].inGroup = groups.size() + 1;
                        group.unknown.add(tempUnknownPoint);
                        LookForMoreValues(/*
                                 * ref
                                 */group, row, col + 1);
                    } else {
                        group.unknown.get(group.unknown.indexOf(tempUnknownPoint)).relKnown.add(knownIndex);
                    }
                }
            }

            knownIndex++;
            if (knownIndex < group.known.size()) {
                row = group.known.get(knownIndex).row;
                col = group.known.get(knownIndex).col;
            }
        } while (knownIndex < group.known.size());

        CalculateMaximumMines(/*
                 * ref
                 */group);

        groups.add(group);
    }

    void CalculateMaximumMines(/*
             * ref
             */Group group) {
        int valuesSum = 0;
        for (int i = 0; i < group.known.size(); i++) {
            valuesSum += square[group.known.get(i).row][ group.known.get(i).col].value.doubleValue();
        }
        group.maximumMines = valuesSum < group.unknown.size() ? valuesSum : group.unknown.size();
    }

    void LookForMoreValues(/*
             * ref
             */Group group, int row, int col) {
        if (row != 0) {
            if (col != 0) {
                if (square[row - 1][ col - 1].value != null && square[row - 1][ col - 1].value > 0 && square[row - 1][ col - 1].inGroup == 0) {
                    square[row - 1][ col - 1].inGroup = groups.size() + 1;
                    group.known.add(new KnownPoint(row - 1, col - 1));
                }
            }

            if (square[row - 1][ col].value != null && square[row - 1][ col].value > 0 && square[row - 1][ col].inGroup == 0) {
                square[row - 1][ col].inGroup = groups.size() + 1;
                group.known.add(new KnownPoint(row - 1, col));
            }

            if (col != DIMH - 1) {
                if (square[row - 1][ col + 1].value != null && square[row - 1][ col + 1].value > 0 && square[row - 1][ col + 1].inGroup == 0) {
                    square[row - 1][ col + 1].inGroup = groups.size() + 1;
                    group.known.add(new KnownPoint(row - 1, col + 1));
                }
            }
        }

        if (row != DIMV - 1) {
            if (col != 0) {
                if (square[row + 1][ col - 1].value != null && square[row + 1][ col - 1].value > 0 && square[row + 1][ col - 1].inGroup == 0) {
                    square[row + 1][ col - 1].inGroup = groups.size() + 1;
                    group.known.add(new KnownPoint(row + 1, col - 1));
                }
            }

            if (square[row + 1][ col].value != null && square[row + 1][ col].value > 0 && square[row + 1][ col].inGroup == 0) {
                square[row + 1][ col].inGroup = groups.size() + 1;
                group.known.add(new KnownPoint(row + 1, col));
            }

            if (col != DIMH - 1) {
                if (square[row + 1][ col + 1].value != null && square[row + 1][ col + 1].value > 0 && square[row + 1][ col + 1].inGroup == 0) {
                    square[row + 1][ col + 1].inGroup = groups.size() + 1;
                    group.known.add(new KnownPoint(row + 1, col + 1));
                }
            }
        }

        if (col != 0) {
            if (square[row][ col - 1].value != null && square[row][ col - 1].value > 0 && square[row][ col - 1].inGroup == 0) {
                square[row][ col - 1].inGroup = groups.size() + 1;
                group.known.add(new KnownPoint(row, col - 1));
            }
        }

        if (col != DIMH - 1) {
            if (square[row][ col + 1].value != null && square[row][ col + 1].value > 0 && square[row][ col + 1].inGroup == 0) {
                square[row][ col + 1].inGroup = groups.size() + 1;
                group.known.add(new KnownPoint(row, col + 1));
            }
        }
    }

    void LookForZones() {
        int j;
        ZonePoint tmpPoint;
        int row, col;
        int tmpIndex;

        for (int i = 0; i < groups.size(); i++) {
            for (j = 0; j < groups.get(i).unknown.size(); j++) {
                row = groups.get(i).unknown.get(j).row;
                col = groups.get(i).unknown.get(j).col;

                if (square[row][ col].mine != null) {
                    continue;
                }

                if (row != DIMV - 1) {
                    if (col != DIMH - 1) {
                        if (square[row + 1][ col + 1].mine != Boolean.TRUE) {
                            if (square[row + 1][ col + 1].inGroup != i + 1) {
                                tmpPoint = new MinesweeperFlags().new ZonePoint(row + 1, col + 1);
                                if (!groups.get(i).zone.contains(tmpPoint)) {
                                    square[row + 1][ col + 1].inZone = true;
                                    groups.get(i).zone.add(tmpPoint);
                                }

                                tmpIndex = groups.get(i).zone.indexOf(tmpPoint);
                                groups.get(i).unknown.get(j).relZone.add(tmpIndex);
                            } else {
                                tmpIndex = groups.get(i).unknown.indexOf(new UnknownPoint(row + 1, col + 1));
                                if (tmpIndex != -1) {
                                    groups.get(i).unknown.get(j).relUnknown.add(tmpIndex);
                                }
                            }
                        }
                    }
                    if (col != 0) {
                        tmpPoint = new MinesweeperFlags().new ZonePoint(row + 1, col - 1);
                        if (square[row + 1][ col - 1].mine != Boolean.TRUE) {
                            if (square[row + 1][ col - 1].inGroup != i + 1) {
                                if (!groups.get(i).zone.contains(tmpPoint)) {
                                    square[row + 1][ col - 1].inZone = true;
                                    groups.get(i).zone.add(tmpPoint);
                                }

                                tmpIndex = groups.get(i).zone.indexOf(tmpPoint);
                                groups.get(i).unknown.get(j).relZone.add(tmpIndex);
                            } else {
                                tmpIndex = groups.get(i).unknown.indexOf(new UnknownPoint((tmpPoint.PointValue())));
                                if (tmpIndex != -1) {
                                    groups.get(i).unknown.get(j).relUnknown.add(tmpIndex);
                                }
                            }
                        }
                    }
                    tmpPoint = new MinesweeperFlags().new ZonePoint(row + 1, col);
                    if (square[row + 1][ col].mine != Boolean.TRUE) {
                        if (square[row + 1][ col].inGroup != i + 1) {
                            if (!groups.get(i).zone.contains(tmpPoint)) {
                                square[row + 1][ col].inZone = true;
                                groups.get(i).zone.add(tmpPoint);
                            }

                            tmpIndex = groups.get(i).zone.indexOf(tmpPoint);
                            groups.get(i).unknown.get(j).relZone.add(tmpIndex);
                        } else {
                            tmpIndex = groups.get(i).unknown.indexOf(new UnknownPoint(tmpPoint.PointValue()));
                            if (tmpIndex != -1) {
                                groups.get(i).unknown.get(j).relUnknown.add(tmpIndex);
                            }
                        }
                    }
                }

                if (col != DIMH - 1) {
                    tmpPoint = new MinesweeperFlags().new ZonePoint(row, col + 1);
                    if (square[row][ col + 1].mine != Boolean.TRUE) {
                        if (square[row][ col + 1].inGroup != i + 1) {
                            if (!groups.get(i).zone.contains(tmpPoint)) {
                                square[row][ col + 1].inZone = true;
                                groups.get(i).zone.add(tmpPoint);
                            }

                            tmpIndex = groups.get(i).zone.indexOf(tmpPoint);
                            groups.get(i).unknown.get(j).relZone.add(tmpIndex);
                        } else {
                            tmpIndex = groups.get(i).unknown.indexOf(new UnknownPoint(tmpPoint.PointValue()));
                            if (tmpIndex != -1) {
                                groups.get(i).unknown.get(j).relUnknown.add(tmpIndex);
                            }
                        }
                    }
                }
                if (col != 0) {
                    tmpPoint = new MinesweeperFlags().new ZonePoint(row, col - 1);
                    if (square[row][ col - 1].mine != Boolean.TRUE) {
                        if (square[row][ col - 1].inGroup != i + 1) {
                            if (!groups.get(i).zone.contains(tmpPoint)) {
                                square[row][ col - 1].inZone = true;
                                groups.get(i).zone.add(tmpPoint);
                            }

                            tmpIndex = groups.get(i).zone.indexOf(tmpPoint);
                            groups.get(i).unknown.get(j).relZone.add(tmpIndex);
                        } else {
                            tmpIndex = groups.get(i).unknown.indexOf(new UnknownPoint(tmpPoint.PointValue()));
                            if (tmpIndex != -1) {
                                groups.get(i).unknown.get(j).relUnknown.add(tmpIndex);
                            }
                        }
                    }
                }

                if (row != 0) {
                    if (col != DIMH - 1) {
                        tmpPoint = new MinesweeperFlags().new ZonePoint(row - 1, col + 1);
                        if (square[row - 1][ col + 1].mine != Boolean.TRUE) {
                            if (square[row - 1][ col + 1].inGroup != i + 1) {
                                if (!groups.get(i).zone.contains(tmpPoint)) {
                                    square[row - 1][ col + 1].inZone = true;
                                    groups.get(i).zone.add(tmpPoint);
                                }

                                tmpIndex = groups.get(i).zone.indexOf(tmpPoint);
                                groups.get(i).unknown.get(j).relZone.add(tmpIndex);
                            } else {
                                tmpIndex = groups.get(i).unknown.indexOf(new UnknownPoint(tmpPoint.PointValue()));
                                if (tmpIndex != -1) {
                                    groups.get(i).unknown.get(j).relUnknown.add(tmpIndex);
                                }
                            }
                        }
                    }
                    if (col != 0) {
                        tmpPoint = new MinesweeperFlags().new ZonePoint(row - 1, col - 1);
                        if (square[row - 1][ col - 1].mine != Boolean.TRUE) {
                            if (square[row - 1][ col - 1].inGroup != i + 1) {
                                if (!groups.get(i).zone.contains(tmpPoint)) {
                                    square[row - 1][ col - 1].inZone = true;
                                    groups.get(i).zone.add(tmpPoint);
                                }

                                tmpIndex = groups.get(i).zone.indexOf(tmpPoint);
                                groups.get(i).unknown.get(j).relZone.add(tmpIndex);
                            } else {
                                tmpIndex = groups.get(i).unknown.indexOf(new UnknownPoint(tmpPoint.PointValue()));
                                if (tmpIndex != -1) {
                                    groups.get(i).unknown.get(j).relUnknown.add(tmpIndex);
                                }
                            }
                        }
                    }

                    tmpPoint = new MinesweeperFlags().new ZonePoint(row - 1, col);
                    if (square[row - 1][ col].mine != Boolean.TRUE) {
                        if (square[row - 1][ col].inGroup != i + 1) {
                            if (!groups.get(i).zone.contains(tmpPoint)) {
                                square[row - 1][ col].inZone = true;
                                groups.get(i).zone.add(tmpPoint);
                            }

                            tmpIndex = groups.get(i).zone.indexOf(tmpPoint);
                            groups.get(i).unknown.get(j).relZone.add(tmpIndex);
                        } else {
                            tmpIndex = groups.get(i).unknown.indexOf(new UnknownPoint(tmpPoint.PointValue()));
                            if (tmpIndex != -1) {
                                groups.get(i).unknown.get(j).relUnknown.add(tmpIndex);
                            }
                        }
                    }
                }
            }
        }
    }

    void FindNotSoObviousMines() {
        int j;
        int row, col;
        for (int i = 0; i < groups.size(); i++) {
            row = groups.get(i).known.get(0).row;
            col = groups.get(i).known.get(0).col;

            if (square[row][ col].value < square[row][ col].adjacentMines) {
                onEvent("Error @ FindNotSoObviousMines (" + row + ", " + col + ")", Enums.EventType.ERROR);
                return;
            }

            MinesAssignment(i, 0, ((Integer) (square[row][ col].value - square[row][ col].adjacentMines)).byteValue());

            if (groups.get(i).answers.size() > 0) {
                for (j = 0; j < groups.get(i).unknown.size(); j++) {
                    if (groups.get(i).unknown.get(j).TotalTimes() == groups.get(i).answers.size()) {
                        addNotSoObviousMine(groups.get(i).unknown.get(j).row, groups.get(i).unknown.get(j).col);
                    } else if (groups.get(i).unknown.get(j).TotalTimes() == 0) {
                        addNotSoObviousNotMine(groups.get(i).unknown.get(j).row, groups.get(i).unknown.get(j).col);
                    }
                }
            } else {
                onEvent("Impossible Board (Not answers for group " + i + ")", Enums.EventType.ERROR);
                return;
            }
        }
    }

    void MinesAssignment(int groupIndex, int knownIndex, int mines) {
        boolean flag = false;
        int i1, i2, i3, i4, i5, i6, i7;
        int ini = 0;
        int cantLevel = 0;

        for (int i = 0; i < groups.get(groupIndex).unknown.size(); i++) {
            if (groups.get(groupIndex).unknown.get(i).relKnown.get(0) == knownIndex) {
                if (!flag) {
                    ini = i;
                    flag = true;
                }
                cantLevel++;
            } else {
                if (flag) {
                    break;
                }
            }
        }

        if (!flag) {
            return;
        }

        switch (mines) {
            case 1:
                for (i1 = ini; i1 < ini + cantLevel; i1++) {
                    groups.get(groupIndex).unknown.get(i1).tempMine = true;
                    IsValidAnswer(groupIndex, knownIndex + 1);
                    groups.get(groupIndex).unknown.get(i1).tempMine = false;
                }
                break;
            case 2:
                for (i1 = ini; i1 < ini + cantLevel - 1; i1++) {
                    groups.get(groupIndex).unknown.get(i1).tempMine = true;
                    for (i2 = i1 + 1; i2 < ini + cantLevel; i2++) {
                        groups.get(groupIndex).unknown.get(i2).tempMine = true;
                        IsValidAnswer(groupIndex, knownIndex + 1);
                        groups.get(groupIndex).unknown.get(i2).tempMine = false;
                    }
                    groups.get(groupIndex).unknown.get(i1).tempMine = false;
                }
                break;
            case 3:
                for (i1 = ini; i1 < ini + cantLevel - 2; i1++) {
                    groups.get(groupIndex).unknown.get(i1).tempMine = true;
                    for (i2 = i1 + 1; i2 < ini + cantLevel - 1; i2++) {
                        groups.get(groupIndex).unknown.get(i2).tempMine = true;
                        for (i3 = i2 + 1; i3 < ini + cantLevel; i3++) {
                            groups.get(groupIndex).unknown.get(i3).tempMine = true;
                            IsValidAnswer(groupIndex, knownIndex + 1);
                            groups.get(groupIndex).unknown.get(i3).tempMine = false;
                        }
                        groups.get(groupIndex).unknown.get(i2).tempMine = false;
                    }
                    groups.get(groupIndex).unknown.get(i1).tempMine = false;
                }
                break;
            case 4:
                for (i1 = ini; i1 < ini + cantLevel - 3; i1++) {
                    groups.get(groupIndex).unknown.get(i1).tempMine = true;
                    for (i2 = i1 + 1; i2 < ini + cantLevel - 2; i2++) {
                        groups.get(groupIndex).unknown.get(i2).tempMine = true;
                        for (i3 = i2 + 1; i3 < ini + cantLevel - 1; i3++) {
                            groups.get(groupIndex).unknown.get(i3).tempMine = true;
                            for (i4 = i3 + 1; i4 < ini + cantLevel; i4++) {
                                groups.get(groupIndex).unknown.get(i4).tempMine = true;
                                IsValidAnswer(groupIndex, knownIndex + 1);
                                groups.get(groupIndex).unknown.get(i4).tempMine = false;
                            }
                            groups.get(groupIndex).unknown.get(i3).tempMine = false;
                        }
                        groups.get(groupIndex).unknown.get(i2).tempMine = false;
                    }
                    groups.get(groupIndex).unknown.get(i1).tempMine = false;
                }
                break;
            case 5:
                for (i1 = ini; i1 < ini + cantLevel - 4; i1++) {
                    groups.get(groupIndex).unknown.get(i1).tempMine = true;
                    for (i2 = i1 + 1; i2 < ini + cantLevel - 3; i2++) {
                        groups.get(groupIndex).unknown.get(i2).tempMine = true;
                        for (i3 = i2 + 1; i3 < ini + cantLevel - 2; i3++) {
                            groups.get(groupIndex).unknown.get(i3).tempMine = true;
                            for (i4 = i3 + 1; i4 < ini + cantLevel - 1; i4++) {
                                groups.get(groupIndex).unknown.get(i4).tempMine = true;
                                for (i5 = i4 + 1; i5 < ini + cantLevel; i5++) {
                                    groups.get(groupIndex).unknown.get(i5).tempMine = true;
                                    IsValidAnswer(groupIndex, knownIndex + 1);
                                    groups.get(groupIndex).unknown.get(i5).tempMine = false;
                                }
                                groups.get(groupIndex).unknown.get(i4).tempMine = false;
                            }
                            groups.get(groupIndex).unknown.get(i3).tempMine = false;
                        }
                        groups.get(groupIndex).unknown.get(i2).tempMine = false;
                    }
                    groups.get(groupIndex).unknown.get(i1).tempMine = false;
                }
                break;
            case 6:
                for (i1 = ini; i1 < ini + cantLevel - 5; i1++) {
                    groups.get(groupIndex).unknown.get(i1).tempMine = true;
                    for (i2 = i1 + 1; i2 < ini + cantLevel - 4; i2++) {
                        groups.get(groupIndex).unknown.get(i2).tempMine = true;
                        for (i3 = i2 + 1; i3 < ini + cantLevel - 3; i3++) {
                            groups.get(groupIndex).unknown.get(i3).tempMine = true;
                            for (i4 = i3 + 1; i4 < ini + cantLevel - 2; i4++) {
                                groups.get(groupIndex).unknown.get(i4).tempMine = true;
                                for (i5 = i4 + 1; i5 < ini + cantLevel - 1; i5++) {
                                    groups.get(groupIndex).unknown.get(i5).tempMine = true;
                                    for (i6 = i5 + 1; i6 < ini + cantLevel; i6++) {
                                        groups.get(groupIndex).unknown.get(i6).tempMine = true;
                                        IsValidAnswer(groupIndex, knownIndex + 1);
                                        groups.get(groupIndex).unknown.get(i6).tempMine = false;
                                    }
                                    groups.get(groupIndex).unknown.get(i5).tempMine = false;
                                }
                                groups.get(groupIndex).unknown.get(i4).tempMine = false;
                            }
                            groups.get(groupIndex).unknown.get(i3).tempMine = false;
                        }
                        groups.get(groupIndex).unknown.get(i2).tempMine = false;
                    }
                    groups.get(groupIndex).unknown.get(i1).tempMine = false;
                }
                break;
            case 7:
                for (i1 = ini; i1 < ini + cantLevel - 6; i1++) {
                    groups.get(groupIndex).unknown.get(i1).tempMine = true;
                    for (i2 = i1 + 1; i2 < ini + cantLevel - 5; i2++) {
                        groups.get(groupIndex).unknown.get(i2).tempMine = true;
                        for (i3 = i2 + 1; i3 < ini + cantLevel - 4; i3++) {
                            groups.get(groupIndex).unknown.get(i3).tempMine = true;
                            for (i4 = i3 + 1; i4 < ini + cantLevel - 3; i4++) {
                                groups.get(groupIndex).unknown.get(i4).tempMine = true;
                                for (i5 = i4 + 1; i5 < ini + cantLevel - 2; i5++) {
                                    groups.get(groupIndex).unknown.get(i5).tempMine = true;
                                    for (i6 = i5 + 1; i6 < ini + cantLevel - 1; i6++) {
                                        groups.get(groupIndex).unknown.get(i6).tempMine = true;
                                        for (i7 = i6 + 1; i7 < ini + cantLevel; i7++) {
                                            groups.get(groupIndex).unknown.get(i7).tempMine = true;
                                            IsValidAnswer(groupIndex, knownIndex + 1);
                                            groups.get(groupIndex).unknown.get(i7).tempMine = false;
                                        }
                                        groups.get(groupIndex).unknown.get(i6).tempMine = false;
                                    }
                                    groups.get(groupIndex).unknown.get(i5).tempMine = false;
                                }
                                groups.get(groupIndex).unknown.get(i4).tempMine = false;
                            }
                            groups.get(groupIndex).unknown.get(i3).tempMine = false;
                        }
                        groups.get(groupIndex).unknown.get(i2).tempMine = false;
                    }
                    groups.get(groupIndex).unknown.get(i1).tempMine = false;
                }
                break;
        }
    }

    void IsValidAnswer(int groupIndex, int knownIndex) {
    	if (interruptCheck.isInterrupted()) {
            throw new RuntimeTimeoutException();
        }

        if (knownIndex == groups.get(groupIndex).known.size()) {
            addAnswer(groupIndex);
        } else {
            int mines;
            int row, col;

            CountAdjacentsTempMines(groupIndex);
            row = groups.get(groupIndex).known.get(knownIndex).row;
            col = groups.get(groupIndex).known.get(knownIndex).col;

            mines = square[row][ col].value.intValue() - groups.get(groupIndex).known.get(knownIndex).tempMines - square[row][ col].adjacentMines;

            if (mines == 0 && knownIndex == groups.get(groupIndex).known.size() - 1) {
                addAnswer(groupIndex);
            } else if (mines == 0 && knownIndex != groups.get(groupIndex).known.size() - 1) {
                do {
                    knownIndex++;
                    row = groups.get(groupIndex).known.get(knownIndex).row;
                    col = groups.get(groupIndex).known.get(knownIndex).col;
                    mines = square[row][ col].value.intValue() - groups.get(groupIndex).known.get(knownIndex).tempMines - square[row][ col].adjacentMines;
                } while (mines == 0 && knownIndex != groups.get(groupIndex).known.size() - 1);
                if ((mines == 0 && knownIndex == groups.get(groupIndex).known.size() - 1) || knownIndex == groups.get(groupIndex).known.size()) {
                    addAnswer(groupIndex);
                }
            }

            if (mines > 0) {
                MinesAssignment(groupIndex, knownIndex, mines);
            }
        }
    }

    void CountAdjacentsTempMines(int groupIndex) {
        int i, j;
        int n1, n2;

        n1 = groups.get(groupIndex).known.size();
        for (i = 0; i < n1; i++) {
            groups.get(groupIndex).known.get(i).tempMines = 0;
        }

        n1 = groups.get(groupIndex).unknown.size();
        for (i = 0; i < n1; i++) {
            if (groups.get(groupIndex).unknown.get(i).tempMine) {
                n2 = groups.get(groupIndex).unknown.get(i).relKnown.size();
                for (j = 0; j < n2; j++) {
                    groups.get(groupIndex).known.get(groups.get(groupIndex).unknown.get(i).relKnown.get(j)).tempMines++;
                }
            }
        }
    }
    /**
     * Translation checked at 2013-02-05 22:04 by Simon
     * @param groupIndex
     */
    void addAnswer(final int groupIndex) {
        int i, j;
        Group group = groups.get(groupIndex);
        boolean[] tmpAnswer = new boolean[group.unknown.size()];
        int contMines = 0, adjacentTempMines;
        int tmpIndex;

        for (i = 0; i < group.unknown.size(); i++) {
            if (groups.get(groupIndex).unknown.get(i).tempMine) {
                contMines++;
            }
        }
        for (i = 0; i < group.zone.size(); i++) {
            group.zone.get(i).adjacentTempMines = 0;
        }
        for (i = 0; i < group.unknown.size(); i++) {
            group.unknown.get(i).adjacentTempMines = 0;
        }

        if (contMines <= leftMines) {
            for (i = 0; i < group.unknown.size(); i++) {
            	UnknownPoint unknown = groups.get(groupIndex).unknown.get(i);
            	
                if (unknown.tempMine) {
                    tmpAnswer[i] = true;

                    if (unknown.times.containsKey(contMines)) {
                    	unknown.times.put(contMines, unknown.times.get(contMines) + 1);
                    } else {
                        unknown.times.put(contMines, 1);
                    }

                    for (j = 0; j < unknown.relUnknown.size(); j++) {
                        tmpIndex = unknown.relUnknown.get(j);
                        group.unknown.get(tmpIndex).adjacentTempMines++;
                    }

                    for (j = 0; j < unknown.relZone.size(); j++) {
                        tmpIndex = unknown.relZone.get(j);
                        group.zone.get(tmpIndex).adjacentTempMines++;
                    }
                }
            }

            for (i = 0; i < group.unknown.size(); i++) {
                if (!group.unknown.get(i).tempMine) {
                    adjacentTempMines = group.unknown.get(i).adjacentTempMines;
                    group.unknown.get(i).adjacents[contMines][ adjacentTempMines]++;
                }
            }

            for (i = 0; i < group.zone.size(); i++) {
                adjacentTempMines = group.zone.get(i).adjacentTempMines;
                group.zone.get(i).adjacents[contMines][ adjacentTempMines]++;
            }

            group.answers.add(tmpAnswer);
            group.answersCount.add(contMines);
        }
    }

//		#endregion
//		#region - Last Step -
    void LastStep() {
        if (groups.size() > 0) {
            onEvent("Calculate Frequencies", Enums.EventType.INFO);
            CalculateFrequencies();
            onEventLog("CalculateFrequencies", Enums.LogLevel.TRACE);
            PermutateFrequencies();
            onEventLog("PermutateFrequencies", Enums.LogLevel.TRACE);
        }

        onEvent("Open Sea", Enums.EventType.INFO);
        LookForOpenSea();
        onEventLog("LookForOpenSea", Enums.LogLevel.TRACE);

        onEvent("Frequencies", Enums.EventType.INFO);
        CalculatePermutationProbabilityAndLeftMines();
        onEventLog("CalculatePermutationProbabilityAndLeftMines", Enums.LogLevel.TRACE);
        CalculateFrequenciesProbability();
        onEventLog("CalculateFrequenciesProbability", Enums.LogLevel.TRACE);

        onEvent("Probability in Open Sea", Enums.EventType.INFO);
        CalculateProbabilityInOpenSea();
        onEventLog("CalculateProbabilityInOpenSea", Enums.LogLevel.TRACE);

        onEvent("Probability in Groups", Enums.EventType.INFO);
        CalculateProbabilityInGroups();
        onEventLog("CalculateProbabilityInGroups", Enums.LogLevel.TRACE);

        onEvent("Regions", Enums.EventType.INFO);
        CalculateRegions();
        onEventLog("CalculateRegions", Enums.LogLevel.TRACE);

        UpdateLogicBoard();
        if (level < MAXLEVEL) {
            onEvent("Next Level", Enums.EventType.INFO);
            ProcessSecondExpectedValue();
            onEvent("FirstExpectedValue", Enums.EventType.INFO);
            CalculateFirstExpectedValue();
            onEvent("SecondExpectedValue", Enums.EventType.INFO);
            CalculateExpectedValue();
        } else {
            onEvent("Payoffs", Enums.EventType.INFO);
            CalculateSecurePayoff();
            if (FASTMODE) {
                CalculateFastPayoff();
                CalculateGroupsPayoff();
                CalculateZonePayoff();
            } else {
                CalculatePayoff();
            }
            onEvent("FirstExpectedValue", Enums.EventType.INFO);
            CalculateFirstExpectedValue();
        }

        lastStep = true;
        onEventLog("Last Step", Enums.LogLevel.DEBUG);
    }

    void CalculateFrequencies() {
        for (int i = 0; i < groups.size(); i++) {
            answersFrequencies.add(groups.get(i).Frequency());
        }
    }

    void PermutateFrequencies() {
        PermutateFrequencies(new Permutation(), 0);
    }

    void PermutateFrequencies(Permutation permutation, int index) {
        for (int i = 0; i < answersFrequencies.get(index).length; i++) {
            Frequency frequency = answersFrequencies.get(index)[i];
            if (frequency.times != 0) {
                permutation.groupIndex.add(i);
                permutation.nPermutation *= frequency.times;
                if (index == answersFrequencies.size() - 1) {
                    permutations.add(new Permutation(permutation));
                    totalCases += permutation.nPermutation;
                } else {
                    PermutateFrequencies(permutation, index + 1);
                }
                permutation.nPermutation /= frequency.times;
                permutation.groupIndex.remove(permutation.groupIndex.size() - 1);
            }
        }
    }

    void LookForOpenSea() {
        openSeaCount = 0;

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                if (square[i][j].mine == null && square[i][j].inGroup == 0) {
                    addOpenSeaSquare(i, j);
                }
            }
        }
    }

    public void addOpenSeaSquare(int i, int j) {
        openSeaCount++;
        openSea[i][j] = true;

        if (i != DIMV - 1) {
            if (j != DIMH - 1) {
                square[i + 1][ j + 1].adjacentsOpenSea++;
            }
            if (j != 0) {
                square[i + 1][ j - 1].adjacentsOpenSea++;
            }
            square[i + 1][ j].adjacentsOpenSea++;
        }

        if (j != DIMH - 1) {
            square[i][ j + 1].adjacentsOpenSea++;
        }
        if (j != 0) {
            square[i][ j - 1].adjacentsOpenSea++;
        }

        if (i != 0) {
            if (j != DIMH - 1) {
                square[i - 1][ j + 1].adjacentsOpenSea++;
            }
            if (j != 0) {
                square[i - 1][ j - 1].adjacentsOpenSea++;
            }
            square[i - 1][ j].adjacentsOpenSea++;
        }
    }

    void CalculatePermutationProbabilityAndLeftMines() {
        double total = 0;

        for (int i = 0; i < permutations.size(); i++) {
            permutations.get(i).nPermutation *= Combinatory.BinomialCoefficient((int) leftMines - permutations.get(i).mines, openSeaCount);
            total += permutations.get(i).nPermutation;
        }

        for (int i = 0; i < permutations.size(); i++) {
            permutations.get(i).probability = permutations.get(i).nPermutation / total;
            leftMines -= permutations.get(i).probability * (double) permutations.get(i).mines;
        }
    }

    void CalculateFrequenciesProbability() {
        for (int i = 0; i < groups.size(); i++) {
            for (int j = 0; j < groups.get(i).Frequency().length; j++) {
                for (Permutation permutation : permutations) {
                    if (permutation.groupIndex.get(i) == j) {
//                    	groups.get(i).Frequency()[j].probability += permutation.probability;
                    	Frequency freq = groups.get(i).Frequency()[j];
                    	freq.setProbability(freq.getProbability() + permutation.probability);
                    }
                }
            }
        }
    }

    void CalculateProbabilityInOpenSea() {
        if (openSeaCount == 0) {
            return;
        }

        double openSeaProbability = leftMines / (double) openSeaCount;

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                if (openSea[i][j]) {
                    square[i][j].probability[9] = openSeaProbability;
                    for (int k = 0; k <= square[i][j].adjacentsOpenSea && k <= leftMines; k++) {
                        square[i][j].probability[k + square[i][j].adjacentMines] = Combinatory.HypergeometricDistributionVariation(k, square[i][j].adjacentsOpenSea, (int) leftMines, openSeaCount);
                    }
                } else if (square[i][j].mine != Boolean.TRUE) {
                    for (int k = 0; k <= square[i][j].adjacentsOpenSea && k <= leftMines; k++) {
                        square[i][j].probability[k + square[i][j].adjacentMines] = Combinatory.HypergeometricDistribution(k, square[i][j].adjacentsOpenSea, (int) leftMines, openSeaCount);
                    }
                }
            }
        }
    }
    /**
     * Translation OK. Checked by Zomis at 2013-02-03 21:58
     */
    void CalculateProbabilityInGroups() {
        int row, col;
        Integer tmpM;
        int i, j, k, l;

        //Probability in Groups
        for (i = 0; i < groups.size(); i++) {
            for (j = 0; j < groups.get(i).unknown.size(); j++) {
                row = groups.get(i).unknown.get(j).row;
                col = groups.get(i).unknown.get(j).col;

                // Probability of mine
                if (square[row][ col].probability[9] != 1D) {
                    for (k = 0; k < groups.get(i).Frequency().length; k++) {
                        //if (groups.get(i).unknown.get(j).times.TryGetValue(k,tmpM))
                        tmpM = groups.get(i).unknown.get(j).times.get(k);
                        if (tmpM == null) tmpM = 0;
                        else {
                            square[row][ col].probability[9] += tmpM * groups.get(i).Frequency()[k].div;
                        }

                    }
                }
                //

                // Probability of adjacents mines in group
                double[] tmpProbability = new double[9];
                for (k = 1; k < groups.get(i).unknown.get(j).adjacents.length; k++) {
                    for (l = (square[row][ col].adjacentMines - square[row][ col].adjacentFixedMines); l < groups.get(i).unknown.get(j).adjacents[0].length; l++) {
                        if (groups.get(i).unknown.get(j).adjacents[k][ l] != 0) {
                            tmpProbability[l - (square[row][ col].adjacentMines - square[row][ col].adjacentFixedMines)] +=
                            		groups.get(i).unknown.get(j).adjacents[k][ l] * groups.get(i).Frequency()[k].div;
                            //tmpProbability[l + square[row][ col].adjacentFixedMines] += groups.get(i).unknown.get(j).adjacents[k][ l] * groups.get(i).Frequency[k].div;
                        }
                    }
                }

                //Merge Probabilities
                for (k = 8; k >= 0; k--) {
                    square[row][ col].probability[k] = square[row][ col].probability[k] * tmpProbability[0];
                    for (l = 1; l <= k; l++) {
                        square[row][ col].probability[k] += square[row][ col].probability[k - l] * tmpProbability[l];
                    }
                }
            }

            for (j = 0; j < groups.get(i).zone.size(); j++) {
                row = groups.get(i).zone.get(j).row;
                col = groups.get(i).zone.get(j).col;

                //Probability of adjacents in Zones
                double[] tmpProbability = new double[9];
                for (k = 1; k < groups.get(i).zone.get(j).adjacents.length; k++) {
                    for (l = (square[row][ col].adjacentMines - square[row][ col].adjacentFixedMines); l < groups.get(i).zone.get(j).adjacents[0].length; l++) {
                        if (groups.get(i).zone.get(j).adjacents[k][ l] != 0) {
                            tmpProbability[l - (square[row][ col].adjacentMines - square[row][ col].adjacentFixedMines)] += groups.get(i).zone.get(j).adjacents[k][ l] * groups.get(i).Frequency()[k].div;
                        }
                    }
                }

                //Merge Probabilities
                for (k = 8; k >= 0; k--) {
                    square[row][ col].probability[k] = square[row][ col].probability[k] * tmpProbability[0];
                    for (l = 1; l <= k; l++) {
                        square[row][ col].probability[k] += square[row][ col].probability[k - l] * tmpProbability[l];
                    }
                }
            }
        }
    }

    void CalculateRegions() {
        int id = 1;
        for (int yy = 0; yy < DIMV; yy++) {
            for (int xx = 0; xx < DIMH; xx++) {
                if (square[yy][xx].value == null && square[yy][xx].region == 0) {
                    if (square[yy][xx].mine != Boolean.TRUE) {
                        LookForRegion(yy, xx, id++);
                    }
                }
            }
        }
    }

    void LookForRegion(int i, int j, int id) {
        Point tempPoint;
        Region region = new Region();
        region.squaresCount = 0;
        region.mineProbability = 0;
        Stack<Point> stack = new Stack<Point>();
        stack.push(new Point(i, j));
        square[i][j].region = id;

        do {
            tempPoint = stack.pop();
            i = tempPoint.row;
            j = tempPoint.col;
            region.mineProbability += square[i][j].probability[9];
            region.squaresCount++;

            if (i != DIMV - 1) {
                if (j != DIMH - 1) {
                    if (square[i + 1][ j + 1].value == null && square[i + 1][ j + 1].region == 0) {
                        if (square[i + 1][ j + 1].mine != Boolean.TRUE) {
                            square[i + 1][ j + 1].region = id;
                            stack.push(new Point(i + 1, j + 1));
                        }
                    }
                }
                if (j != 0) {
                    if (square[i + 1][ j - 1].value == null && square[i + 1][ j - 1].region == 0) {
                        if (square[i + 1][ j - 1].mine != Boolean.TRUE) {
                            square[i + 1][ j - 1].region = id;
                            stack.push(new Point(i + 1, j - 1));
                        }
                    }
                }
                if (square[i + 1][ j].value == null && square[i + 1][ j].region == 0) {
                    if (square[i + 1][ j].mine != Boolean.TRUE) {
                        square[i + 1][ j].region = id;
                        stack.push(new Point(i + 1, j));
                    }
                }
            }

            if (j != DIMH - 1) {
                if (square[i][ j + 1].value == null && square[i][ j + 1].region == 0) {
                    if (square[i][ j + 1].mine != Boolean.TRUE) {
                        square[i][ j + 1].region = id;
                        stack.push(new Point(i, j + 1));
                    }
                }
            }
            if (j != 0) {
                if (square[i][ j - 1].value == null && square[i][ j - 1].region == 0) {
                    if (square[i][ j - 1].mine != Boolean.TRUE) {
                        square[i][ j - 1].region = id;
                        stack.push(new Point(i, j - 1));
                    }
                }
            }

            if (i != 0) {
                if (j != DIMH - 1) {
                    if (square[i - 1][ j + 1].value == null && square[i - 1][ j + 1].region == 0) {
                        if (square[i - 1][ j + 1].mine != Boolean.TRUE) {
                            square[i - 1][ j + 1].region = id;
                            stack.push(new Point(i - 1, j + 1));
                        }
                    }
                }
                if (j != 0) {
                    if (square[i - 1][ j - 1].value == null && square[i - 1][ j - 1].region == 0) {
                        if (square[i - 1][ j - 1].mine != Boolean.TRUE) {
                            square[i - 1][ j - 1].region = id;
                            stack.push(new Point(i - 1, j - 1));
                        }
                    }
                }

                if (square[i - 1][ j].value == null && square[i - 1][ j].region == 0) {
                    if (square[i - 1][ j].mine != Boolean.TRUE) {
                        square[i - 1][ j].region = id;
                        stack.push(new Point(i - 1, j));
                    }
                }
            }
        } while (stack.size() > 0);

        regions.add(region);
    }

    void CalculateSecurePayoff() {
        double tempPayoff;
        double aproxPayoff;
        int index;
        int i, j;

        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                //Expansion Payoff 
                if (square[i][j].probability[0] > 0D && square[i][j].region != 0) {
                    if (square[i][j].adjacents == regions.get(square[i][j].region - 1).squaresCount - 1) {
                        square[i][j].payoff[0] = 0;
                    } else {
                        //tempPayoff = regions[square[i][j].region - 1].mineProbability;
                        tempPayoff = regions.get(square[i][j].region - 1).mineProbability - square[i][j].probability[9];
                        aproxPayoff = CalculateMMF(regions.get(square[i][j].region - 1).squaresCount);
                        square[i][j].payoff[0] = aproxPayoff < tempPayoff ? aproxPayoff : tempPayoff;
                    }
                }

                //Secure mine payoff
                if (square[i][j].probability[9] == 1D) {
                    square[i][j].payoff[9] = 1D;
                }

                //Obvious payoff
                index = square[i][j].adjacentMines + square[i][j].adjacents;
                if (square[i][j].probability[index] > 0D && index != 0) {
                    if (openSeaCount - 1 != leftMines) {
                        square[i][j].payoff[index] = square[i][j].adjacents;
                    } else {
                        square[i][j].payoff[index] = leftMines;
                    }
                }
            }
        }
    }

    void CalculatePayoff() {
        Board tempBoard;
        char[][] tempLogicBoard;
        int i, j, k;

        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                //Payoff of mine
                if (square[i][j].probability[9] > 0D && square[i][j].probability[9] < 1D) {
                    tempLogicBoard = NightmareTools.megaClone(logicBoard);
                    tempLogicBoard[i][j] = 'm';
                    tempBoard = new Board(interruptCheck, tempLogicBoard, level + 1, MAXLEVEL);
                    square[i][j].payoff[9] = 1 + tempBoard.obviousMinesCount + tempBoard.notSoobviousMinesCount;
                }

                //Other payoff [1-8]
                for (k = 1; k <= square[i][j].adjacentMines + square[i][j].adjacents; k++) {
                    if (square[i][j].probability[k] > 0D) {
                        tempLogicBoard = NightmareTools.megaClone(logicBoard);
                        tempLogicBoard[i][j] = (char) (k + 48);

                        tempBoard = new Board(interruptCheck, tempLogicBoard, level + 1, MAXLEVEL);
                        square[i][j].payoff[k] = tempBoard.obviousMinesCount + tempBoard.notSoobviousMinesCount;
                    }
                }
            }
        }
    }

    void CalculateFastPayoff() {
        int i, j;
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                if (square[i][j].mine == null) {
                    square[i][j].payoff[9] = 1D;
                }

                //Payoff cuando la cantidad de adyacentes es igual a la cantidad de minas restantes
                if (square[i][j].inGroup == 0) {
                    if (square[i][j].mine == Boolean.FALSE) {
                        if (openSeaCount - square[i][j].adjacents == leftMines) {
                            square[i][j].payoff[square[i][j].adjacentMines] = leftMines;
                        }
                    } else {
                        if (openSeaCount - square[i][j].adjacents - 1 == leftMines) {
                            square[i][j].payoff[square[i][j].adjacentMines] = leftMines;
                        }
                    }
                }
            }
        }
    }
    /**
     * Checked by Simon 2013-02-11
     */
    void CalculateGroupsPayoff() {
        int row, col;
        int index, cont;
        boolean[][] tmpVector;
        int[][] payoff;

        for (Group group : groups) {
            payoff = new int[group.unknown.size()][2];

            for (int i = 0; i < group.unknown.size(); i++) {
                tmpVector = new boolean[group.unknown.size()][2];

                for (int j = 0; j < group.unknown.size(); j++) {
                    tmpVector[j][ 0] = true;
                    tmpVector[j][ 1] = true;
                }

                for (boolean[] answer : group.answers) {
                    if (!answer[i]) {
                        for (int j = 0; j < group.unknown.size(); j++) {
                            tmpVector[j][ 0] &= answer[j];
                        }
                    } else {
                        for (int j = 0; j < group.unknown.size(); j++) {
                            tmpVector[j][ 1] &= answer[j];
                        }
                    }
                }

                for (int j = 0; j < 2; j++) {
                    cont = 0;
                    for (int k = 0; k < group.unknown.size(); k++) {
                        row = group.unknown.get(k).row;
                        col = group.unknown.get(k).col;

                        if (tmpVector[k][ j] && square[row][ col].mine == null) {
                            cont++;
                        }
                    }
                    payoff[i][j] = cont;
                }
            }

            /////////////

            for (int i = 0; i < group.unknown.size(); i++) {
                row = group.unknown.get(i).row;
                col = group.unknown.get(i).col;

                index = square[row][ col].adjacentFixedMines + square[row][ col].adjacentsOpenSea + group.unknown.get(i).MaxAdjacentMines();
                if (square[row][ col].payoff[index] == 0) {
                    square[row][ col].payoff[index] = square[row][ col].adjacentsOpenSea;
                }

                square[row][ col].payoff[9] = payoff[i][ 1];

                for (int j = 1; j < 8; j++) {
                    if (square[row][ col].probability[j] > 0D) {
                        if (j != square[row][ col].adjacents + square[row][ col].adjacentMines) {
                            square[row][ col].payoff[j] += payoff[i][ 0];
                        }
                    }
                }
            }
        }
    }
    /**
     * Checked by Simon at 2013-02-11
     * */
    void CalculateZonePayoff() {
        int row, col, index;

        for (int j = 0; j < groups.size(); j++) {
            for (int i = 0; i < groups.get(j).zone.size(); i++) {
                row = groups.get(j).zone.get(i).row;
                col = groups.get(j).zone.get(i).col;

                index = square[row][ col].adjacentFixedMines + square[row][ col].adjacentsOpenSea + groups.get(j).zone.get(i).MaxAdjacentMines();
                if (square[row][ col].payoff[index] == 0) {
                    square[row][ col].payoff[index] = square[row][ col].adjacentsOpenSea;
                }
            }
        }
    }

    double CalculateMMF(int x) {
        return (0.0269 * 32.0431 + 11.7807 * Math.pow(x, 0.6910)) / (32.0431 + Math.pow(x, 0.6910));
    }

    void ProcessSecondExpectedValue() {
        char[][] tempLogicBoard;
        Board tempBoard;
        double aproxPayoff, tempPayoff;

        if (!PARETO) {
            for (int i = 0; i < DIMV; i++) {
                for (int j = 0; j < DIMH; j++) {
                    if (square[i][j].probability[0] > 0D && square[i][j].region != 0) {
                        if (square[i][j].adjacents == regions.get(square[i][j].region - 1).squaresCount - 1) {
                            square[i][j].payoff[0] = 0;
                        } else {
                            tempPayoff = regions.get(square[i][j].region - 1).mineProbability;
                            aproxPayoff = CalculateMMF(regions.get(square[i][j].region - 1).squaresCount);
                            square[i][j].payoff[0] = aproxPayoff < tempPayoff ? aproxPayoff : tempPayoff;
                        }
                    }
                    for (int k = 1; k <= 9; k++) {
                        if (square[i][j].probability[k] > 0D && (!openSea[i][j] || square[i][j].inZone)) {
                            tempLogicBoard = NightmareTools.megaClone(logicBoard);
                            tempLogicBoard[i][j] = (k != 9) ? (char) (k + 48) : 'm';

                            tempBoard = new Board(interruptCheck, tempLogicBoard, level + 1, MAXLEVEL);
                            tempBoard.FASTMODE = true;
                            tempBoard.Solve();

                            square[i][j].payoff[k] = (k != 9) ? tempBoard.foundMines : (tempBoard.foundMines + 1);
                            square[i][j].expectedValues[k] = tempBoard.maxFirstExpectedValue;
                        }
                    }
                    onEvent(((i * DIMV) + j + DIMH) / (DIMH * DIMV), Enums.EventType.PROGRESS);
                }
            }
        } else {
            boolean[][] bestMaxExpectedValuePoints = this.BestMaxExpectedValuePoints();

            for (int i = 0; i < DIMH; i++) {
                for (int j = 0; j < DIMV; j++) {
                    if (!bestMaxExpectedValuePoints[i][j]) {
                        continue;
                    }

                    if (square[i][j].probability[0] > 0D) {
                        tempPayoff = regions.get(square[i][j].region - 1).mineProbability;
                        aproxPayoff = CalculateMMF(regions.get(square[i][j].region - 1).squaresCount);
                        square[i][j].payoff[0] = aproxPayoff < tempPayoff ? aproxPayoff : tempPayoff;
                    }
                    for (int k = 1; k <= 9; k++) {
                        if (square[i][j].probability[k] > 0D) {
                            //				logicBoard.CopyTo(tempLogicBoard, 0);
                            tempLogicBoard = NightmareTools.megaClone(logicBoard);
                            if (k != 9) {
                                tempLogicBoard[i][j] = (char) (k + 48);
                            } else {
                                tempLogicBoard[i][j] = 'm';
                            }
                            tempBoard = new Board(interruptCheck, tempLogicBoard, level + 1, MAXLEVEL);
                            tempBoard.Solve();
                            if (k != 9) {
                                square[i][j].payoff[k] = tempBoard.foundMines;
                            } else {
                                square[i][j].payoff[k] = tempBoard.foundMines + 1;
                            }

                            square[i][j].expectedValues[k] = tempBoard.maxFirstExpectedValue;
                        }
                    }
                }
            }
        }
    }

    void CalculateFirstExpectedValue() {
        maxFirstExpectedValue = -(double) MINES;
        minFirstExpectedValue = (double) MINES;

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                if (square[i][j].value == null && square[i][j].mine != Boolean.TRUE && square[i][j].probability[9] != 1D) {
                    square[i][j].firstExpectedValue = square[i][j].probability[9] * square[i][j].payoff[9];

                    for (int k = 0; k < 9; k++) {
                        if (square[i][j].probability[k] > 0D) {
                            if (square[i][j].firstExpectedValue != null) {
                                square[i][j].firstExpectedValue -= square[i][j].probability[k] * square[i][j].payoff[k];
                            } else {
                                square[i][j].firstExpectedValue = -square[i][j].probability[k] * square[i][j].payoff[k];
                            }
                        }
                    }
                    if (square[i][j].firstExpectedValue < minFirstExpectedValue) {
                        minFirstExpectedValue = square[i][j].firstExpectedValue;
                    }
                    if (square[i][j].firstExpectedValue > maxFirstExpectedValue) {
                        maxFirstExpectedValue = square[i][j].firstExpectedValue;
                    }
                }
            }
        }
    }

    void CalculateExpectedValue() {
        double expectedValue;

        maxExpectedValue = (double) -MINES;
        minExpectedValue = (double) MINES;

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                if (square[i][j].value == null && square[i][j].mine == null && square[i][j].probability[9] != 1D) {
                    expectedValue = square[i][j].probability[9] * (square[i][j].payoff[9] + square[i][j].expectedValues[9]);

                    for (int k = 0; k < 9; k++) {
                        expectedValue -= square[i][j].probability[k] * (square[i][j].payoff[k] + square[i][j].expectedValues[k]);
                    }

                    square[i][j].expectedValue = expectedValue;

                    if (expectedValue < minExpectedValue) {
                        minExpectedValue = expectedValue;
                    }
                    if (expectedValue > maxExpectedValue) {
                        maxExpectedValue = expectedValue;
                    }
                }
            }
        }
    }

//		#endregion
//		#region - additional Step -
    void additionalStep() {
        if (level == 1) {
            onEvent("Bomb", Enums.EventType.INFO);
            CalculateBombProbability();

            onEvent("WriteToFile", Enums.EventType.INFO);
            onEventLog("Last Board", Enums.LogLevel.INFO);
        }
    }

    void CalculateBombProbability() {
        int cont;
        int i, j, i2, j2, k;
        for (i = 2; i < DIMV - 2; i++) {
            for (j = 2; j < DIMH - 2; j++) {
                cont = 0;
                for (i2 = i - 2; i2 <= i + 2; i2++) {
                    for (j2 = j - 2; j2 <= j + 2; j2++) {
                        if (openSea[i2][ j2]) {
                            cont++;
                        }
                    }
                }
                for (k = 0; k <= 25; k++) {
                	if (square[i][j].bombProbability == null) throw new NullPointerException("bombProbability not set at " + i + ", " + j);
                	
                    square[i][j].bombProbability[k] = Combinatory.HypergeometricDistribution(k, cont, (int) leftMines, openSeaCount);
                }
            }
        }
    }

//		#endregion
    void UpdateLogicBoard() {
        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                if (obviousMines[i][j] || notSoObviousMines[i][j]) {
                    logicBoard[i][j] = 'm';
                } else if (obviousNotMines[i][j] || notSoObviousNotMines[i][j]) {
                    logicBoard[i][j] = 'w';
                }
            }
        }
    }

    void ClearBoardMemory() {
        leftMines = MINES;
        solved = false;
        firstStep = false;
        lastStep = false;

        initialMines = 0;
        initialRedMines = 0;
        initialBlueMines = 0;

        obviousMinesCount = 0;
        obviousNotMinesCount = 0;
        notSoobviousMinesCount = 0;
        notSoobviousNotMinesCount = 0;

        square = new Square[DIMV][DIMH];
        this.initSquares();
        openSea = new boolean[DIMV][DIMH];

        regions.clear();
        groups.clear();
        permutations.clear();
        answersFrequencies.clear();

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                obviousMines[i][j] = false;
                obviousNotMines[i][j] = false;
                notSoObviousMines[i][j] = false;
                notSoObviousNotMines[i][j] = false;
                square[i][j].probability = new double[10];
                square[i][j].payoff = new double[10];
                square[i][j].expectedValues = new double[10];
            }
        }
    }

    @Override
    public String toString() {
        int cont;
        String tmpString;
        StringBuilder StringBuilder = new StringBuilder();
        int i, j;

        StringBuilder.append("HORIZONTAL DIMENSION: " + DIMH);
        StringBuilder.append("\r\nVERTICAL DIMENSION: " + DIMV);
        StringBuilder.append("\r\nBOARD MINES: " + MINES);

        StringBuilder.append("\r\nLOGIC BOARD\r\n");
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                StringBuilder.append(logicBoard[i][j]);
            }
            StringBuilder.append("\n");
        }

        StringBuilder.append("Values\r\n");
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                tmpString = square[i][j].value != null ? square[i][j].value.toString() : "-";
                StringBuilder.append(tmpString);
            }
            StringBuilder.append("\n");
        }

        StringBuilder.append("Mines\r\n");
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                tmpString = square[i][j].mine != null ? (square[i][j].mine == true ? "1" : "0") : "-";
                StringBuilder.append(tmpString);
            }
            StringBuilder.append("\n");
        }

        StringBuilder.append("Virtual Value\r\n");
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                tmpString = square[i][j].value != null ? ((Integer) square[i][j].virtualValue).toString() : "-";
                StringBuilder.append(tmpString);
            }
            StringBuilder.append("\n");
        }

        StringBuilder.append("Adjacents\r\n");
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                StringBuilder.append(square[i][j].adjacents);
            }
            StringBuilder.append("\n");
        }

        StringBuilder.append("Adjacent Mines\r\n");
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                StringBuilder.append(square[i][j].adjacentMines);
            }
            StringBuilder.append("\n");
        }

        StringBuilder.append("Adjacent Values\r\n");
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                StringBuilder.append(square[i][j].adjacentValues);
            }
            StringBuilder.append("\n");
        }

        StringBuilder.append("Open Sea\r\n");
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                tmpString = openSea[i][j] ? "1 " : "0 ";
                StringBuilder.append(tmpString);
            }
            StringBuilder.append("\n");
        }

        StringBuilder.append("Adjacents OpenSea\r\n");
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                StringBuilder.append(square[i][j].adjacentsOpenSea);
            }
            StringBuilder.append("\n");
        }

        StringBuilder.append("In Group\r\n");
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                StringBuilder.append(square[i][j].inGroup);
            }
            StringBuilder.append("\n");
        }

        StringBuilder.append("In Zone\r\n");
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                tmpString = square[i][j].inZone ? "1 " : "0 ";
                StringBuilder.append(tmpString);
            }
            StringBuilder.append("\n");
        }

        StringBuilder.append("Regions\r\n");
        for (i = 0; i < DIMV; i++) {
            for (j = 0; j < DIMH; j++) {
                StringBuilder.append(square[i][j].region);
            }
            StringBuilder.append("\n");
        }

        StringBuilder.append("\r\nGENERAL VALUES\r\n");

        StringBuilder.append("\tInitial Mines: " + ((Integer) initialMines).toString());
        StringBuilder.append("\tInitial Blue Mines: " + ((Integer) initialBlueMines).toString());
        StringBuilder.append("\tInitial Red Mines: " + ((Integer) initialRedMines).toString());
        StringBuilder.append("\tFound Mines: " + ((Integer) foundMines).toString());
        StringBuilder.append("\tLeft Mines: " + ((Double) leftMines).toString());
        StringBuilder.append("\tOpen Sea size(): " + ((Integer) (openSeaCount)).toString());

        if (maxFirstExpectedValue != null) {
            StringBuilder.append("\n\tMaximum First Expected Value: " + maxFirstExpectedValue.toString());
        } else {
            StringBuilder.append("\n\tMaximum First Expected Value: -");
        }
        if (minFirstExpectedValue != null) {
            StringBuilder.append("\n\tMinimum First Expected Value: " + minFirstExpectedValue.toString());
        } else {
            StringBuilder.append("\n\tMinimum First Expected Value: -");
        }

        if (maxExpectedValue != null) {
            StringBuilder.append("\n\tMaximum Second Expected Value: " + maxExpectedValue.toString());
        } else {
            StringBuilder.append("\n\tMaximum Second Expected Value: -");
        }
        if (minExpectedValue != null) {
            StringBuilder.append("\n\tMinimum Second Expected Value: " + minExpectedValue.toString());
        } else {
            StringBuilder.append("\n\tMinimum Second Expected Value: -");
        }

        StringBuilder.append("\n\tObvious Mines: ");
        cont = 0;
        if (obviousMinesCount == 0) {
            StringBuilder.append("None");
        } else {
            for (int i1 = 0; i1 < DIMV; i1++) {
                for (int j1 = 0; j1 < DIMH; j1++) {
                    if (obviousMines[i1][j1]) {
                        StringBuilder.append("[%d , %d]", i1, j1);
                        if (cont != obviousMinesCount - 1) {
                            StringBuilder.append(", ");
                        }
                        cont++;
                    }
                }
            }
        }
        StringBuilder.append("\n");

        StringBuilder.append("\tObvious Not Mines: ");
        if (obviousNotMinesCount == 0) {
            StringBuilder.append("None");
        } else {
            cont = 0;
            for (int i1 = 0; i1 < DIMV; i1++) {
                for (int j1 = 0; j1 < DIMH; j1++) {
                    if (obviousNotMines[i1][j1]) {
                        StringBuilder.append("[%d, %d]", i1, j1);
                        if (cont != obviousNotMinesCount - 1) {
                            StringBuilder.append(", ");
                        }
                        cont++;
                    }
                }
            }
        }
        StringBuilder.append("\n");

        StringBuilder.append("\tNot So Obvious Mines: ");
        if (notSoobviousMinesCount == 0) {
            StringBuilder.append("None");
        } else {
            cont = 0;
            for (int i1 = 0; i1 < DIMV; i1++) {
                for (int j1 = 0; j1 < DIMH; j1++) {
                    if (notSoObviousMines[i1][j1]) {
                        StringBuilder.append("[%d , %d]", i1, j1);
                        if (cont != notSoobviousMinesCount - 1) {
                            StringBuilder.append(", ");
                        }
                        cont++;
                    }
                }
            }
        }
        StringBuilder.append("\n");

        StringBuilder.append("\tNot So Obvious Not Mines: ");
        if (notSoobviousNotMinesCount == 0) {
            StringBuilder.append("None");
        } else {
            cont = 0;
            for (int i1 = 0; i1 < DIMV; i1++) {
                for (int j1 = 0; j1 < DIMH; j1++) {
                    if (notSoObviousNotMines[i1][j1]) {
                        StringBuilder.append("[%d , %d]", i1, j1);
                        if (cont != notSoobviousNotMinesCount - 1) {
                            StringBuilder.append(", ");
                        }
                        cont++;
                    }
                }
            }
        }
        StringBuilder.append("\n");
        StringBuilder.append("Groups\r\n");
        if (groups.size() == 0) {
            StringBuilder.append("\tNone");
        }
        for (i = 0; i < groups.size(); i++) {
            StringBuilder.append("[" + i + "]\r\n" + groups.get(i).toString());
        }

        StringBuilder.append("Permutations\r\n");
        if (permutations.size() == 0) {
            StringBuilder.append("\tNone");
        }
        for (i = 0; i < permutations.size(); i++) {
            StringBuilder.append("[" + i + "]\r\n" + permutations.get(i).toString() + "\r\n");
        }

        StringBuilder.append("\n");
        StringBuilder.append("\n");

        StringBuilder.append("StringBuilder Capacity: " + StringBuilder.capacity());

        return StringBuilder.toString();
    }

    void Function1() {
        int i;
        int[] arreglo1 = new int[1000];

        for (i = 0; i < 1000; i++) {
            arreglo1[i] = 2;
        }
    }

    void Function2() {
        int i;
        int[] arreglo1 = new int[1000];

        for (i = 0; i < 1000; i++) {
            arreglo1[i] = 2;
        }
    }

    public double Benchmark() {
        Runnable task1 = new Runnable(){
			@Override
			public void run() {
				Function1();
			}
        };

        Runnable task2 = new Runnable(){
			@Override
			public void run() {
	        	Function2();
	        }
		};

        int i;

        float time1, time2;
        Counter counter = new Counter();
        int n = 200000;

        counter.Start();
        counter.Stop();
        counter.Reset();

        counter.Start();
        for (i = 0; i < n; i++) {
            task1.run();
        }
        counter.Stop();
        time1 = counter.TaskTime();
        counter.Reset();

        counter.Start();
        for (i = 0; i < n; i++) {
            task2.run();
        }
        counter.Stop();
        time2 = counter.TaskTime();
        counter.Reset();

        return time2 / time1;
    }

    public void SetLogicBoard(char[][] value) {
        ClearBoardMemory();
        this.logicBoard = value;
        InitializeLogicBoard();
    }

    public static void Simulate(InterruptCheck interruptCheck, Board board, int seconds) {
        double[][][] frequencyBoard = new double[DIMV][DIMH][MINES + 1];
        double[][] expandPayoff = new double[DIMV][DIMH];
        double[][] expandStd = new double[DIMV][DIMH];
        char[][] tmpLogicBoard1;
        char[][] randomBoard;

        boolean[] answer;
        Board tmpBoard = new Board(interruptCheck);
        tmpBoard.OnEventLog = board.OnEventLog;
        Random random = RandomFactory.Create();
        int iterations = 0;
        double total, ocurrences;

        Counter counter = new Counter();

        counter.Start();

//			bruteforce = Combinatory.BinomialCoefficient((int)board.leftMines, board.openSeaCount;

/*
 * This code is commented in Mario's original code /Simon @ 2013-02-04
        int n = (int) board.leftMines;
        int k = board.openSeaCount;
        CombinationGenerator combinationGenerator = new CombinationGenerator(n, k);
        int[] combination;
        int pos;
        int indexCombination;
        int unknownCount;

        System.out.println("total " + combinationGenerator.getTotal());
        
        while (combinationGenerator.HasMore()) {
            pos = 0;
            indexCombination = 0;
            unknownCount = 0;
            tmpLogicBoard1 = NightmareTools.megaClone(board.logicBoard);
            combination = combinationGenerator.GetNext();
            while (indexCombination != combination.length) {
            	if (pos / DIMH >= 16) throw new ArrayIndexOutOfBoundsException("pos " + pos + " indexcomb " + indexCombination + " comb length " + combination.length);
            	
                if (tmpLogicBoard1[pos / DIMH][ pos % DIMH] == '?') {
                    if (combination[indexCombination] == unknownCount) {
                        indexCombination++;
                        tmpLogicBoard1[pos / DIMH][ pos % DIMH] = 'm';
                    }
                    unknownCount++;
                }
                pos++;
            }
            Board.SetValues(tmpLogicBoard1, DIMV, DIMH, MINES);
            CalculateFrequencyBoard(frequencyBoard, board, tmpBoard, tmpLogicBoard1);
        }
        //if finished after the else
//	else */
        
        while (counter.TotalTime() < seconds * 1000) {
            tmpLogicBoard1 = NightmareTools.megaClone(board.logicBoard);

            for (Group group : board.groups) {
//            	for (Point point : group.unknown) { // error in Mario's code ??
            	for (UnknownPoint point : group.unknown) {
            		tmpLogicBoard1[point.row][point.col] = '?';
            	}
            	
                answer = group.answers.get(random.nextInt(group.answers.size()));
                for (int i = 0; i < group.unknown.size(); i++) {
                    if (answer[i]) {
                        tmpLogicBoard1[group.unknown.get(i).row][ group.unknown.get(i).col] = 'm';
                    }
                }
            	
            }
            
            randomBoard = Board.RandomBoard(tmpLogicBoard1);
            CalculateFrequencyBoard(frequencyBoard, board, tmpBoard, randomBoard);
            iterations++;

            if (iterations % 100 == 0) {
                board.onEvent(counter.TaskTime() / (seconds * 1000), Enums.EventType.PROGRESS);
/*
 * This is basically a logging, no need to do that here. Also commented out in Mario's code.
 * Would require a total of 16 * 16 * 51 = 13056 iterations. 13056 iterations for nothing is no need to do. /Simon @ 2013-02-04
                total = 0;
                ocurrences = 0;
                for (int i = 0; i < DIMV; i++) {
                    for (int j = 0; j < DIMH; j++) {
                        for (int h = 0; h <= MINES; h++) {
                            total += frequencyBoard[i][j][h] * h;
                            ocurrences += frequencyBoard[i][j][h];
                        }
                    }
                }
                board.onEvent(total / ocurrences, Enums.EventType.SIMULATION);
*/
            }
        }
        counter.Stop();

        double mean, std;
        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                total = 0;
                ocurrences = 0;
                std = 0;

                for (int k = 0; k <= MINES; k++) {
                    total += frequencyBoard[i][j][k] * k;
                    ocurrences += frequencyBoard[i][j][k];
                }
                if (ocurrences > 0) {
                    mean = total / ocurrences;
                    for (int k = 0; k <= MINES; k++) {
                        if (frequencyBoard[i][j][k] != 0) {
                            std += frequencyBoard[i][j][k] * Math.pow(k - mean, 2);
                        }
                    }

                    expandStd[i][j] = Math.sqrt(std / ocurrences);
                    expandPayoff[i][j] = mean;
                }
            }
        }

        board.ExpandStd(expandStd);
        board.ExpandPayoff(expandPayoff);
        board.CalculateFirstExpectedValue();
        if (board.MAXLEVEL > 1) {
            board.CalculateExpectedValue();
        }

        //Calculate mean payoff
        double evSum = 0, probSum = 0, generalPayoff;
        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                evSum += board.square[i][j].probability[0] * board.square[i][j].payoff[0];
                probSum += board.square[i][j].probability[0];
            }
        }
        generalPayoff = evSum / probSum;

        StringBuilder StringBuilder = new StringBuilder();
        StringBuilder.append("Payoff\r\n");
        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                StringBuilder.append(expandPayoff[i][j] /* "0.000" */ + "\t");
            }
            StringBuilder.append("\n");
        }
        StringBuilder.append("\n");
        StringBuilder.append("General Payoff: " + generalPayoff);
        
        Logger.getLogger("Board").fine(StringBuilder.toString());
//        new FileWriter(new File("Simulation.txt"), false).append(StringBuilder.toString());
    }

    private static void CalculateFrequencyBoard(double[][][] frequencyBoard, Board board, Board tmpBoard, char[][] tmpLogicBoard1) {
        int actualMines;
        boolean[][] expandedRegion= new boolean[DIMV][DIMH];
        char[][] tmpLogicBoard2;
        boolean[][] considered = new boolean[DIMV][DIMH];

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                if (tmpLogicBoard1[i][j] == '0' && !considered[i][j]) {
                    //obtener region que se expande
                    considered[i][j] = true;
                    tmpLogicBoard2 = NightmareTools.megaClone(board.logicBoard);
                    Board.Expand(tmpLogicBoard2, tmpLogicBoard1, new Point(i, j), expandedRegion);

                    //calcular minas regaladas
                    tmpBoard.SetLogicBoard(/*
                             * ref
                             */tmpLogicBoard2);
                    actualMines = tmpBoard.obviousMinesCount + tmpBoard.notSoobviousMinesCount;

                    for (int i2 = 0; i2 < DIMV; i2++) {
                        for (int j2 = 0; j2 < DIMH; j2++) {
                            if (expandedRegion[i2][ j2]) {
                                considered[i2][ j2] = true;
                                frequencyBoard[i2][ j2][ actualMines]++;
                            }
                        }
                    }
                }
            }
        }
    }

    public static char[][] RandomBoard() {
        int row, col;
        Point tmpMine;

        int DIMH = Configuration.BasicConfig().DIMH;
        int DIMV = Configuration.BasicConfig().DIMV;
        int MINES = Configuration.BasicConfig().MINES;

        char[][] rtn = new char[DIMV][DIMH];
        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                rtn[i][j] = '?';
            }
        }
        ArrayList<Point> randomMines = new ArrayList<Point>(MINES);
        Random random = RandomFactory.Create();

        do {
            row = (int) Math.floor((double) (random.nextInt(DIMV)));
            col = (int) Math.floor((double) (random.nextInt(DIMH)));
            tmpMine = new Point(row, col);

            if (!randomMines.contains(tmpMine)) {
                randomMines.add(tmpMine);
            }
        } while (randomMines.size() < MINES);

        for (int i = 0; i < randomMines.size(); i++) {
            rtn[randomMines.get(i).row][ randomMines.get(i).col] = i % 2 == 0 ? 'b' : 'r';
        }

        Board.SetValues(/*
                 * ref
                 */rtn, DIMV, DIMH, MINES);

        return rtn;
    }

    public static void Click(/*
             * ref
             */char[][] logicBoard, /*
             * ref
             */ char[][] randomBoard, Point point) throws Exception {
        boolean[][] expanded = new boolean[16][16];

        logicBoard[point.row][ point.col] = randomBoard[point.row][ point.col];

        if (randomBoard[point.row][ point.col] == '0') {
            Expand(/*
                     * ref
                     */logicBoard, /*
                     * ref
                     */ randomBoard, point, expanded);
        }
    }

    public static void RandomClick(/*
             * ref
             */char[][] logicBoard, /*
             * ref
             */ char[][] randomBoard) throws Exception {
        Random random = RandomFactory.Create();

        Click(/*
                 * ref
                 */logicBoard, /*
                 * ref
                 */ randomBoard, new Point(random.nextInt(16), random.nextInt(16)));
    }

    public static void Expand(/*
             * ref
             */char[][] logicBoard, Point point) {
        if (logicBoard[point.row][ point.col] != '?') {
            return;
        }

        int DIMH = Configuration.SolverConfig().DIMH;
        int DIMV = Configuration.SolverConfig().DIMV;

        ArrayList<Point> tmpList = new ArrayList<Point>();
        Point tmpPoint;
        int row, col;

        int listIndex = 0;
        tmpList.add(point);

        do {
            tmpPoint = tmpList.get(listIndex);
            row = tmpPoint.row;
            col = tmpPoint.col;

            if (row != DIMV - 1) {
                if (logicBoard[row + 1][ col] == '?') {
                    tmpPoint = new Point(row + 1, col);
                    if (!tmpList.contains(tmpPoint)) {
                        tmpList.add(new Point(row + 1, col));
                    }
                }
            }

            if (col != DIMH - 1) {
                if (logicBoard[row][ col + 1] == '?') {
                    tmpPoint = new Point(row, col + 1);
                    if (!tmpList.contains(tmpPoint)) {
                        tmpList.add(new Point(row, col + 1));
                    }
                }
            }

            if (col != 0) {
                if (logicBoard[row][ col - 1] == '?') {
                    tmpPoint = new Point(row, col - 1);
                    if (!tmpList.contains(tmpPoint)) {
                        tmpList.add(new Point(row, col - 1));
                    }
                }
            }

            if (row != 0) {
                if (logicBoard[row - 1][ col] == '?') {
                    tmpPoint = new Point(row - 1, col);
                    if (!tmpList.contains(tmpPoint)) {
                        tmpList.add(new Point(row - 1, col));
                    }
                }
            }

            listIndex++;
        } while (listIndex < tmpList.size());

        for (int i = 0; i < tmpList.size(); i++) {
            logicBoard[tmpList.get(i).row][ tmpList.get(i).col] = '0';
        }
    }

    public static void Expand(char[][] logicBoard, char[][] randomBoard, Point point, boolean[][] expanded) {
        if (randomBoard[point.row][point.col] != '0') {
            throw new AssertionError("Cannot expand at a non-expanding field. Point " + point +
                ". Value " + randomBoard[point.row][point.col]);
        }

        int DIMH = Configuration.SolverConfig().DIMH;
        int DIMV = Configuration.SolverConfig().DIMV;

        expanded = new boolean[DIMV][DIMH];
        ArrayList<Point> tmpList = new ArrayList<Point>();
        Point tmpPoint;
        int row, col;

        int listIndex = 0;
        tmpList.add(point);

        do {
            tmpPoint = tmpList.get(listIndex);
            row = tmpPoint.row;
            col = tmpPoint.col;

            if (randomBoard[row][ col] < '1' || randomBoard[row][ col] > '8') {
                if (row != DIMV - 1) {
                    if (col != DIMH - 1) {
                        if (randomBoard[row + 1][ col + 1] != 'm') {
                            tmpPoint = new Point(row + 1, col + 1);
                            if (!tmpList.contains(tmpPoint)) {
                                tmpList.add(tmpPoint);
                            }
                        }
                    }

                    if (col != 0) {
                        if (randomBoard[row + 1][ col - 1] != 'm') {
                            tmpPoint = new Point(row + 1, col - 1);
                            if (!tmpList.contains(tmpPoint)) {
                                tmpList.add(new Point(row + 1, col - 1));
                            }
                        }
                    }

                    if (randomBoard[row + 1][ col] != 'm') {
                        tmpPoint = new Point(row + 1, col);
                        if (!tmpList.contains(tmpPoint)) {
                            tmpList.add(new Point(row + 1, col));
                        }
                    }
                }

                if (col != DIMH - 1) {
                    if (randomBoard[row][ col + 1] != 'm') {
                        tmpPoint = new Point(row, col + 1);
                        if (!tmpList.contains(tmpPoint)) {
                            tmpList.add(new Point(row, col + 1));
                        }
                    }
                }

                if (col != 0) {
                    if (randomBoard[row][ col - 1] != 'm') {
                        tmpPoint = new Point(row, col - 1);
                        if (!tmpList.contains(tmpPoint)) {
                            tmpList.add(new Point(row, col - 1));
                        }
                    }
                }

                if (row != 0) {
                    if (col != DIMH - 1) {
                        if (randomBoard[row - 1][ col + 1] != 'm') {
                            tmpPoint = new Point(row - 1, col + 1);
                            if (!tmpList.contains(tmpPoint)) {
                                tmpList.add(new Point(row - 1, col + 1));
                            }
                        }
                    }

                    if (col != 0) {
                        if (randomBoard[row - 1][ col - 1] != 'm') {
                            tmpPoint = new Point(row - 1, col - 1);
                            if (!tmpList.contains(tmpPoint)) {
                                tmpList.add(new Point(row - 1, col - 1));
                            }
                        }
                    }

                    if (randomBoard[row - 1][ col] != 'm') {
                        tmpPoint = new Point(row - 1, col);
                        if (!tmpList.contains(tmpPoint)) {
                            tmpList.add(new Point(row - 1, col));
                        }
                    }
                }
            }

            listIndex++;
        } while (listIndex < tmpList.size());

        for (int i = 0; i < tmpList.size(); i++) {
            if (randomBoard[tmpList.get(i).row][ tmpList.get(i).col] == '0') {
                expanded[tmpList.get(i).row][ tmpList.get(i).col] = true;
            }
            logicBoard[tmpList.get(i).row][ tmpList.get(i).col] = randomBoard[tmpList.get(i).row][ tmpList.get(i).col];
        }
    }

    public static char[][] RandomBoard(/*
             * ref
             */char[][] logicBoard) {
        int cont = 0;
        int row, col;
        int DIMV = Configuration.SolverConfig().DIMV;
        int DIMH = Configuration.SolverConfig().DIMH;
        int MINES = Configuration.SolverConfig().MINES;

        boolean[][] randomMines = new boolean[Configuration.SolverConfig().DIMV][Configuration.SolverConfig().DIMH];
        char[][] randomBoard = NightmareTools.megaClone(logicBoard);
        Random random = new Random();

        int initialMines = 0;
        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                if (logicBoard[i][j] == 'm' || logicBoard[i][j] == 'r' || logicBoard[i][j] == 'b') {
                    initialMines++;
                }
            }
        }

        do {
            row = random.nextInt(DIMV);
            col = random.nextInt(DIMH);

            if (logicBoard[row][ col] == '?' && !randomMines[row][ col]) {
                randomMines[row][ col] = true;
                randomBoard[row][ col] = cont % 2 == 0 ? 'b' : 'r';
                cont++;
            }
        } while (cont < MINES - initialMines);

        Board.SetValues(/*
                 * ref
                 */randomBoard, DIMV, DIMH, MINES);

        return randomBoard;
    }

    static void SetValues(/*
             * ref
             */char[][] logicboard, int DIMV, int DIMH, int MINES) {
        int adjacentsMines;

        for (int i = 0; i < DIMV; i++) {
            for (int j = 0; j < DIMH; j++) {
                adjacentsMines = 0;

                if (logicboard[i][j] == 'm' || logicboard[i][j] == 'b' || logicboard[i][j] == 'r') {
                    continue;
                }

                if (i != DIMV - 1) {
                    if (j != DIMH - 1) {
                        if (logicboard[i + 1][ j + 1] == 'm' || logicboard[i + 1][ j + 1] == 'b' || logicboard[i + 1][ j + 1] == 'r') {
                            adjacentsMines++;
                        }
                    }
                    if (j != 0) {
                        if (logicboard[i + 1][ j - 1] == 'm' || logicboard[i + 1][ j - 1] == 'b' || logicboard[i + 1][ j - 1] == 'r') {
                            adjacentsMines++;
                        }
                    }
                    if (logicboard[i + 1][ j] == 'm' || logicboard[i + 1][ j] == 'b' || logicboard[i + 1][ j] == 'r') {
                        adjacentsMines++;
                    }
                }

                if (j != DIMH - 1) {
                    if (logicboard[i][ j + 1] == 'm' || logicboard[i][ j + 1] == 'b' || logicboard[i][ j + 1] == 'r') {
                        adjacentsMines++;
                    }
                }
                if (j != 0) {
                    if (logicboard[i][ j - 1] == 'm' || logicboard[i][ j - 1] == 'b' || logicboard[i][ j - 1] == 'r') {
                        adjacentsMines++;
                    }
                }

                if (i != 0) {
                    if (j != DIMH - 1) {
                        if (logicboard[i - 1][ j + 1] == 'm' || logicboard[i - 1][ j + 1] == 'b' || logicboard[i - 1][ j + 1] == 'r') {
                            adjacentsMines++;
                        }
                    }
                    if (j != 0) {
                        if (logicboard[i - 1][ j - 1] == 'm' || logicboard[i - 1][ j - 1] == 'b' || logicboard[i - 1][ j - 1] == 'r') {
                            adjacentsMines++;
                        }
                    }
                    if (logicboard[i - 1][ j] == 'm' || logicboard[i - 1][ j] == 'b' || logicboard[i - 1][ j] == 'r') {
                        adjacentsMines++;
                    }
                }

                logicboard[i][j] = (char) (adjacentsMines + 48);
            }
        }
    }

	public int getDIMV() {
		return DIMV;
	}

	public int getDIMH() {
		return DIMH;
	}

	public void javaGarbage() {
		if (this.groups != null)
		for (Group grp : this.groups) {
			grp.javaGarbage();
		}
		
		this.logicBoard = null;
		
		if (square != null)
		for (Square[] sqarr : square) {
			if (sqarr != null)
			for (Square sq : sqarr) {
				sq.javaGarbage();
			}
		}
		this.square = null;
		this.obviousMines = null;
		this.obviousNotMines = null;
		this.notSoObviousMines = null;
		this.notSoObviousNotMines = null;
		
		if (permutations != null)
		for (Permutation perm : permutations) {
			perm.javaGarbage();
		}

		if (this.answersFrequencies != null)
			this.answersFrequencies.clear();
		if (this.regions != null)
			this.regions.clear();
		
		this.maxFirstExpectedValue = null;
		this.minFirstExpectedValue = null;
		this.maxExpectedValue = null;
		this.minExpectedValue = null;
		this.configuration = null;
		
		this.openSea = null;
	}
}
