package net.zomis.plugin;

import java.util.ArrayList;
import java.util.List;

import net.zomis.UtilZomisList;
import net.zomis.minesweeper.ais.AI_Complete_Idiot;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.FieldRule;
import net.zomis.minesweeper.analyze.RuleConstraint;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.api.FieldType;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public class AI_Complexer extends MinesweeperAI {

	private MinesweeperAI backup = new AI_Complete_Idiot();

	public AI_Complexer() {
		super("#AI_Complexer");
		this.hide();
	}

	@Override
	public boolean agreeDraw(MinesweeperPlayingPlayer pp) {
		return false;
	}

	@Override
	public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
		MineprobabilityAnalyze prob = new MineprobabilityAnalyze(pp.getMap());
		AnalyzeResult<MinesweeperField> solved = prob.solve();
		List<RuleConstraint<MinesweeperField>> rules = solved.getOriginalRules();
		
		List<MinesweeperField> potentials = new ArrayList<MinesweeperField>();
		for (RuleConstraint<MinesweeperField> rule : rules) {
			if (rule.getCause() == null) continue; // Big sea or 0% mines.
			
			for (MinesweeperField neighbor : rule.getCause().getNeighbors())
			if (neighbor.getFieldStyle() == FieldType.UNCLICKED) {
				if (neighbor.isMine()) continue; // Avoid taking mines.
				
				FieldRule<MinesweeperField> newRule = prob.ruleFromField(neighbor);
				if (newRule == null) continue;
				if (newRule.getResult() == 0) {
					continue;
				}
				else if (newRule.getFieldsCountInGroups() == newRule.getResult()) {
					continue;
				}
				
				potentials.add(neighbor);
			}
		}
		
		if (!potentials.isEmpty()) {
			return pp.createMove(MinesweeperMove.STANDARD_CLICK, UtilZomisList.getRandom(potentials));
		}
		
		return backup.play(pp);
	}

	@Override
	public boolean respondToInvite(Invite invite) {
		return true;
	}
}
