package net.zomis.minesweeper.ais.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.zomis.minesweeper.ais.AIZomisSupplier;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.ais.StatUtils;
import net.zomis.minesweeper.ais.mirror.AI_Mirror;
import net.zomis.minesweeper.ais.mirror.Analyze_AI_Mirror;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.model.GameReplay;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.FieldScores;

/**
 * Planning to use {@link AI_Mirror} and {@link Analyze_AI_Mirror} instead. Even though I believe this class still works.
 * @author Zomis
 *
 */
@Deprecated
public class SkillRate {
	private GameReplay	replay;
	private AIZomisSupplier aiClass;
	private Map<MinesweeperMove, FieldScore> results;
	
	public SkillRate(GameReplay replay, AIZomisSupplier aiClass) {
		this.replay = replay;
		this.aiClass = aiClass;
	}
	
	private AI_Zomis getAI() {
        return this.aiClass.get(this.replay.getMap().getCurrentPlayer());
	}
	
	public Map<MinesweeperMove, FieldScore> getResults() {
		this.replay.setPosition(0);
		Map<MinesweeperMove, FieldScore> map = new HashMap<MinesweeperMove, FieldScore>();
		List<MinesweeperMove> moves = this.replay.getMoves();
		
		while (this.replay.getPosition() < this.replay.getMoveCount()) {
			MinesweeperMove move = moves.get(this.replay.getPosition());
			AI_Zomis ai = this.getAI();
			if (!move.getPlayer().canUseWeapon(move.getWeaponType())) {
                throw new AssertionError("Replay error. Can't use weapon " + move + " at " + this.replay.getPosition());
            }
			FieldScores scores = ai.createScoreProvider(move.getPlayer()).analyzeAndScore(move.getWeapon(), false);
			
//			Logger.getLogger(getClass()).info("Current player is: " + this.replay.getMap().getCurrentPlayer() + " ai is for " + ai.getPlayingPlayer());
			if (scores == null) throw new NullPointerException("Scores is null for " + move + " at replay position " + this.replay.getPosition());
//			Logger.getLogger(getClass()).info("Scores is: " + scores.toString());
//			Logger.getLogger(getClass()).info("Move is: " + move.toString());
			scores.rankScores();
			FieldScore data = scores.getScoreFor(move.getMap().getPosition(move.getMovePosition().getX(), move.getMovePosition().getY()));
			map.put(move, data);
//			if (data == null) throw new NullPointerException("No data. " + this.replay.getPosition());
			this.replay.nextMove();
		}
		this.results = map;
		return map;
	}
	public List<MinesweeperMove> getMovesBy(MinesweeperPlayingPlayer player) {
		List<MinesweeperMove> list = new ArrayList<MinesweeperMove>();
		for (MinesweeperMove move : this.replay.getMoves()) {
			if (move.getPlayer().equals(player)) list.add(move);
		}
		return list;
	}
	public double[] getNormalized(MinesweeperPlayingPlayer player) {
		if (this.results == null) throw new IllegalStateException();
		
		List<MinesweeperMove> moves = this.getMovesBy(player);
		int index = 0;
		double[] result = new double[moves.size()];
		for (int i = 0; i < result.length; i++) {
			MinesweeperMove move = moves.get(i);
			FieldScore data = this.results.get(move);
			if (data == null) continue;
			result[index] = data.getNormalized();
			index++;
		}
		return Arrays.copyOf(result, index + 1);
	}
	public double getAverage(MinesweeperPlayingPlayer player) {
		return StatUtils.mean(this.getNormalized(player));
	}
	
}
