package net.zomis.minesweeper.ais.mirror;

import java.util.ArrayList;
import java.util.List;

import net.zomis.minesweeper.ais.StatUtils;
import net.zomis.minesweeper.ais.otherscorers.StaticScoreForWeapon;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.MinesweeperReplay;
import net.zomis.minesweeper.game.model.GameReplay;
import net.zomis.minesweeper.game.model.MapUtils;
import net.zomis.minesweeper.scores.AnalyzeMethod;
import net.zomis.minesweeper.scores.ScoreConfig;
import net.zomis.minesweeper.scores.ScoreConfigFactory;
import net.zomis.minesweeper.weapons.classic.BombWeapon;

public class Analyze_AI_Mirror {
//	private static final Logger logger = LogManager.getLogger(Analyze_AI_Mirror.class);
	
	private final List<MirrorScorer> mirrors = new ArrayList<MirrorScorer>();
	
	private final MinesweeperPlayingPlayer	player;
	public MinesweeperPlayingPlayer getPlayer() {
		return player;
	}
	private int	count = 0;
	public Analyze_AI_Mirror(MinesweeperPlayingPlayer analyzePlayer) {
		this.player = analyzePlayer;
	}
	public Analyze_AI_Mirror addScorer(MirrorScorer mirrorScorer) {
		this.mirrors.add(mirrorScorer);
		return this;
	}
	public MinesweeperMap getMap() {
		return player.getMap();
	}
	public boolean moveInform(MinesweeperMove move) {
		if (this.mirrors.isEmpty()) throw new IllegalStateException("No MirrorScorers has been set. Call Mirror.addScorer(...)");
		MinesweeperMap map = move.getMap();
		
		if (move.getPlayer() != this.player) return false;
		if (move.getField() == null) return false; // Move without a field is not possible to analyze.
		if (move.getWeapon() instanceof BombWeapon) {
            return false; // TODO: Analyze other weapons with AI Mirror.
        }
//		if (this.getMap().getMinesCount() == this.getMap().getMinesLeft()) return false; // Expander rule can still happen.
		GameReplay replay = new GameReplay(MapUtils.getMinesString(map), MapUtils.getClickString(map), map.getMapFactory().standard());
		replay.rewind();
		for (MinesweeperMove nextmove : replay.getMoves()) {
			if (!nextmove.equals(move)) {
				replay.nextMove();
			}
			else break;
		}
		for (MirrorScorer scorer : this.mirrors) scorer.moveInform(move, replay.getMap());
		this.count++;
		return true;
	}
	
	public ScoreConfig getScoreConfig() {
		ScoreConfigFactory config = new ScoreConfigFactory(AnalyzeMethod.ZOMIS_ADVANCED);
		config.withScorer(new StaticScoreForWeapon(MinesweeperMove.STANDARD_CLICK, 10)); // just to make sure that they have some score, to prevent early bomb.
		
		for (MirrorScorer scorer : this.mirrors) {
			if (scorer.getPower() > 0)
				config = config.withScorer(scorer, scorer.getPower());
		}
		return config.build();
	}
	
	public double getExpectedRating() {
		if (this.mirrors.isEmpty()) throw new IllegalStateException("No MirrorScorers has been set. Call Mirror.addScorer(...)");
		
		List<Double> list = new ArrayList<Double>();
		for (MirrorScorer scorer : this.mirrors) {
			Double value = scorer.getExpectedRating(this);
			if (value != null) list.add(value);
		}
		if (list.isEmpty()) return 0D;
		
		return StatUtils.mean(list);
	}
	
	@Override
	public String toString() {
		StringBuilder str = new StringBuilder(this.getClass().getSimpleName() + ":\n");
		for (MirrorScorer scorer : this.mirrors) {
			str.append(scorer);
			str.append("\n");
		}
		return str.toString();
	}
	public int getCount() {
		return this.count;
	}
	
	public void analyzeReplay(MinesweeperReplay replay) {
		replay.rewind();
		for (MinesweeperMove move : replay.getMoves()) {
			if (move.getPlayer() == this.player) this.moveInform(move);
			
			replay.nextMove();
		}
	}
	public List<MirrorScorer> getMirrors() {
		return new ArrayList<MirrorScorer>(mirrors);
	}
}
