package net.zomis.minesweeper.ais;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;
import net.zomis.minesweeper.weapons.classic.BombWeapon;

public class NoZeroPercent_IfLead extends AbstractScorer {

	private static final double	THRESHOLD	= 0.18; // Value according to fnopeaw. Think "density of open field squares" (which is usually 0.19)

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		boolean allBombsUsed = true;
		for (MinesweeperPlayingPlayer pp : scores.getPlayer().getMap().getPlayingPlayers()) {
			if (pp == scores.getPlayer()) continue;
			if (pp.getScore() >= scores.getPlayer().getScore()) {
				return false; // If the AI is not currently winning
			}
			
			if (pp.getWeapon(MinesweeperMove.STANDARD_BOMB) instanceof BombWeapon) {
				BombWeapon bw = (BombWeapon) pp.getWeapon(MinesweeperMove.STANDARD_BOMB);
				if (bw.getUseCount() == 0) allBombsUsed = false;
			}
		}
		return this.weaponIsClick(scores.getWeapon()) && !allBombsUsed;
	}

	@Override
	public double getScoreFor(MinesweeperField field,
			ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		if (data == null) return 0;
		
		if (data.getFieldGroup().getProbability() <= THRESHOLD) return -10000;
		return 0;
	}
}
