package net.zomis.minesweeper.ais;

import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.ZomisTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class BadChickenPlayWhenBadProbabilities extends AbstractScorer {

	public static boolean isBadProbabilities(AnalyzeResult<MinesweeperField> analyze) {
		double highestProb = 0;
		double prob = 0;
		for (FieldGroup<MinesweeperField> ee : analyze.getGroups()) {
			if (ZomisTools.isZomisOpenField(ee.get(0))) {
				prob = ee.getProbability();
			}
			if (ee.getProbability() > highestProb) highestProb = ee.getProbability();
		}
		return highestProb <= prob;
	}
	
	
	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		if (!weaponIsClick(scores.getWeapon())) return false;
		return isBadProbabilities(scores.getAnalyze().getAnalyze());
	}

	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		FieldGroup<MinesweeperField> grp = scores.getAnalyze().getAnalyze().getGroupFor(field);
		if (grp.getProbability() < 0.000001) {
			for (MinesweeperField ff : field.getInvertedNeighbors()) {
				if (ff.isDiscoveredMine()) return 1;
			}
		}
		return 0;
	}

}
