package net.zomis.minesweeper.ais;

import net.zomis.minesweeper.ais.otherscorers.StaticScoreForWeapon;
import net.zomis.minesweeper.aiscore.MineProbability;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AnalyzeMethod;
import net.zomis.minesweeper.scores.ScoreConfigFactory;

// @AI(rating = -99999)
public class AI_ZLoser extends AI_Zomis {
	public AI_ZLoser() {
		super("#AI_ZLoser", new ScoreConfigFactory(AnalyzeMethod.ZOMIS_BASIC)
			// Test scorers
			.withScorer(new MineProbability(), -1)
			.withScorer(new StaticScoreForWeapon(MinesweeperMove.STANDARD_BOMB, -1000))
			.build()
			);
		this.hide();
	}

	@Override
	public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
		if (this.agreeDraw(pp)) {
			if (pp.proposeDraw()) {
				this.sendChatMessage(pp, "I propose draw! You've got 10 seconds to agree or not");
				
				if (!pp.isEliminated()) {
					try { Thread.sleep(10000);	}	catch (InterruptedException e) {}
				}
				
				if (!pp.isEliminated()) this.sendChatMessage(pp, "10 seconds has passed, now I make my move.");
			}
		}
		
		return super.play(pp);
	}
	
}
