package net.zomis.mario.probability;
	@Deprecated
    public final class WinningProbability 
    {
        static final int MAX_MINES = 51;
        static final int MAX_SQUARES = 256;
        
        static final WinningProbability instance = new WinningProbability();
        static final BigDouble[] bigDoubles = new BigDouble[MAX_SQUARES + 1];
        static final double[][] binomialCoefficients = new double[MAX_MINES + 1][MAX_SQUARES + 1];

        BigDouble[][][] blueWinningCases = new BigDouble[27][27][257];
        double[][][] blueWinningCasesDouble = new double[27][27][257];

        BigDouble[][][] redWinningCases = new BigDouble[27][27][257];
        double[][][] redWinningCasesDouble = new double[27][27][257];
        
        boolean isInitialized;

        private WinningProbability() { }

        public static WinningProbability getInstance() {
            return instance;
        }

        public double getthis(int blue, int red, int openSeaCount)
        {
                if (blue >= 26)
                    return 1D;

                if (red >= 26)
                    return 0D;


                boolean turn = ((red + blue + openSeaCount) % 2 == 0);

                if (turn)   // BLUE TURN
                {
                    if (blueWinningCases[blue][red][openSeaCount] != null)
                    {
                        return blueWinningCasesDouble[blue][red][openSeaCount] / binomialCoefficients[51 - blue - red][openSeaCount];
                    }
                    else
                    {
                        return -1D;
                    }
                }
                else  // TURN RED
                {
                    if (redWinningCases[blue][red][openSeaCount] != null)
                    {
                        return redWinningCasesDouble[blue][red][openSeaCount] / binomialCoefficients[51 - blue - red][openSeaCount];
                    }
                    else
                    {
                        return -1D;
                    }
                }
        }

        public void Initialize() throws Exception
        {
            if (!isInitialized)
            {
                CreateStaticArrays();
                Calculate();
                ConvertBigDoubleToDouble();
            }

            isInitialized = true;
        }

        private void CreateStaticArrays() throws Exception
        {
            int i, j;
            for (i = 0; i <= MAX_SQUARES; i++)
            {
                bigDoubles[i] = new BigDouble(i);
                for (j = 0; j <= MAX_MINES; j++)
                {
                    if (j <= i)
                    {
                        binomialCoefficients[j][i] = Combinatory.BinomialCoefficientBigDouble(j, i).ToDouble();
                    }
                }
            }
        }
        private void ConvertBigDoubleToDouble()
        {
            int i, b, r;
            for (i = MAX_SQUARES; i >= 0; i--)
            {
                for (b = 0; b < 26; b++)
                {
                    for (r = 0; r < 26; r++)
                    {
                        if (blueWinningCases[b][r][i] != null)
                            blueWinningCasesDouble[b][r][i] = blueWinningCases[b][r][i].ToDouble();
                        if (redWinningCases[b][r][i] != null)
                            redWinningCasesDouble[b][r][i] = redWinningCases[b][r][i].ToDouble();
                    }
                }
            }
        }

        private void Calculate() throws Exception
        {
            CalculateBlue(0, 0, MAX_SQUARES, Combinatory.BinomialCoefficientBigDouble(MAX_MINES, MAX_SQUARES));
            CalculateRed(0, 0, MAX_SQUARES, Combinatory.BinomialCoefficientBigDouble(MAX_MINES, MAX_SQUARES));
        }

        private BigDouble CalculateRed(int blue, int red, int openSeaCount, BigDouble product) throws Exception
        {
            if (redWinningCases[blue][red][openSeaCount] != null)
            {
                return redWinningCases[blue][red][openSeaCount];
            }

            if (blue == 26)
            {
                redWinningCases[blue][red][openSeaCount] = bigDoubles[0];
                return redWinningCases[blue][red][openSeaCount];
            }

            if (red == 26)
            {
                redWinningCases[blue][red][openSeaCount] = product;
                return redWinningCases[blue][red][openSeaCount];
            }

            if (openSeaCount + blue + red - 51 <= 0)
            {
                redWinningCases[blue][red][openSeaCount] = product;
                return redWinningCases[blue][red][openSeaCount];
            }

            BigDouble leftTree = null;
            BigDouble rightTree = null;
            BigDouble winnningProbability = bigDoubles[51 - blue - red];
            BigDouble losingProbability = bigDoubles[openSeaCount + blue + red - 51];

            if ((red + blue + openSeaCount) % 2 == 0)   //RED TURN
            {
                rightTree = CalculateRed(blue, red, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product,losingProbability) , openSeaCount));
                leftTree = CalculateRed(blue, red + 1, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product,winnningProbability) , openSeaCount));
            }
            else // BLUE TURN
            {   
                rightTree = CalculateRed(blue, red, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product,losingProbability) , openSeaCount));
                leftTree = CalculateRed(blue + 1, red, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product,winnningProbability) , openSeaCount));
            }

            redWinningCases[blue][red][openSeaCount] = BigDouble.add(leftTree, rightTree);

            return redWinningCases[blue][red][openSeaCount];
        }

        private BigDouble CalculateBlue(int blue, int red, int openSeaCount, BigDouble product) throws Exception
        {
            if (blueWinningCases[blue][red][openSeaCount] != null)
            {
                return blueWinningCases[blue][red][openSeaCount];
            }

            if (blue == 26)
            {
                blueWinningCases[blue][red][openSeaCount] = product;
                return blueWinningCases[blue][red][openSeaCount];
            }

            if (red == 26)
            {
                blueWinningCases[blue][red][openSeaCount] = bigDoubles[0];
                return blueWinningCases[blue][red][openSeaCount];
            }

            /*if (51 - blue - red == openSeaCount)
            {
                totalWinningCases[blue][red][openSeaCount] = bigDoubles[0];
                return totalWinningCases[blue][red][openSeaCount];
            }*/
            if (51 - blue - red > openSeaCount)
            {
                blueWinningCases[blue][red][openSeaCount] = bigDoubles[0];
                return blueWinningCases[blue][red][openSeaCount];
            }

            BigDouble leftTree = null;
            BigDouble rightTree = null;
            BigDouble winnningProbability = bigDoubles[51 - blue - red];
            BigDouble losingProbability = bigDoubles[openSeaCount + blue + red - 51];

            if ((red + blue + openSeaCount) % 2 == 0)   // BLUE TURN
            {
                rightTree = CalculateBlue(blue, red, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product,losingProbability) , openSeaCount));
                leftTree = CalculateBlue(blue + 1, red, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product,winnningProbability) , openSeaCount));
            }
            else //RED TURN
            {
                rightTree = CalculateBlue(blue, red, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product,losingProbability) , openSeaCount));
                leftTree = CalculateBlue(blue, red + 1, openSeaCount - 1, BigDouble.Divide(BigDouble.Multy(product,winnningProbability) , openSeaCount));
            }

            blueWinningCases[blue][red][openSeaCount] = BigDouble.add(leftTree, rightTree);

            return blueWinningCases[blue][red][openSeaCount];
        }

        @Override
        public String toString()
        {
            StringBuilder stringBuilder = new StringBuilder(4194304);

            int i, b, r;
            for (i = MAX_SQUARES; i >= 0; i--)
            {
                stringBuilder.append("[" + i + "]\n");
                for (b = 0; b <= 26; b++)
                {
                    for (r = 0; r <= 26; r++)
                    {
                        if (i + b + r > MAX_SQUARES || i + b + r < MAX_MINES)
                            continue;
                        //*
                        stringBuilder.append("[");
                        stringBuilder.append(b);
                        stringBuilder.append(",");
                        stringBuilder.append(r);
                        stringBuilder.append("] = ");
                        stringBuilder.append(getthis(b, r, i));
                        //*/
                        /*
                        if(this.totalWinningCases[b, r, i] != null)
                            stringBuilder.AppendFormat("[{0},{1}] = {2}", b, r, this.totalWinningCases[b, r, i].ToString());
                        else
                            stringBuilder.AppendFormat("[{0},{1}] = null", b, r);
                        //*/
                        stringBuilder.append("\n");
                    }
                }
                stringBuilder.append("\n");
            }

            stringBuilder.append(stringBuilder.capacity() + "\n");

            return stringBuilder.toString();
        }
    }
