package net.zomis.minesweeper.scores;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public abstract class AbstractScorer extends Scorer {
    @Deprecated
	public String getName() {
		return this.getClass().getSimpleName();
	}

	protected boolean weaponIsClick(MinesweeperWeapon weapon) {
		if (weapon == null) return false;
		return weapon.getWeaponType().contentEquals(MinesweeperMove.STANDARD_CLICK);
	}
	protected boolean weaponIsBomb(MinesweeperWeapon weapon) {
		if (weapon == null) return false;
		return weapon.getWeaponType().contentEquals(MinesweeperMove.STANDARD_BOMB);
	}
	
	public abstract boolean workWithWeapon(ScoreParameters scores);
	public abstract double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores);

	
	protected static boolean hasProbability(double probability, double d) {
		return Math.abs(probability - d) < 0.00001;
	}
	@Override
	public String toString() {
		return this.getName();
	}
}
