package net.zomis.minesweeper.ais.otherscorers;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.ZomisTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class AIHardScorer extends AbstractScorer {

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return this.weaponIsClick(scores.getWeapon());
	}

	@Override
	public double getScoreFor(MinesweeperField field,
			ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		if (data == null) return 0;
		
		if (ZomisTools.isZomisOpenField(field)) {
			if (data.getProbabilities()[0] > 0) return -0.01;
			else return data.getMineProbability();
		}
		
		return data.getMineProbability();
	}
}
