package net.zomis.minesweeper.ais;

import net.zomis.minesweeper.ais.post.BombStifle;
import net.zomis.minesweeper.ais.post.ChickenPlayCounter;
import net.zomis.minesweeper.aiscore.AvoidReveal50_New;
import net.zomis.minesweeper.aiscore.BombIfManyMinesScorer;
import net.zomis.minesweeper.aiscore.BombScore;
import net.zomis.minesweeper.aiscore.CertainMines;
import net.zomis.minesweeper.aiscore.NonRevealingSafeClicks;
import net.zomis.minesweeper.aiscore.OpenFieldsPenalty;
import net.zomis.minesweeper.aiscore.SafeOpenField;
import net.zomis.minesweeper.aiscore.SafeProbabilityAroundMine;
import net.zomis.minesweeper.aiscore.SafeWithRiskAroundMine;
import net.zomis.minesweeper.aiscore.UnevenProbabilities;
import net.zomis.minesweeper.aiscore.mario.RealMarioEV1;
import net.zomis.minesweeper.aiscore.mario.RealMarioEVScorer;
import net.zomis.minesweeper.analyze.InterruptCheck;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AnalyzeMethod;
import net.zomis.minesweeper.scores.ScoreConfigFactory;

// @AI(rating = 2900)
public class Inactivated_AI_NonameFf2 extends AI_Zomis {
	// Fnopeaw's idea of Nightmare that plays agressively if he's ahead in score
	public Inactivated_AI_NonameFf2(InterruptCheck interruptCheck, MinesweeperPlayingPlayer player) {
		super("#AI_NonameFf2", new ScoreConfigFactory(AnalyzeMethod.ZOMIS_ADVANCED)
				.withPreScorer(new MarioAnalyze(interruptCheck))
			// Click scorers
				.withScorer(new NonRevealingSafeClicks())
				.withScorer(new CertainMines())
				.withScorer(new OpenFieldsPenalty())
				.withScorer(new SafeProbabilityAroundMine())
				.withScorer(new SafeWithRiskAroundMine())
				.withScorer(new RealMarioEVScorer())
				.withScorer(new SafeOpenField())
				.withScorer(new RealMarioEV1())
				.withScorer(new UnevenProbabilities())
				.withScorer(new AvoidReveal50_New())
				.withScorer(new OptimizeMyBomb())
				
				.withScorer(new NoZeroPercent_IfLead())
				
				// Bomb scorers
				.withScorer(new BombScore())
				.withScorer(new BombIfManyMinesScorer(8.0 / 51.0))
				
				.withPost(new ChickenPlayCounter())
				.withPost(new BombStifle())
				
				.build());
	}

	@Override
	public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
//		if (this.agreeDraw(pp)) {
//			if (this.getPlayingPlayer().proposeDraw()) {
//				this.sendChatMessage("I propose draw! You've got 10 seconds to agree or not");
//
//				if (!this.getPlayingPlayer().isEliminated()) {
//					try { Thread.sleep(10000);	}	catch (InterruptedException e) {}
//				}
//
//				if (!this.getPlayingPlayer().isEliminated()) this.sendChatMessage("10 seconds has passed, now I make my move.");
//			}
//		}
        return super.play(pp);
	}
	
	@Override
	public boolean respondToInvite(Invite invite) {
		if (invite.getPlayers().size() > 2) invite.getHost().sendChat(this.getName() + ": Unfortunately, I am not built to play other than 2 player games.");
		
		return invite.getPlayers().size() <= 2;
	}

}
