package net.zomis.mario.classes;

import java.util.ArrayList;

import net.zomis.mario.classes.MinesweeperFlags.ZonePoint;


    public class Group
    {
        public ArrayList<UnknownPoint> unknown;
        public ArrayList<KnownPoint> known;
        public ArrayList<ZonePoint> zone;

        public ArrayList<boolean[]> answers;
        public ArrayList<Integer> answersCount;

        private Frequency[] frequency;
		public int[][] correlation;
		public int maximumMines;

        public Group()
        {
            this.unknown = new ArrayList<UnknownPoint>(15);
            this.known = new ArrayList<KnownPoint>(10);
            this.answers = new ArrayList<boolean[]>(10);
            this.answersCount = new ArrayList<Integer>(10);
            this.zone = new ArrayList<ZonePoint>(20);
        }

        public Frequency[] Frequency()
        {
//            get
//            {
                if (this.frequency == null)
                {
                    int i;

                    this.frequency = new Frequency[maximumMines + 1];
                    for (i = 0; i < frequency.length; i++)
                    {
                        frequency[i] = new Frequency();
                    }
                    
                    for (i = 0; i < answers.size(); i++)
                    {
                        frequency[answersCount.get(i)].times++;
                    }
                }

                return this.frequency;
 //           }
        }

		public void CalculateCorrelation()
		{
			correlation = new int[unknown.size()][ unknown.size()];
			for (boolean[] answer : answers)
			{
				for (int i = 0; i < answer.length; i++)
				{
					if (answer[i])
					{
						correlation[i][ i]++;

						for (int j = i + 1; j < answer.length; j++)
						{
							if (answer[j])
							{
								correlation[i][ j]++;
								correlation[j][ i]++;
							}
						}
					}
				}
			}
		}

		@Override
        public String toString()
        {
            StringBuilder stringBuilder = new StringBuilder();
            int i, j, k;

			stringBuilder.append("\tKnown Points\r\n\t\t");
            for (i = 0; i < known.size(); i++)
            {
				stringBuilder.append(known.get(i).toString());
				if (i != known.size() - 1)
					stringBuilder.append(", ");
			}
            stringBuilder.append("\n");

            stringBuilder.append("\tUnknown Points\r\n");
            for (i = 0; i < unknown.size(); i++)
            {
				stringBuilder.append("\t\t"+ i /*.PadLeft(2)*/ + ": " + unknown.get(i).toString());
			}

            stringBuilder.append("\tZone\n");
            for (i = 0; i < zone.size(); i++)
            {
				stringBuilder.append("\t\t" + i/*.PadLeft(2)*/ + ": " + zone.get(i).toString());
			}

            stringBuilder.append("\tAnswers\n");
            if (answers.size() == 0) {
				stringBuilder.append("\t\tNone");
			}
            else if (answers.size() > 100) {
				stringBuilder.append("\t\t"+answers.size()+" answers");
            }
            else {
				boolean[] answer;
                for (j = 0; j < answers.size(); j++)
                {
					stringBuilder.append("\t\t["+j+"]\t");

                    answer = answers.get(j);

					for (k = 0; k < unknown.size(); k++)
                    {
						if (answer[k]) stringBuilder.append("x");
                        else stringBuilder.append(".");
					}
                    stringBuilder.append("\t"+answersCount.get(j)+"\r\n");
				}
			}

            stringBuilder.append("\tFrequency\n");
            if (frequency == null)
            {
				stringBuilder.append("\t\tNone\n");
            }
            else
            {
                for (i = 0; i < frequency.length; i++)
                {
				    stringBuilder.append("\t\t["+i+"] "+ frequency[i].toString()+"\r\n");
                }
            }

            stringBuilder.append("\n");

			stringBuilder.append("\tCorrelation\n");
			if (correlation == null)
			{
				stringBuilder.append("\t\tNone\n");
			}
			else
			{
				for (i = 0; i < correlation.length; i++)
				{
					stringBuilder.append("\t\t");
					for (j = 0; j < correlation[0].length; j++)
					{
						stringBuilder.append( correlation[i][ j]+"\t");
					}
					stringBuilder.append("\n");
				}
			}

			stringBuilder.append("\n");

            return stringBuilder.toString();
        }

		public void javaGarbage() {
			this.unknown.clear();
			
		}
    }
