package net.zomis.plugin;

import java.util.ArrayList;
import java.util.List;

import net.zomis.UtilZomisUtils;
import net.zomis.mfe.plugin.ThreadInterruptCheck;
import net.zomis.minesweeper.ais.AI_Extreme3;
import net.zomis.minesweeper.ais.AI_Nightmare;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.ais.StaticAISupplier;
import net.zomis.minesweeper.ais.utils.AICompare;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.classic.DefaultExpanderRule;
import net.zomis.minesweeper.classic.StandardNeighbors;
import net.zomis.minesweeper.classic.StandardWeapons;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.EventRegister;
import net.zomis.minesweeper.events.EventRegistrator;
import net.zomis.minesweeper.events.game.GameStartEvent;
import net.zomis.minesweeper.events.game.PlayerMoveEvent;
import net.zomis.minesweeper.events.invites.InvitePreStartEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.weapons.classic.BombWeapon;
import net.zomis.minesweeper.weapons.classic.ClickWeapon;

public class WWAINDPlugin extends MinesweeperPlugin implements EventRegistrator {
	public static List<Class<? extends AI_Zomis>> getAIs() {
		 List<Class<? extends AI_Zomis>> ais = new ArrayList<Class<? extends AI_Zomis>>();
		 ais.add(AI_Nightmare.class);
		 ais.add(AI_Extreme3.class);
		 return ais;
	}
	
	public void onStart(GameStartEvent event) {
		createSituation(event.getGame());
	}
	
	public void onMove(PlayerMoveEvent event) {
		event.setCancelled(true);
		
//		MinesweeperMove move = new MinesweeperMove(event.getGame().getCurrentPlayer(), event.getMove().getWeaponType(), event.getMove().getMovePosition());
//		move.makeMove(); // This causes an infinite loooooooooooooooop!
		event.getGame().sendChatMessage("Move " + event.getMove() + " @ " + event.getGame().saveMap());
		createSituation(event.getGame());
	}
	
	public void onMove(InvitePreStartEvent event) {
		if (event.getInvite().getPlugins().contains(this)) {
			event.getInvite().setAIDelay(false);
			event.getInvite().setPublic(true);
		}
	}

	@Command(command = "wwaind", help = "What would AI Nightmare do?")
	public void wwaind(PlayerCommandEvent event) {
		if (event.getGame() == null || !event.getGame().hasPlugin(this)) {
			event.getPlayer().sendChat("/wwaind can only be used within a game using the " + this.getSimpleName() + " plugin.");
			return;
		}
		if (event.getGame().hasPlugin(this)) {
/*			for (Class<? extends AI_Zomis> clazz : getAIs()) {
                MinesweeperPlayingPlayer pp = event.getGame().getCurrentPlayer();
				AI_Zomis ai = (AI_Zomis) event.getGame().getMapFactory().ai(pp, clazz);
				MinesweeperMove move = ai.play(pp);
				List<FieldScore> list = ai.createScoreProvider(pp).analyzeAndScore(move.getWeapon(), false).getBestFields();
				event.getPlayer().sendChat(ai.getClass().getSimpleName() + ": " + move + " with possible fields " + UtilZomisUtils.implode(", ", list));
			}*/
		}
	}
	
	private void createSituation(MinesweeperGame game) {
		game.sendChatMessage("Creating a situation...");
		MinesweeperMap map = game.getMapFactory().withTwoPlayers().withDefaultWeapons().loadFrom(game.saveMap()).map();
		for (MinesweeperPlayingPlayer pp : map.getPlayingPlayers()) {
			pp.giveWeapon(new BombWeapon());
			pp.giveWeapon(new ClickWeapon());
		}
		map.setCurrentPlayerTurn(game.getCurrentPlayer().getIndex());

        StaticAISupplier ai1 = new StaticAISupplier(new AI_Nightmare(new ThreadInterruptCheck()));
        StaticAISupplier ai2 = new StaticAISupplier(new AI_Extreme3());
		AICompare compare = new AICompare(map, ai1, ai2);
		compare.solveConflict();
		while (compare.compareNext() && !map.isGameOver());
		
		game.loadMap(map.saveMap());
		MineprobHelper.regenerate(game, AnalyzeFactory.analyze(game, false).getAnalyze(), null);
		game.sendChatMessage("Situation Created!");
	}

	@Override
	public void onEnable() {
	}

	@Override
	public void onDisable() {
	}

	@Override
	public boolean canBeChosenBy(MinesweeperPlayer user) {
		return user.hasPermission(PlayerCommandEvent.PERMISSION_TRUSTED_USER);
	}

	@Override
	public void registerEvents(EventRegister events) {
		/*this.registerListener(this);
		this.registerListener(new DefaultExpanderRule());
		this.registerListener(new StandardNeighbors());
		this.registerListener(new StandardWeapons());*/
		// this.onMove x2, this.onStart
	}
}
