package net.zomis.minesweeper.analyze.impl;

import java.util.ArrayList;
import java.util.Collection;

import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.detail.DetailedResults;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;

public class AnalyzeProvider {

	private final DetailedResults<MinesweeperField> detailed;
	private final AnalyzeResult<MinesweeperField> result;
	
	AnalyzeProvider(MinesweeperMap map, boolean detailed) {
        MineprobabilityAnalyze root = new MineprobabilityAnalyze(map);
        this.result = root.solve();
        if (detailed) {
            this.detailed = result.analyzeDetailed(new DetailNeighborImpl());
        } else {
            this.detailed = null;
        }
	}
	
	public Collection<ProbabilityKnowledge<MinesweeperField>> getAllKnowledge() {
		if (this.detailed == null) return null;
		
		ArrayList<ProbabilityKnowledge<MinesweeperField>> a = new ArrayList<ProbabilityKnowledge<MinesweeperField>>();
		a.addAll(this.detailed.getProxies());
		return a;
	}
	public AnalyzeResult<MinesweeperField> getAnalyze() {
		return result;
	}
	
	public DetailedResults<MinesweeperField> getDetailed() {
		return detailed;
	}
	public ProbabilityKnowledge<MinesweeperField> getKnowledgeFor(MinesweeperField field) {
		if (this.detailed == null) return null;
		return this.detailed.getProxyFor(field);
	}
}
