package net.zomis.minesweeper.aiscore.debug;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.impl.EVCalculator;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class ZomisEV1 extends AbstractScorer {
	private EVCalculator	evCalc;

	@Override
	public double getScoreFor(MinesweeperField field,
			ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		return this.evCalc.calcEV(data).getEv();
	}

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		evCalc = new EVCalculator(scores.getAnalyze());
		return this.weaponIsClick(scores.getWeapon());
	}
}
