package net.zomis.minesweeper.aiscore;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.ZomisTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public class SafeOpenField extends AbstractScorer {
	@Override
	public double getScoreFor(MinesweeperField field,
			ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		if (this.isInterestingField(field, data, scores.getWeapon())) {
			return data.getMineProbability() / 4;
		}
		else return 0;
	}

	public boolean isInterestingField(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, MinesweeperWeapon weapon) {
		return (data.getMineProbability() > 0 && data.getProbabilities()[0] == 0 && ZomisTools.isZomisOpenField(field));
	}

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		if (!this.weaponIsClick(scores.getWeapon())) return false;
		
		return true; // this.getMario().getBoard().MaxExpectedValue() > 0;
	}
}
