package net.zomis.minesweeper.ais.otherscorers;

import java.util.Collection;
import java.util.Random;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class RandomBomber extends AbstractScorer {
	private Random random = new Random();

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return weaponIsBomb(scores.getWeapon()) && ereDags(scores.getPlayer());
	}

	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		return unclicked(scores.getWeapon().getFieldsAffected(scores.getPlayer(), field));
	}
	private double unclicked(Collection<MinesweeperField> fieldsAffected) {
		int i = 0;
		for (MinesweeperField ff : fieldsAffected) {
			if (!ff.isClicked()) i++;
		}
		return i;
	}

	/**
	 * @author Tejpbit
	 */
	private boolean ereDags(MinesweeperPlayingPlayer player) {
		// Code by Tejpbit
		if (random.nextInt(100) < 42) {
			int avarage = 0;

			for (int i = 0 ; i < player.getMap().getPlayingPlayers().size() ; i++) {
				avarage += player.getMap().getPlayingPlayers().get(i).getScore();
			}
			avarage /= player.getMap().getPlayingPlayers().size();

			if (player.getMap().getCurrentPlayer().getScore() < avarage - (random.nextInt(3) + 2)) {
				return true;
			}
			if (getHighestScore(player.getMap()) >= player.getMap().getMinesCount() * 0.4) {
				return true;
			}
		}
		
		return false;
	}
	/**
	 * @author Tejpbit
	 */
	private static int getHighestScore (MinesweeperMap map) {
		for (MinesweeperPlayingPlayer player : map.getPlayingPlayers()) {
			if (player.hasMostScore()) {
				return player.getScore();
			}
		}
		return 42;
	}
}
