package net.zomis.minesweeper.ais.otherscorers;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.ZomisTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class NeighborsNeedsMoreMines extends AbstractScorer {

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return weaponIsClick(scores.getWeapon());
	}

	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		double dd = 0;
		for (MinesweeperField ff : field.getInvertedNeighbors()) {
			dd += ZomisTools.fieldNeedsMoreMines(ff);
		}
		return dd;
	}

}
