package net.zomis.mario.mfeais;

import java.util.List;

import net.zomis.UtilZomisList;
import net.zomis.mario.classes.Board;
import net.zomis.mario.classes.Bot;
import net.zomis.mario.classes.Click;
import net.zomis.mario.classes.Point;
import net.zomis.mario.classes.Enums.Difficult;
import net.zomis.mario.classes.Enums.PlayerColor;
import net.zomis.minesweeper.analyze.InterruptCheck;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperGame;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

public abstract class AbstractMarioBot extends MinesweeperAI {
	public static boolean USE_RANDOMNESS = false;
	private final MinesweeperPlayingPlayer player;

	private Bot bot;
	
	public Bot getBot() {
		return this.bot;
	}
	
	public AbstractMarioBot(InterruptCheck interruptCheck, String name, MinesweeperPlayingPlayer player,
            Difficult difficulty) {
		super(name);
		this.player = player;
		bot = new Bot(interruptCheck, player.getIndex() == 0 ? PlayerColor.BLUE : PlayerColor.RED, difficulty);
	}

	@Override
	public boolean agreeDraw(MinesweeperPlayingPlayer pp) {
		return false;
	}

	@Override
	public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
		
		char[][] board = NightmareTools.fixBoard(pp, bot);

		try {
			List<Click> moves = bot.move(board); // The bot returns multiple moves when it knows that some moves are 100% mines.
			
			Click click = null;
			
			if (USE_RANDOMNESS) {
				click = UtilZomisList.getRandom(moves);
			}
			else {
				if (moves.isEmpty()) return null;
				
				click = moves.get(0);
			}
			
			if (click == null) {
				MinesweeperField field = UtilZomisList.getRandom(pp.getMap().getAllUnclickedFields());
				return pp.createMove(MinesweeperMove.STANDARD_CLICK, field);
			}
			this.sendClickInfo(click, bot.getBoard());
			return pp.createMove(MinesweeperMove.STANDARD_CLICK, pp.getMap().getPosition(click.col, click.row));
		}
		catch (Exception e) {
			this.sendChatMessage(pp, e.getClass().getCanonicalName() + ": " + e.getMessage());
			StackTraceElement[] stack = e.getStackTrace();
			for (int i = 0; i < stack.length && i < 20; i++) {
				this.sendChatMessage(pp, stack[i].toString());
			}
			return null;
		}
	}


	private void sendClickInfo(Click click, Board board) {
//		this.sendChatMessage(String.format("%s", click));
		
//		String additionalInfo = "";
//		if (click != null) {
//			Double[][][] allExpVal = bot.getBoard().ExpectedValues();
//			if (allExpVal != null) {
//				Double[] expVal = bot.getBoard().ExpectedValues()[click.row][click.col]; // Mario uses [y][x]
//				additionalInfo = ZomisUtils.implodeArr(", ", expVal);
//			}
//		}
//		String generalInfo = String.format("maxexp %f, maxfirst %f, minexp %f", bot.getBoard().MaxExpectedValue(), bot.getBoard().MaxFirstExpectedValue(),
//				bot.getBoard().MinExpectedValue());
//		
//		this.sendChatMessage(click + ": " + additionalInfo + " (" + generalInfo + ")");
	}

	public static void logBoards(MinesweeperPlayingPlayer pp, MinesweeperAI ai, char[][] board, MinesweeperGame game) {
		ai.sendChatMessage(pp, "The board I got was:");
		for (char[] ch : board) {
			ai.sendChatMessage(pp, new String(ch));
		}
		
		ai.sendChatMessage(pp, "While the real board is:");
		for (String str : pp.getMap().saveMapMultiline()) {
			ai.sendChatMessage(pp, str);
		}
	}
	
	@Override
	public boolean respondToInvite(Invite invite) {
/*		if (invite.getPlugins().size() != 1 || !invite.getPlugins().get(0).getSimpleName().equals("PluginClassicGame")) {
			invite.getHost().sendChatBy("Sorry, but " + this.getName() + " is only able to play classic games. 1 vs 1.");
			return false;
		}*/
		
		return true;
	}

	public void respondTo(PlayerCommandEvent event) {

		if (event.getParameter(0).contentEquals("expval")) {
			int x = event.getParameterInt(1, 0);
			int y = event.getParameterInt(2, 0);
			this.sendChatMessage(player, String.format("First expected value of %s is %f", new Point(y, x), this.bot.getBoard().FirstExpectedValue()[y][x]));
		}
		else if (event.getParameter(0).contentEquals("square")) {
			int x = event.getParameterInt(1, 0);
			int y = event.getParameterInt(2, 0);
			this.sendChatMessage(player, this.bot.getBoard().square[y][x].toString());
		}
		else if (event.getParameter(0).contentEquals("maxexp")) {
			this.sendChatMessage(player, String.format("Max expected value is %f", this.bot.getBoard().MaxExpectedValue()));
		}
		else if (event.getParameter(0).contentEquals("max1exp")) {
			this.sendChatMessage(player, String.format("Max first expected value is %f", this.bot.getBoard().MaxFirstExpectedValue()));
		}
		else if (event.getParameter(0).contentEquals("minexp")) {
			this.sendChatMessage(player, String.format("Min expected value is %f", this.bot.getBoard().MinFirstExpectedValue()));
		}
		else if (event.getParameter(0).contentEquals("min1exp")) {
			this.sendChatMessage(player, String.format("Min first expected value is %f", this.bot.getBoard().MinFirstExpectedValue()));
		}
		else if (event.getParameter(0).contentEquals("tostr")) {
			this.sendChatMessage(player, this.bot.getBoard().toString());
		}
		else if (event.getParameter(0).contentEquals("analyze")) {
			char[][] board = NightmareTools.fixBoard(player, bot);
			this.sendChatMessage(player, "Analyzing on command.");
			for (Click click : bot.move(board)) {
				this.sendChatMessage(player, "I would make this move: " + click);
			}
		}
		else {
			this.sendChatMessage(player, "I don't know how to respond to that. Try with one of these: expval, square, maxexp, max1exp, minexp, min1exp, tostr, analyze");
		}
	}

}
