package net.zomis.minesweeper.aiscore.debug;

import java.util.Collection;

import net.zomis.minesweeper.ais.BombTools;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class BombDebugScore extends AbstractScorer {
	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		MinesweeperPlayingPlayer player = scores.getPlayer();
		
		Collection<MinesweeperField> affected = scores.getPlayer().getWeapon(MinesweeperMove.STANDARD_BOMB).getFieldsAffected(player, field);
		if (affected.isEmpty()) return -10000;
		
		return BombTools.getBombProbability(affected, scores.getAnalyze().getAnalyze());
		// If it is not time, you need to return a lot of negative so that it is not higher than the score for a normal click
	}

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return true;
	}
}
