package net.zomis.minesweeper.aiscore;

import java.util.Collection;

import net.zomis.minesweeper.ais.BombTools;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class BombIfManyMinesScorer extends AbstractScorer {
	private final double threshold;
	
	public BombIfManyMinesScorer(double expectedPercentageOfMines) {
		this.threshold = expectedPercentageOfMines;
	}
	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		if (weaponIsClick(scores.getWeapon())) { // For MfeFrame, to see exact expected bomb result.
			return BombTools.getBombProbability(field, scores.getAnalyze().getAnalyze());
		}
		if (MineprobHelper.find100(scores.getAnalyze().getAnalyze()) > 0) return 0; // Don't bomb if there are 100% mines out there
		
		MinesweeperPlayingPlayer player = scores.getPlayer();
		Collection<MinesweeperField> affected = scores.getWeapon().getFieldsAffected(player, field);
		if (affected.size() == 0) return -10000;
		
		double dd = BombTools.getBombProbability(affected, scores.getAnalyze().getAnalyze());
		return (dd >= this.threshold * field.getMap().getMinesCount() ? 1000 : -1000) + dd;
		// If it is not time, you need to return a lot of negative so that it is not higher than the score for a normal click
	}
	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return this.weaponIsBomb(scores.getWeapon());
	}
}
