package net.zomis.minesweeper.ais.mirror;

import net.zomis.minesweeper.ais.AI_Extreme3;
import net.zomis.minesweeper.ais.AI_Medium;
import net.zomis.minesweeper.ais.AI_ZLoser;
import net.zomis.minesweeper.ais.StatUtils;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.scores.ScoreParameters;

public class MirrorScorerRating extends MirrorScorer {

	private final Analyze_AI_Mirror	mirror;
	public MirrorScorerRating(Analyze_AI_Mirror mirror) {
		this.mirror = mirror;
	}
	
	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return false;
	}

	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		return 0;
	}

	@Override
	public boolean moveInform(MinesweeperMove move, MinesweeperMap map) {
		return true;
	}

	@Override
	public double getPower() {
		return 0;
	}
	
	@Override
	public Double getExpectedRating(Analyze_AI_Mirror mirror) {
		MirrorScorerAI main = null;
		MirrorScorerAI penalty = null;
		MirrorScorerAI penalty2 = null;
		for (MirrorScorer mscorer : mirror.getMirrors()) {
			if (mscorer instanceof MirrorScorerAI) {
				MirrorScorerAI ais = (MirrorScorerAI) mscorer;
				
				if (ais.getAIClass().equals(AI_Extreme3.class)) main = ais;
				if (ais.getAIClass().equals(AI_Medium.class)) penalty = ais;
				if (ais.getAIClass().equals(AI_ZLoser.class)) penalty2 = ais;
				
			}
			
		}
		double e3rating2 = 2500 * main.getNormalizedAverage() * main.getAcceptable();
		double p1 = e3rating2 - 2000 * penalty.getAcceptable();
		double p2 = e3rating2 - 1000 * penalty2.getAcceptable();

		double mean = StatUtils.mean(new double[]{ e3rating2, p1, p2 });

		return (mean < 1500.0 ? mean - 700 : mean);
	}
	@Override
	public String toString() {
		return "Your expected rating: " + this.getExpectedRating(mirror);
	}
}
