package net.zomis.minesweeper.ais.mirror;

import java.util.List;

import net.zomis.minesweeper.ais.*;
import net.zomis.minesweeper.analyze.endgame.PlayerUtils;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.Minesweeper;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AnalyzeMethod;
import net.zomis.minesweeper.scores.ScoreConfigFactory;

public class DisabledAI_Mirror2 extends AI_Zomis {
	private Analyze_AI_Mirror	mirror;
	private int lastMove = 0;
	private void updateAnalyze(MinesweeperPlayingPlayer pp) {
		if (this.mirror == null) {
			this.mirror = newMirror(getOpponent(pp));
		}
		
		if (lastMove > pp.getMap().getMoveHistory().size()) {
			// Expander rule has been applied. Reset mirror analyze.
			this.mirror = newMirror(getOpponent(pp));
			lastMove = 0;
		}
		
		List<MinesweeperMove> newMoves = pp.getMap().getMoveHistory().subList(lastMove,
			pp.getMap().getMoveHistory().size());
		for (MinesweeperMove move : newMoves) {
			if (move.getPlayer() != pp) {
				mirror.moveInform(move);
			}
		}
		lastMove += newMoves.size();
	}

	private static Analyze_AI_Mirror newMirror(MinesweeperPlayingPlayer player) {
		Analyze_AI_Mirror mirr = new Analyze_AI_Mirror(player);
		mirr
			.addScorer(new MirrorScorerAI(player, new StaticAIZomisSupplier(new AI_Extreme3())))
			.addScorer(new MirrorScorerAI(player, new StaticAIZomisSupplier(new AI_HardPlus())))
			.addScorer(new MirrorScorerAI(player, new StaticAIZomisSupplier(new AI_Medium())))
            .addScorer(new MirrorScorerAI(player, new StaticAIZomisSupplier(new AI_ZLoser())))
            .addScorer(new MirrorScorerAI(player, new StaticAIZomisSupplier(new Disabled_AI_Horrible())))
//			.addScorer(new MirrorDontTakeAll100())
            .addScorer(new MirrorScorerRating(mirr))
        ;
		return mirr;
	}

	private MinesweeperPlayingPlayer getOpponent(MinesweeperPlayingPlayer pp) {
		return PlayerUtils.getLastPlayer(pp);
	}

	public DisabledAI_Mirror2(MinesweeperPlayingPlayer player) {
		super("#AI_Mirror2", new ScoreConfigFactory(AnalyzeMethod.ZOMIS_ADVANCED)
			.withScorer(new MirrorScorerAI(PlayerUtils.getLastPlayer(player), new StaticAIZomisSupplier(new AI_Extreme3())))
			.withScorer(new MirrorScorerAI(PlayerUtils.getLastPlayer(player), new StaticAIZomisSupplier(new AI_HardPlus())))
			.withScorer(new MirrorScorerAI(PlayerUtils.getLastPlayer(player), new StaticAIZomisSupplier(new AI_Medium())))
			.withScorer(new MirrorScorerAI(PlayerUtils.getLastPlayer(player), new StaticAIZomisSupplier(new AI_ZLoser())))
			.withScorer(new MirrorScorerAI(PlayerUtils.getLastPlayer(player), new StaticAIZomisSupplier(new Disabled_AI_Horrible())))
			.build());
		
		this.getConfig().getScorers().keysToList();
		if (Minesweeper.getServer() == null || !Minesweeper.getServer().getHostName().contentEquals("Zomis7")) {
			this.hide();
		}
	}

	@Override
	public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
		this.updateAnalyze(pp);
		if (this.mirror.getCount() <= 0) {
			return new AI_Complete_Idiot().play(pp);
		}
		
		this.sendChatMessage(pp, this.mirror.toString());
		
		AI_Zomis ai = new AI_Zomis(getName(), mirror.getScoreConfig()) {};
		ai.setBackup(new StaticAISupplier(new AI_Complete_Idiot()));
		return ai.play(pp);
	}

	@Override
	public boolean respondToInvite(Invite invite) {
		return true;
	}

	@Override
	public boolean agreeDraw(MinesweeperPlayingPlayer pp) {
		return MineprobHelper.isDraw(pp.getMap());
	}

}
