package net.zomis.mfe.plugin;

import java.util.Collection;

import net.zomis.UtilZomisUtils;
import net.zomis.mario.mfeais.AbstractMarioBot;
import net.zomis.mario.mfeais.NightmareTools;
import net.zomis.mario.mfeais.Slow_AI_Mario_A2;
import net.zomis.minesweeper.ais.AI_Nightmare;
import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.ais.MarioAnalyze;
import net.zomis.minesweeper.ais.mirror.AI_Mirror;
import net.zomis.minesweeper.ais.test.AI_Debug;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventRegister;
import net.zomis.minesweeper.events.EventRegistrator;
import net.zomis.minesweeper.events.invites.InviteGameStartingEvent;
import net.zomis.minesweeper.events.invites.InvitePreStartEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.events.player.PlayerLoginEvent;
import net.zomis.minesweeper.functional.Consumer;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.PreScorer;

public class NightmarePlugin extends MinesweeperPlugin implements EventRegistrator {
	public void gameCheckMirror(InvitePreStartEvent event) {
		for (MinesweeperPlayer player : event.getInvite().getPlayers()) {
			if (player.isAI() && player.getName().contentEquals("#" + AI_Mirror.class.getSimpleName())) {
				event.getInvite().setRating(false);
			}
			if (player.isAI() && player.getName().contentEquals("#" + AI_Debug.class.getSimpleName())) {
				event.getInvite().setRating(false);
			}
		}
		
//		if (event.getInvite().getPlayers().size() != 2)
	}

	public void gameCheckMarioCompatibility(InviteGameStartingEvent event) {
//		event.getInvite().getHost().sendAlert("is real player ? " + event.getInvite().getHost().isRealPlayer());
		
		if (!event.getInvite().getHost().isRealPlayer()) return;
		
//		event.getInvite().getHost().sendAlert("Checking mario compat");
		
		String marioAI = null;
		MinesweeperMap map = event.getGame();
		for (MinesweeperPlayingPlayer pp : map.getPlayingPlayers()) {
			if (pp.getAI() instanceof AI_Zomis) {
				AI_Zomis ai = (AI_Zomis) pp.getAI();
				for (PreScorer scorer : ai.getConfig().getPreScorers())
					if (scorer instanceof MarioAnalyze)
						marioAI = ai.getName();
			}
		}
		if (marioAI == null) return;
		
//		event.getInvite().getHost().sendAlert("Mario found: " + marioAI);
		
		MinesweeperField field = map.getPosition(1, 1);
		Collection<MinesweeperField> neighbors = field.getNeighbors();
		if (neighbors.size() != 8) {
			event.setCancelled(true);
		}
		else {
			for (int x = -1; x <= 1; x++)
			for (int y = -1; y <= 1; y++)
			if (x != 0 || y != 0) {
				if (!neighbors.contains(field.getRelativePosition(x, y)))
					event.setCancelled(true);
			}
		}
		
		for (MinesweeperField ff : map.getIteration()) {
			if (ff.isBlocked())
				event.setCancelled(true);
		}
		
		if (event.isCancelled()) {
			for (MinesweeperPlayer player : event.getInvite().getPlayers()) {
				player.sendAlert(marioAI + " can not play with plugins: " + UtilZomisUtils.implode(", ", event.getInvite().getPlugins()));
			}
		}
	}
	
	public void login(PlayerLoginEvent event) {
		String mess = "Can you beat #" + AI_Nightmare.class.getSimpleName() + " ?";
		
		if (event.getPlayer().isClientFlash())
			event.getPlayer().sendChat(mess + " You can play the AIs by double-clicking the name in the list to the right!", 0xFFFF00);
		else {
			event.getPlayer().sendChat(mess);
		}
		event.getPlayer().sendChat("Please don't play against yourself to get rating. You will get caught.", 0xFFFF00);
		event.getPlayer().sendChat("A football team does not leave the field if they are going to lose. It's good sportsmanship to finish a game even if you are losing.", 0xFFFF00);
		
		if (event.getPlayer().hasPermission(PlayerCommandEvent.PERMISSION_DONATOR) && !event.getPlayer().hasPermission(PlayerCommandEvent.PERMISSION_ADMIN)) {
			event.getServer().broadcastLobbyChat("#Server: #Server gives a donut to " + event.getPlayer().getDisplayName() + " for being a donator!");
		}
	}
	
	@Command(command = "night", help = "Test Mario's code's view of the board", requiredPermission = PlayerCommandEvent.PERMISSION_TRUSTED_USER)
	public void chat(PlayerCommandEvent event) {
		if (event.getParameter(0).contentEquals("time")) {
			Slow_AI_Mario_A2 mario = new Slow_AI_Mario_A2(event.getMap().getCurrentPlayer());
			char[][] board = NightmareTools.fixBoard(event.getMap().getCurrentPlayer(), mario.getBot());
			long time = System.nanoTime();
			mario.getBot().move(board);
			time = System.nanoTime() - time;
			
			event.getPlayer().sendChat("Mario's code took " + MineprobHelper.nanoToMilli(time) + " milliseconds.");
			return;
		}

		for (MinesweeperPlayingPlayer pp : event.getMap().getPlayingPlayers()) {
			if (pp.isAI()) {
				if (pp.getAI() instanceof AbstractMarioBot) {
					AbstractMarioBot nightmare = (AbstractMarioBot) pp.getAI();
					nightmare.respondTo(event);
					return;
				}
			}
		}
		
		AbstractMarioBot bot = new Slow_AI_Mario_A2(event.getMap().getCurrentPlayer());
		bot.play(event.getMap().getCurrentPlayer());
		bot.respondTo(event);
		
	}
	@Override
	public boolean canBeChosenBy(MinesweeperPlayer arg0) {
		return false;
	}

	@Override
	public void onDisable() {
	}

	@Override
	public void onEnable() {
	}

	@Override
	public void registerEvents(EventRegister events) {
		events.registerListener(InvitePreStartEvent.class, new Consumer<InvitePreStartEvent>() {
			@Override
			public void accept(InvitePreStartEvent invitePreStartEvent) {
				gameCheckMirror(invitePreStartEvent);
			}
		});
		events.registerListener(InviteGameStartingEvent.class, new Consumer<InviteGameStartingEvent>() {
			@Override
			public void accept(InviteGameStartingEvent inviteGameStartingEvent) {
				gameCheckMarioCompatibility(inviteGameStartingEvent);
			}
		});
		events.registerListener(PlayerLoginEvent.class, new Consumer<PlayerLoginEvent>() {
			@Override
			public void accept(PlayerLoginEvent playerLoginEvent) {
				login(playerLoginEvent);
			}
		});

	}

}
