package net.zomis.mario.classes;

import java.util.ArrayList;

    public class Permutation implements Cloneable
    {
        public ArrayList<Integer> groupIndex;
        public double nPermutation;
        public double probability;
        public int mines;

        public Permutation()
        {
            groupIndex = new ArrayList<Integer>(5);
            nPermutation = 1;
        }
        public Permutation(Permutation permutation)
        { 
            groupIndex = new ArrayList<Integer>(permutation.groupIndex.size());
            for (int n : permutation.groupIndex)
            {
                groupIndex.add(n);
                mines += n;
            }
            nPermutation = permutation.nPermutation;
        }

        @Override
        public String toString()
        {
            StringBuilder stringBuilder = new StringBuilder();

            for (int i = 0; i < groupIndex.size(); i++)
            {
                stringBuilder.append("\tGroup {0}: {1}\r\n", i, groupIndex.get(i));
            }
            stringBuilder.append("\tnPermutation: "+nPermutation+"\r\n");
            stringBuilder.append("\tMines: "+mines+"\r\n");
            stringBuilder.append("\tProbability: "+((Double)probability).toString(/*"0.######"*/)+"\r\n");

            return stringBuilder.toString();
        }

//        #region ICloneable Members


        public Permutation Clone()
        {
            Permutation permutation = new Permutation();

            permutation.groupIndex = groupIndex = new ArrayList<Integer>(this.groupIndex.size());
            for (int n : this.groupIndex)
            {
                permutation.groupIndex.add(n);
                permutation.mines += n;
            }
            permutation.nPermutation = this.nPermutation;

            return permutation;
        }
		public void javaGarbage() {
			if (this.groupIndex != null)
				this.groupIndex.clear();
			this.groupIndex = null;
		}

//        #endregion
    }
