package net.tejpbit.ais;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

import net.zomis.minesweeper.ais.AI_Complete_Idiot;
import net.zomis.minesweeper.api.Invite;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;

// @AI(rating = -500)
public class AI_Challenger extends MinesweeperAI {

	public AI_Challenger() {
		super("#AI_Challenger");
	}

	@Override
	public boolean agreeDraw(MinesweeperPlayingPlayer pp) {
		return false;
	}

	@Override
	public MinesweeperMove play(MinesweeperPlayingPlayer pp) {
		
		Set<MinesweeperField> notMine = new HashSet<MinesweeperField>();
		List<MinesweeperField> possibleMine = new ArrayList<MinesweeperField>();
		
		for (MinesweeperField field : pp.getMap().getIteration()) {
			
			if (field.isClicked() && !field.isMine() && !field.isBlocked()) {
				
				if (getFoundAdjacentMines(field) == field.getValue()) {
					for (MinesweeperField neighbor : field.getNeighbors()) {
						if (!neighbor.isClicked())
							notMine.add(neighbor);
						
					}
				}
				
			}
		}
		
		for (MinesweeperField field : pp.getMap().getIteration()) {
			if (!field.isClicked() || field.isMine() || field.isBlocked())
				continue;
			
			int possibleMineCount = 0;
			
			for (MinesweeperField neighbor : field.getNeighbors()) {
				if (!neighbor.isClicked() && !notMine.contains(neighbor))
					possibleMineCount ++;
			}
			
			if (getFoundAdjacentMines(field) + possibleMineCount == field.getValue()) {
				for (MinesweeperField neighbor : field.getNeighbors()) {
					if (!neighbor.isClicked() && !notMine.contains(neighbor)) {
//						this.sendChatMessage("Neighbor :" + neighbor.getCoordinate());
//						this.sendChatMessage("Field :" + field.getCoordinate());
						return pp.createMove(MinesweeperMove.STANDARD_CLICK, neighbor);
					}
				}
			}
			else if (getFoundAdjacentMines(field) < field.getValue()) {
				for (MinesweeperField neighbor : field.getNeighbors()) {
					if (!neighbor.isClicked() && !notMine.contains(neighbor)) {
						if (!possibleMine.contains(neighbor))
							possibleMine.add(neighbor);
					}
				}
			}
		}
		
		if (possibleMine.size() < 10) {
			if (ereDags(pp)) {
				return pp.createMove(MinesweeperMove.STANDARD_BOMB, getAIBombPos(pp.getMap()));
			}
		}
		
		if (possibleMine.size() > 0) {
//			this.sendChatMessage("PossibleMine :" + possibleMine.size());
			Random random = new Random();
			int randInt = random.nextInt(possibleMine.size());
			
			return pp.createMove(MinesweeperMove.STANDARD_CLICK, possibleMine.get(randInt));
		}
		
		if (ereDags(pp)) {
			return pp.createMove(MinesweeperMove.STANDARD_BOMB, getAIBombPos(pp.getMap()));
		}
		
		return new AI_Complete_Idiot().play(pp);
	}


	
	private int getFoundAdjacentMines (MinesweeperField field) {
		
		int mineCount = 0;
		
		for (MinesweeperField neighbor : field.getNeighbors()) {
			if (neighbor.isClicked() && neighbor.isMine()) {
				mineCount++;
			}
		}
		
		return mineCount;
	}
	
	private boolean ereDags(MinesweeperPlayingPlayer pp) {
		Random random = new Random();
		
		if (pp.getMap().getCurrentPlayer().canUseWeapon(MinesweeperMove.STANDARD_BOMB) && random.nextInt(100) < 42)
		{
			int avarage = 0;

			for (int i = 0 ; i < pp.getMap().getPlayingPlayers().size() ; i++) {
				avarage += pp.getMap().getPlayingPlayers().get(i).getScore();
			}
			avarage /= pp.getMap().getPlayingPlayers().size();

			if (pp.getMap().getCurrentPlayer().getScore() < avarage - (random.nextInt(3) + 2)) {

				return true;
			}

			if (getHighestScore(pp.getMap()) >= pp.getMap().getMinesCount() * 0.4) {

				return true;
			}

		}
		
		return false;
	}
	
	
	@Override
	public boolean respondToInvite(Invite invite) {
		return true;
	}

	static int getHighestScore (MinesweeperMap game) {

		for (MinesweeperPlayingPlayer player : game.getPlayingPlayers()) {
			if (player.hasMostScore()) {
				return player.getScore();
			}
		}
		return 42;
	}


	static public MinesweeperField getAIBombPos (MinesweeperMap game) {

		List<MinesweeperField> bombable = new ArrayList<MinesweeperField>();

		int maxPossibleBombClick = 0;

		for (MinesweeperField gamePosition : game.getIteration()) {

			int unClickedPosCurrentBomb = 0;

			for (int y = -2 ; y <= 2 ; y++) {
				for (int x = -2 ; x <= 2 ; x++) {

					if (game.getPosition(gamePosition.getX()+x, gamePosition.getY()+y) != null) {

						if(!game.getPosition(gamePosition.getX()+x, gamePosition.getY()+y).isClicked())
							unClickedPosCurrentBomb++;
					}

				}
			}

			if (maxPossibleBombClick < unClickedPosCurrentBomb) {
				bombable.clear();
				bombable.add(gamePosition);
			}
			else if (maxPossibleBombClick == unClickedPosCurrentBomb) {
				bombable.add(gamePosition);
			}

			maxPossibleBombClick = Math.max(maxPossibleBombClick, unClickedPosCurrentBomb);
		}

		Random random = new Random();

		return bombable.get(random.nextInt(bombable.size()));
	}
	
	
}
