package net.zomis.minesweeper.analyze.impl;

import java.util.*;

import net.zomis.minesweeper.analyze.FieldRule;
import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.RuleConstraint;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.game.MinesweeperField;
/**
 * A slow way of calculating expected value. creates new RootAnalyze object and adds a few rules.
 * 
 * @author Zomis
 */
public class EVCalculator {
	private final AnalyzeProvider	analyze;

	public EVCalculator(AnalyzeProvider analyze) {
		this.analyze = analyze;
	}

	public EVInfo calcEV(ProbabilityKnowledge<MinesweeperField> data) {
		double[] payoffs = this.calcPayoffs(data);
		double minePayoff = this.calcMinePayoff(data.getField());

		return new EVInfo(data, minePayoff, payoffs);
	}

	private double calcMinePayoff(MinesweeperField field) {
		return this.getRevealedBy(Arrays.asList(MineprobabilityAnalyze.ruleForField(field, true)));
	}

	private double getRevealedBy(List<FieldRule<MinesweeperField>> ruleList) {
        List<RuleConstraint<MinesweeperField>> constraints = new ArrayList<RuleConstraint<MinesweeperField>>(ruleList);
		AnalyzeResult<MinesweeperField> revealAnalyze = analyze.getAnalyze().cloneAddSolve(constraints);
		return MineprobHelper.find100(revealAnalyze);
	}

	private double[] calcPayoffs(ProbabilityKnowledge<MinesweeperField> data) {
		double[] result = new double[data.getProbabilities().length];
		int found = MineprobHelper.getFound(data.getField());
		for (int i = 0; i < result.length; i++) {
			if (data.getProbabilities()[i] <= 0) continue;
			result[i] = this.getRevealedBy(Arrays.asList(
				MineprobabilityAnalyze.ruleForField(data.getField(), false),
				MineprobabilityAnalyze.ruleFromField(data.getField(), i - found))
			);
		}
		
		return result;
	}
	
	public Map<MinesweeperField, Double> calculateEV() {
		Map<MinesweeperField, Double> map = new HashMap<MinesweeperField, Double>();
		for (ProbabilityKnowledge<MinesweeperField> data : this.analyze.getAllKnowledge()) {
			map.put(data.getField(), this.calcEV(data).getEv());
		}
		return map;
	}
}
