package net.zomis.minesweeper.aiscore;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.utils.OpenFieldApproxer;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

public class OpenFieldsPenalty extends AbstractScorer {
	private OpenFieldApproxer openField = new OpenFieldApproxer();
	
	@Override
	public double getScoreFor(MinesweeperField field,
			ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		if (this.isInterestingField(field, data, scores.getWeapon())) {
			
			// TODO: AI Modify penalty for this kind of situation?    012a2123a2___1b1-01b33a2aa41_1221-012b3234aa1_1a1_-1122a11a321_111_-1b1111111_______-332_____________-aa1_____________-221__xx______x__-_______________x-__111____111____-x_1a1_1122a32_x_-x_11213a3a5aa4b3-___13a4a43abb__x-1234aa313b432___-2aaaa3214a422___-a4a4211a3a3aa1_x
			// x Adjust penalty for ff here: 012a2123a2___1b1-01b33a2aa41_1221-012b3234aa1_1a1_-1122a11a321_111_-1b1111111_______-332_____________-aa1_____________-221__xx______x__-_______________x-__111____111____-x_1a1_1122a323a2-x_11213a3a5aa4b3-___13a4a43abb32b-1234aa313b432111-2aaaa3214a4221__-a4a4211a3a3aa1_x
			// x quite obvious penalty incorrect: 012a2123a2___1b1-01b33a2aa41_1221-012b3234aa1_1a1_-1122a11a321_111_-1b1111111_______-332_____________-aa1_________111_-221__xx_____1a21-____________112b-__111____111_122-x_1a1_1122a323a2-x_11213a3a5aa4b3-___13a4a43abb32b-1234aa313b432111-2aaaa3214a4221__-a4a4211a3a3aa1_x
			
			double expected = openField.expectedFrom(scores.getAnalyze(), field);
			double probability = data.getProbabilities()[0] 		 * 7;
			double factor = 1;
			
//			logger.info(String.format("%s: Expected %f prob %f factor %f", field, expected, probability, factor));
			
			return -(expected * probability * factor);
		}
		else return 0;
	}

	public boolean isInterestingField(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, MinesweeperWeapon weapon) {
		return data.getProbabilities()[0] > 0;
	}

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		if (!this.weaponIsClick(scores.getWeapon())) return false;
		
		return true; // this.getMario().getBoard().MaxExpectedValue() <= 0;
		
		
//		int realGroups = 0;
//		for (FieldGroup<MinesweeperField> group : this.analyze.getAnalyze().getGroups()) {
//			if (group.getProbability() > 0) realGroups++;
//		}
//		
//		return this.weaponIsClick(weapon) && realGroups < 2;
	}
}
