package net.zomis.minesweeper.aiscore;

import java.util.Collection;

import net.zomis.minesweeper.ais.BombTools;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class BombScore extends AbstractScorer {
	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		MinesweeperPlayingPlayer player = scores.getPlayer();
		
		Collection<MinesweeperField> affected = scores.getWeapon().getFieldsAffected(player, field);
		if (affected.isEmpty()) return -10000;
		
		double dd = BombTools.getBombProbability(affected, scores.getAnalyze().getAnalyze());
		return (player.getScore() + dd >= field.getMap().getMinesCount() / 2.0 ? 100000 : -100) + dd;
		// TODO: Calculate number of mines needed to win, for 3+ player games.
		// If it is not time, you need to return a lot of negative so that it is not higher than the score for a normal click
	}

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		return this.weaponIsBomb(scores.getWeapon());
	}
}
