package net.zomis.minesweeper.ais.test;

import net.zomis.minesweeper.ais.*;
import net.zomis.minesweeper.api.Minesweeper;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.AnalyzeMethod;
import net.zomis.minesweeper.scores.ScoreConfigFactory;

public class AI_Debug extends AI_Zomis {
	public AI_Debug(MinesweeperPlayingPlayer player) {
		super("#AI_Debug", new ScoreConfigFactory(AnalyzeMethod.ZOMIS_ADVANCED)
			.withPreScorer(new TestAnalyze())
			.withScorer(new AINormalizedScorer(new StaticAIZomisSupplier(new AI_Medium())), 0.7)
			.withScorer(new AINormalizedScorer(new StaticAIZomisSupplier(new AI_Extreme3())), 0.3)
			.withScorer(new TestUseAnalyze())
			
			
//			.withScorer(new BombStifleEffect())
//			.withScorer(new BombWinChance())
//			.withScorer(new IsOpenFieldGroup())
//			.withScorer(new BombDebugScore())
//			.withScorer(new NumRulesScorer())
//			.withScorer(new NumOrigRulesScorer())
//			.withScorer(new FieldGroupSizeScorer())
//			.withPost(new ChickenPlayCounter())
//			.withPost(new BombStifle())
			.build()
			);
		if (Minesweeper.getServer() == null || !Minesweeper.getServer().getHostName().contentEquals("Zomis7")) {
			this.hide();
		}
	}
}
