package net.zomis.minesweeper.ais.mirror;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public abstract class MirrorScorer extends AbstractScorer {

	@Override
	public abstract boolean workWithWeapon(ScoreParameters scores);

	@Override
	public abstract double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores);
	
	public abstract boolean moveInform(MinesweeperMove move, MinesweeperMap map);
	
	public Double getExpectedRating(Analyze_AI_Mirror mirror) {
		return null;
	}

	public abstract double getPower();
}
