package net.zomis.mfe.plugin;

import net.zomis.minesweeper.ais.AI_Zomis;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.api.ai.MinesweeperAI;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.game.PlayerAfterMoveEvent;
import net.zomis.minesweeper.events.invites.InviteGameStartingEvent;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.FieldScores;
import net.zomis.minesweeper.weapons.MinesweeperWeapon;

import java.util.List;

@Deprecated
public class NightmareDebugPlugin extends MinesweeperPlugin implements EventListener {
	private static final double	LIMIT	= 1000000;

	// @Event
	public void addDebug(InviteGameStartingEvent event) {
		if (event.getServer() != null && event.getServer().getHostName().contentEquals("Zomis7") && !event.getServer().hasDatabaseConnection()
				&& !event.getGame().getPlayingPlayers().get(0).getPlayer().isClientAndroid()) {
			if (event.getGame().getPlayingPlayers().get(0).getName().contentEquals("SimonForsberg")) {
				event.getGame().addPlugin(this);
			}
		}
	}
	
	@Command(command = "FF", help = "Add AI debug stuff to this game", requiredPermission = PlayerCommandEvent.PERMISSION_ADMIN)
	public void addDebug(PlayerCommandEvent event) {
		if (!event.getGame().hasPlugin(this))
			event.getGame().addPlugin(this);
	}
	
	// @Event
	public void onPostMove2(PlayerAfterMoveEvent event) {
		if (event.getServer() != null && event.getServer().getHostName().contentEquals("Zomis7")) {
			if (event.getGame().getPlayingPlayers().get(0).getName().contentEquals("SimonForsberg")) {
				MinesweeperAI ai = event.getGame().getPlayingPlayers().get(1).getAI();
				if (ai instanceof AI_Zomis) {
                    MinesweeperPlayingPlayer pp = event.getGame().getPlayingPlayers().get(0);
					AI_Zomis zomis = (AI_Zomis) ai;
					MinesweeperWeapon weapon = pp.getWeapon(MinesweeperMove.STANDARD_CLICK);
					FieldScores scores = zomis.getLastScores().get(weapon);
					if (scores != null) {
						scores.rankScores();
						event.getGame().sendChatMessage("Last rankings was " + scores.getRankCount());
					}
				}
				if (event.getGame().getMetadata().getClass(this.getClass()) == null) {
					double combs = AnalyzeFactory.analyze(event.getMap(), false).getAnalyze().getTotal();
					if (combs <= LIMIT) {
						event.getGame().sendChatMessage("Combs is low enough! " + combs);
						event.getGame().getMetadata().addClass(this);
					}
				}
			}
		}
	}

	@Override
	public void onEnable() {
		this.registerListener(this);
	}

	@Override
	public void onDisable() {
	}

	@Override
	public boolean canBeChosenBy(MinesweeperPlayer user) {
		return false;
	}
	
}
