package net.zomis.mario.classes;

import java.util.ArrayList;
import java.util.List;

import net.zomis.mario.classes.Enums.Difficult;

public class Bot extends Player {
	private Board board;
	public Board getBoard() {
		return this.board;
	}
	
	public void javaGarbage() {
		if (this.board != null) {
			this.board.javaGarbage();
		}
	}

	public Bot(Enums.PlayerColor player, Enums.Difficult difficult) {
		this.playerColor = player;
		this.difficulty = difficult;
	}

	@Override
	public List<Click> move(char[][] logicBoard) {
        return realmove(logicBoard);
	}
	
	private List<Click> realmove(char[][] logicBoard)
	{
		this.javaGarbage();
		
		if (difficulty == null) throw new IllegalStateException("Bot difficulty is null.");
		
		int i, j;
//		int row = -1, col = -1;
		List<Click> moves = new ArrayList<Click>();
		this.initBoard(logicBoard);
		
		board.Solve();

		if (difficulty != Enums.Difficult.VERY_EASY)
		{
			// MINAS OBVIAS
			boolean[][] obviousMines = board.obviousMines;
			for (i = 0; i < board.getDIMV(); i++)
			{
				for (j = 0; j < board.getDIMH(); j++)
				{
					if (obviousMines[i][ j])
					{
						moves.add(new Click(i, j, Enums.ClickType.OBVIOUS_MINE));
						return moves;
					}
				}
			}
		}

		if (difficulty.ordinal() >= Enums.Difficult.MEDIUM.ordinal())
		{
			// SIMULATION
			if (board.groups != null && board.groups.size() == 0 && board.maxExpectedValue != null && board.maxExpectedValue < 0)
			{
				if (difficulty.equals(Difficult.VERY_HARD_NO_SIMULATE)) return null;
				
				Board.Simulate(board, 6);
			}

			// MINAS NO TAN OBVIAS
			boolean[][] notSoObviousMines = board.notSoObviousMines;
			for (i = 0; i < board.getDIMH(); i++)
			{
				for (j = 0; j < board.getDIMV(); j++)
				{
					if (notSoObviousMines[i][ j])
					{
						moves.add(new Click(i, j, Enums.ClickType.NOT_SO_OBVIOUS_MINE));
						return moves;
					}
				}
			}
		}

		if (difficulty == Enums.Difficult.EASY || difficulty == Enums.Difficult.VERY_EASY)
		{
			// TIRO AL AZAR
//			do
//			{
//				col = random.nextInt(board.getDIMH()); 
//				row = random.nextInt(board.getDIMV());
//			} while (logicBoard[row][ col] != '?'); // this is highly inefficient and may cause inf-loop /Simon
//			moves.add(new Click(row, col, Enums.ClickType.RANDOM));
			moves.add(null); // tell the AI Controller to perform an AI Complete Idiot click
		}
		else if (difficulty == Enums.Difficult.MEDIUM)
		{
			// MAX FIRST EXPECTED VALUE
			boolean[][] maxExpectedValuePoints = board.MaxFirstExpectedValuePoints();
			
			for (i = 0; i < board.getDIMV(); i++) {
				for (j = 0; j < board.getDIMH(); j++) {
					if (maxExpectedValuePoints[i][j]) {
						moves.add(new Click(i, j, Enums.ClickType.MAX_FIRST_EXPECTED_VALUE));
					}
				}
			}
		}
		else if (difficulty == Enums.Difficult.HARD) {
			// MAX SECOND EXPECTED VALUE
			boolean[][] maxExpectedValuePoints = board.MaxExpectedValuePoints();
			for (i = 0; i < board.getDIMV(); i++) {
				for (j = 0; j < board.getDIMH(); j++) {
					if (maxExpectedValuePoints[i][j]) {
						moves.add(new Click(i, j, Enums.ClickType.MAX_EXPECTED_VALUE));
					}
				}
			}
		}
		else if (difficulty.ordinal() >= Enums.Difficult.VERY_HARD.ordinal()) {
			// MAX EXPECTED VALUE
			boolean[][] maxExpectedValuePoints = board.MaxExpectedValuePoints();
			for (i = 0; i < board.getDIMV(); i++) {
				for (j = 0; j < board.getDIMH(); j++) {
					if (maxExpectedValuePoints[i][j]) {
						moves.add(new Click(i, j, Enums.ClickType.MAX_EXPECTED_VALUE));
					}
				}
			}
		}

		return moves;
	}

	private void initBoard(char[][] logicBoard) {
		if (difficulty.ordinal() < Enums.Difficult.HARD.ordinal())
			board = new Board(logicBoard, 1, 1);
		else
			board = new Board(logicBoard, 1, 2);
		
		board.OnEventLog = null;
	
//		board.OnEventLog = new BoardEventLogHandler(){ // creating an anonymous inner class that leaks --> memory leak!
//			@Override
//			public void onEvent(Board sender, String description, LogLevel logLevel) {
//				board_OnEventLog(sender, description, logLevel);
//			}
//
//		};
	}
}

