package net.zomis.minesweeper.analyze.impl;

import java.util.Arrays;

import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;

public class EVInfo {

	private final double	minePayoff;
	private final double[]	payoffs;
	private final double	ev;
	private final MinesweeperField	field;

	public EVInfo(ProbabilityKnowledge<MinesweeperField> field, double minePayoff, double[] payoffs) {
		this.minePayoff = minePayoff;
		double ev = field.getMineProbability() * minePayoff;
		double[] probs = field.getProbabilities();
		for (int i = 0; i < payoffs.length; i++) {
			ev -= probs[i] * payoffs[i];
		}
		this.payoffs = payoffs;
		this.ev = ev;
		this.field = field.getField();
	}

	public double getEv() {
		return ev;
	}

	public double getMinePayoff() {
		return minePayoff;
	}
	public double[] getPayoffs() {
		return this.payoffs;
	}
	@Override
	public String toString() {
		return String.format("%s: %f. Mine payoff %f, payoffs: %s", this.field, this.ev, this.minePayoff, Arrays.toString(this.payoffs));
	}
	
}
