package net.zomis.minesweeper.analyze.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

import net.zomis.minesweeper.analyze.AnalyzeResult;
import net.zomis.minesweeper.analyze.AnalyzeFactory;
import net.zomis.minesweeper.analyze.detail.DetailedResults;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;

import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.TimeLimiter;

public class AnalyzeProvider {

	private static class SolveIt implements Callable<AnalyzeProvider> {
		private AnalyzeProvider	analyze;
		private boolean	detailed;

		public SolveIt(AnalyzeProvider analyzeProvider, boolean detailed) {
			this.analyze = analyzeProvider;
			this.detailed = detailed;
		}

		@Override
		public AnalyzeProvider call() throws Exception {
			analyze.result = this.analyze.root.solve();
			if (detailed) {
				this.analyze.detailed = analyze.result.analyzeDetailed(new DetailNeighborImpl());
			}
			else this.analyze.detailed = null;
			return this.analyze;
		}
	}
	private static TimeLimiter limiter = new SimpleTimeLimiter();
	
	private DetailedResults<MinesweeperField> detailed;
	private final AnalyzeFactory<MinesweeperField> root;
	private AnalyzeResult<MinesweeperField> result;
	
	AnalyzeProvider(MinesweeperMap map, boolean detailed, int timeout, TimeUnit timeUnit) throws Exception {
		this.root = new MineprobabilityAnalyze(map);
		limiter.callWithTimeout(new SolveIt(this, detailed), timeout, timeUnit, true);
	}
	
	public Collection<ProbabilityKnowledge<MinesweeperField>> getAllKnowledge() {
		if (this.detailed == null) return null;
		
		ArrayList<ProbabilityKnowledge<MinesweeperField>> a = new ArrayList<ProbabilityKnowledge<MinesweeperField>>();
		a.addAll(this.detailed.getProxies());
		return a;
	}
	public AnalyzeResult<MinesweeperField> getAnalyze() {
		return result;
	}
	
	public DetailedResults<MinesweeperField> getDetailed() {
		return detailed;
	}
	public ProbabilityKnowledge<MinesweeperField> getKnowledgeFor(MinesweeperField field) {
		if (this.detailed == null) return null;
		return this.detailed.getProxyFor(field);
	}
}
