package net.zomis.minesweeper.aiscore.mario;

import net.zomis.mario.classes.Square;
import net.zomis.minesweeper.ais.MarioAnalyze;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class RealMarioEV1 extends AbstractScorer {
	private MarioAnalyze	mario;
	
	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
//		MarioAnalyze mario = scores.getAnalyze(MarioAnalyze.class);
		Square square = mario.getSquare(field);
		
		if (MarioTools.isMarioOpenField(square)) return 0; // Modified to prevent too good score for 9d in situation: 23211111222a2222-baa11b22ab43b3ba-2332212a5b6a4a32-112a10114baa4210-2a2221002a54b100-b212b21233b21100-1103b42bb2221000-0002ba22211a1000-0001222111233210-1110012a11a2aa31-1b2212a211245b3a-12a2b212111aa221-121322_1b11221__-a322a1__2_______-2ab211_x2_______-1221____2xx___x_
//		if (this.isOpenFieldGroup(field) && data.getMineProbability() > 0) return 0; // TODO: AI Modified to try to fix this situation, but did not help since Mario return 0 expected value: 00000112a2bb21a1-000001b2234a2122-112111233b21212b-1b2a212bb2101b21-22323b3322112220-b23b44b202a21b21-12bb4bb324a223a1-_1224b42aa211a32-____2b212222333b-_11_______2aa4a3-23a__x_1123a4aa2-ab2_11_2a3b22221-331____3a3232100-a1_____a211aa100-121212a210122100-01b2a21100000000
		
		if (data.getMineProbability() == 0) {
			// Modified to fix a9 vs b9 situation below.
			boolean onlyOpenFieldNeighbors = true;
			for (MinesweeperField neighbor : field.getNeighbors()) {
				if (!MarioTools.isMarioOpenField(mario.getSquare(neighbor))) {
					onlyOpenFieldNeighbors = false;
					break;
				}
			}
			if (onlyOpenFieldNeighbors)
				return 0; 
		}
		
		// TODO: AI If open sea and Mario incorrect, return mineprobability. 012a2123a2___1b1-01b33a2aa41_1221-012b3234aa1_1a1_-1122a11a321_111_-1b1111111_______-332_____________-aa1_____________-221__xx______x__-_______________x-________________-x__x______a3__x_-x____13x3a5ax_x_-_____a_a__abx__x-____xa_1_x______-_aaaa____x______-x_x____x_x_xx__x
		// x Mario EV1 causing problems in this situation for a9 vs b9: 012a2123a2___1b1-01b33a2aa41_1221-012b3234aa1_1a1_-1122a11a321_111_-1b1111111_______-332_____________-aa1_____________-221__xx______x__-_______________x-_________1______-x__x___122a32_x_-x____13a3a5aa4b3-___13a4a43abb__x-1234aa313b432___-2aaaa3214a422___-a4a4211a3a3aa1_x
		// TODO: AI Mario EV1 + EVScorer ea vs e6: 012a2123a2___1b1-01b33a2aa41_1221-012b3234aa1_1a1_-1122a11a321_111_-1b1111111_______-332_____________-aa1_____________-221__xx______x__-_______________x-__111____111____-x_1a1_1122a32_x_-x_11213a3a5aa4b3-___13a4a43abb__x-1234aa313b432___-2aaaa3214a422___-a4a4211a3a3aa1_x
		// TODO: AI Ignore Mario EV for c7 here? Probably not, it is quite a bad move after all: 012a2123a2___1b1-01b33a2aa41_1221-012b3234aa1_1a1_-1122a11a321_111_-1b1111111_______-332_____________-aa1___________1_-221__xx______x2_-______________2x-__111____111__2_-x_1a1_1122a323a2-x_11213a3a5aa4b3-___13a4a43abb32b-1234aa313b432111-2aaaa3214a4221__-a4a4211a3a3aa1_x
		if (square.probability[0] > 0 && data.getProbabilities()[0] == 0) return 0; // Mario reporting incorrect value. As far as I can remember, a fix for the "jump over 50%"-situations.
		
		if (square.firstExpectedValue == null) return 0;
		return square.firstExpectedValue;
	}

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		mario = scores.getAnalyze(MarioAnalyze.class);
		return this.weaponIsClick(scores.getWeapon());
	}
}
