package net.zomis.minesweeper.ais.post;

import java.util.List;

import net.zomis.minesweeper.ais.BombTools;
import net.zomis.minesweeper.aiscore.CertainMines;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.endgame.WinChanceTools;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMove;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.FieldScore;
import net.zomis.minesweeper.scores.FieldScores;
import net.zomis.minesweeper.scores.PostScorer;
import net.zomis.minesweeper.weapons.classic.BombWeapon;

public class BombStifle extends PostScorer {
	@Override
	public void handle(FieldScores scores) {
		if (!this.weaponIsClick(scores.getWeapon())) return;
		
		MinesweeperPlayingPlayer player = scores.getPlayer();
		String bomb = MinesweeperMove.STANDARD_BOMB;
		MinesweeperPlayingPlayer opponent = MineprobHelper.getOpponents(scores.getPlayer())[0];

		if (opponent.getScore() > player.getScore()) {
//			ai.sendInfo("Opponent has more points than I");
			return;
		}
		BombWeapon bombWeapon = (BombWeapon) opponent.getWeapon(bomb);
		if (bombWeapon == null) {
			// Bomb weapon does not exist.
			return;
		}
		if (bombWeapon.getUseCount() > 0) {
//			ai.sendInfo("Opponent has already used bomb.");
			return;
		}
		
		if (player.getScore() < 15) return;
		if (opponent.getScore() < 15) return;
		
		if (player.getScore() == opponent.getScore() && player.getMap().getMinesLeft() == 1) {
			// New code for TestmareB.
			return;
		}
		
		MinesweeperField bestBombField = BombTools.getBestBomb(player.getMap(), scores.getAnalyze().getAnalyze());
//		double bombScore = BombTools.getBombProbability(bestBombField, scores.getAnalyze());
		List<MinesweeperField> bestAffected = BombTools.getBombAdjacents(bestBombField);
		
		double bombWinChance = BombTools.getBombWinPercent(scores.getAnalyze().getAnalyze(), bestBombField, opponent.getScore());
		
		MinesweeperField bestField = scores.getRankings()[0][0];
		ProbabilityKnowledge<MinesweeperField> bestData = scores.getAnalyze().getKnowledgeFor(bestField);
		if (bestData.getProbabilities()[0] > 0 && bestData.getProbabilities()[0] < 0.15 && bombWinChance >= 0.3) {
			// Opponent can bomb, best field has open field chance, but it's not big.
//			ai.sendInfo("I have to play open field and it's starting to be bomb time. Best bomb is " + bombScore + " @ " + bestBombField + " and my field is " + bestField);
			this.performAddBombScore(scores, bestAffected);
		}

		
//		if (ai leder och det b�rjar bli dags: perform! Add the actual bomb probability on each field);
		if (bombWinChance >= 0.42) {
			
//			if (MineprobHelper.find100(ai.getAnalyze().getAnalyze())  ) {
//				
//			}
			
			if (opponent.getScore() == player.getScore()) {
				BombWeapon myWeapon = (BombWeapon) player.getWeapon(bomb);
				if (myWeapon.getUseCount() == 0) // Check if AI has used the bomb
					this.performAvoidGiveBomb(scores);
			}
			else {
//				ai.sendInfo("I have a bad feeling about this. I'd better sabotage your bomb. " + bombScore + " @ " + bestBombField);
				this.performAddBombScore(scores, bestAffected);
			}
		}
	}

	private void performAddBombScore(FieldScores scores, List<MinesweeperField> bestBombEffect) {
//		ai.sendInfo("Considering bombscore, mine probability, and open field probability.");
		for (FieldScore ee : scores.getScores().values()) {
			double stifle = stifleEffect(ee.getField(), scores.getAnalyze(), bestBombEffect);
			if (stifle != 0) {
//				ai.sendInfo(ee.getKey() + " changes " + stifle + " to " + newValue);
			}
			this.force(ee, stifle);
		}
	}
	

	public static double stifleEffect(MinesweeperField field, AnalyzeProvider analyze, List<MinesweeperField> bestBombEffect) {
		if (bestBombEffect != null && !bestBombEffect.contains(field)) return 0; // Field not affected, ignore it.
		
		double bombScore = BombTools.getBombProbability(field, analyze.getAnalyze());
		if (analyze.getKnowledgeFor(field) == null) return -42;
		
		double bonusMineProbability = analyze.getKnowledgeFor(field).getMineProbability();
		double bonusAvoidOpenField = 1 - analyze.getKnowledgeFor(field).getProbabilities()[0];
		return bombScore * 2 + bonusMineProbability * 10 + bonusAvoidOpenField * 3;
	}
	

	private void performAvoidGiveBomb(FieldScores scores) {
//		ai.sendInfo("If I get a mine you will be able to bomb. I'd better avoid them. But I need to start take them at some point, don't I?");
		
		for (FieldScore ee : scores.getScores().values()) {
			ProbabilityKnowledge<MinesweeperField> data = scores.getAnalyze().getKnowledgeFor(ee.getField());
//			ai.sendInfo("Decreasing score for " + ee.getKey() + " by " + data.getMineProbability() + " previous was " + ee.getValue());
			this.force(ee, - data.getMineProbability() * CertainMines.POWER);
		}
		
		{
			// New code for AI_TestmareB
			MinesweeperPlayingPlayer me = scores.getPlayer();
			MinesweeperPlayingPlayer opponent = MineprobHelper.getOpponents(scores.getPlayer())[0];
			int mines100 = MineprobHelper.find100(scores.getAnalyze().getAnalyze());
			if (me.getScore() == opponent.getScore() && me.getScore() + mines100 + 1 >= WinChanceTools.NEEDED_SCORE) {
				List<FieldScore> best = scores.getBestFields();
				
				if (scores.getAnalyze().getKnowledgeFor(best.get(0).getField()).getMineProbability() > 0) {
//					ai.sendInfo("I have no other choice but to take a chance!");
					for (FieldScore ee : scores.getScores().values()) {
						ProbabilityKnowledge<MinesweeperField> data = scores.getAnalyze().getKnowledgeFor(ee.getField());
						if (data.getMineProbability() < 1.0) {
//							ai.sendInfo("Adding score for " + ee.getKey() + " by " + data.getMineProbability() + " previous was " + ee.getValue());
							this.force(ee, data.getMineProbability() * 20);
						}
					}
				}
			}
		}
	}
}
