package net.zomis.minesweeper.ais;

import net.zomis.mario.classes.Bot;
import net.zomis.mario.classes.Enums.Difficult;
import net.zomis.mario.classes.Enums.PlayerColor;
import net.zomis.mario.classes.Square;
import net.zomis.mario.mfeais.NightmareTools;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.scores.PreScorer;

public class MarioAnalyze implements PreScorer {
	private Bot mario = null;
	
	@Override
	public MarioAnalyze analyze(MinesweeperPlayingPlayer player) {
		initMario(player);
		if (!this.mario.getBoard().solved) return null;
		return this;
	}
	private void initMario(MinesweeperPlayingPlayer player) {
		if (mario == null) mario = new Bot(PlayerColor.colorFor(player), Difficult.VERY_HARD_NO_SIMULATE);
		mario.move(NightmareTools.fixBoard(player, mario));
	}
	public Square getSquare(MinesweeperField field) {
		return this.mario.getBoard().square[field.getY()][field.getX()];
	}
	@Override
	public void scoringComplete() {
		mario.javaGarbage();
	}
	public Bot getBot() {
		return this.mario;
	}
}
