package net.zomis.minesweeper.ais;

import net.zomis.minesweeper.analyze.FieldGroup;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.scores.AbstractScorer;
import net.zomis.minesweeper.scores.ScoreParameters;

public class HighestMineProbability extends AbstractScorer {

	private double highestProb;

	@Override
	public boolean workWithWeapon(ScoreParameters scores) {
		if (!this.weaponIsClick(scores.getWeapon())) return false;
		
		this.highestProb = 0;
		for (FieldGroup<MinesweeperField> ee : scores.getAnalyze().getAnalyze().getGroups()) {
			if (ee.getProbability() > this.highestProb) this.highestProb = ee.getProbability();
		}
		return !BadChickenPlayWhenBadProbabilities.isBadProbabilities(scores.getAnalyze().getAnalyze());
	}

	@Override
	public double getScoreFor(MinesweeperField field, ProbabilityKnowledge<MinesweeperField> data, ScoreParameters scores) {
		FieldGroup<MinesweeperField> grp = scores.getAnalyze().getAnalyze().getGroupFor(field);
		if (grp == null) return 0;
		
		if (grp.getProbability() == this.highestProb) return 1;
		else return 0;
	}

}
