package net.zomis.mfe.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import net.zomis.UtilZomisList;
import net.zomis.UtilZomisUtils;
import net.zomis.mario.classes.Bot;
import net.zomis.mario.mfeais.NightmareTools;
import net.zomis.minesweeper.ais.MarioAnalyze;
import net.zomis.minesweeper.analyze.*;
import net.zomis.minesweeper.analyze.detail.DetailedResults;
import net.zomis.minesweeper.analyze.detail.ProbabilityKnowledge;
import net.zomis.minesweeper.analyze.endgame.WinChanceAnalyze;
import net.zomis.minesweeper.analyze.impl.AnalyzeFactory;
import net.zomis.minesweeper.analyze.impl.AnalyzeProvider;
import net.zomis.minesweeper.analyze.impl.DetailNeighborImpl;
import net.zomis.minesweeper.analyze.impl.EVCalculator;
import net.zomis.minesweeper.analyze.impl.EVInfo;
import net.zomis.minesweeper.analyze.impl.MineprobabilityAnalyze;
import net.zomis.minesweeper.analyze.utils.MineprobHelper;
import net.zomis.minesweeper.api.FieldInfo;
import net.zomis.minesweeper.api.Minesweeper;
import net.zomis.minesweeper.api.MinesweeperPlayer;
import net.zomis.minesweeper.api.MinesweeperPlugin;
import net.zomis.minesweeper.events.Command;
import net.zomis.minesweeper.events.EventListener;
import net.zomis.minesweeper.events.player.PlayerCommandEvent;
import net.zomis.minesweeper.game.MinesweeperField;
import net.zomis.minesweeper.game.MinesweeperMap;
import net.zomis.minesweeper.game.MinesweeperPlayingPlayer;
import net.zomis.minesweeper.game.model.MapUtils;

public class DugaPlugin extends MinesweeperPlugin implements EventListener {
	private static final Random sRandom = new Random();
	
	@Command(command = "duga_solve", help = "Solve the endgame situation", requiredPermission = PlayerCommandEvent.PERMISSION_TRUSTED_USER)
	public void solve(PlayerCommandEvent event) {
		long start = System.nanoTime();
		WinChanceAnalyze analyze = new WinChanceAnalyze(event.getMap().getCurrentPlayer());
		event.getPlayer().sendChat(analyze.toString());
		long end = System.nanoTime();
		event.getPlayer().sendChat("Analyze took " + UtilZomisUtils.nanoToMilli(end - start));
	}
	
	@Command(command = "regenerate", help = "Regenerate the map", requiredPermission = PlayerCommandEvent.PERMISSION_TRUSTED_USER)
	public void regenerate(PlayerCommandEvent event) {
		MinesweeperMap game = event.getMap();
		AnalyzeResult<MinesweeperField> analyze = new MineprobabilityAnalyze(game).solve();
		
		MineprobHelper.regenerate(game, analyze, sRandom);
		
		for (String param : event.getParameters()) {
			if (param.contentEquals("mygel")) {
				if (event.getGame().isStoredInDatabase()) {
					event.getPlayer().sendAlert("Cheating not allowed in database stored games.");
					return;
				}
				
				for (MinesweeperField ff : game.getIteration()) {
					if (ff.isClicked()) continue;
					
					if (ff.isMine())
						event.getPlayer().sendFieldInfo(ff, FieldInfo.VISIBLE_MINE);
					else event.getPlayer().sendFieldInfo(ff, null, false);
				}
			}
		}
	}
	
	@Command(command = "duga_details", help = "Ett kommando som heter duga", requiredPermission = PlayerCommandEvent.PERMISSION_TRUSTED_USER)
	public void dugaDetails(PlayerCommandEvent event) {
		long time = System.nanoTime();
		AnalyzeResult<MinesweeperField> analyze = new MineprobabilityAnalyze(event.getMap()).solve();
		time = System.nanoTime() - time;
		event.getPlayer().sendChat("Zomis mineprob: " + MineprobHelper.nanoToMilli(time) + " milliseconds.");
		
		time = System.nanoTime();
		DetailedResults<MinesweeperField> detail = analyze.analyzeDetailed(new DetailNeighborImpl());
		time = System.nanoTime() - time;
		event.getPlayer().sendChat("Zomis all probabilities: " + MineprobHelper.nanoToMilli(time) + " milliseconds.");
		
		int xx = event.getParameterInt(0, -1);
		int yy = event.getParameterInt(1, -1);
		if (xx >= 0 && yy >= 0) {
			if (event.getMap() == null) throw new NullPointerException("Game is null: " + event);
			ProbabilityKnowledge<MinesweeperField> proxy = detail.getProxyFor(event.getMap().getPosition(xx, yy));
			event.getPlayer().sendChat(String.format("Information for %d, %d: %s", xx, yy, proxy));
			
			time = System.nanoTime();
			EVCalculator ev = new EVCalculator(AnalyzeFactory.analyze(event.getMap(), true));
			EVInfo fieldEV = ev.calcEV(proxy);
			time = System.nanoTime() - time;
			event.getPlayer().sendChat("Reveal analyze took " + UtilZomisUtils.nanoToMilli(time) + " Result is: " + fieldEV);
			
		}
		else {
			List<ProbabilityKnowledge<MinesweeperField>> proxies = new ArrayList<ProbabilityKnowledge<MinesweeperField>>(detail.getProxies());
			for (int i = 0; i < proxies.size() && i < 10; i++) {
				ProbabilityKnowledge<MinesweeperField> prox = proxies.get(i);
				event.getPlayer().sendChat(prox.toString());
			}
		}
		event.getPlayer().sendChat("Number of unique: " + detail.getProxyCount());
	}
	@Command(command = "duga_time", help = "Ett kommando som heter duga.", requiredPermission = PlayerCommandEvent.PERMISSION_TRUSTED_USER)
	public void dugaTime(PlayerCommandEvent event) {
		long time;
		
		MinesweeperMap map = event.getMap().getMapFactory().withPlayers(event.getMap().getPlayingPlayers().size()).loadFrom(event.getMap().saveMap()).map();
		
		time = System.nanoTime();
		AnalyzeProvider analyze = AnalyzeFactory.analyze(map, false);
		time = System.nanoTime() - time;
		double timeTaken = UtilZomisUtils.nanoToMilli(time);
		event.getPlayer().sendChat("Zomis mine probabilities: " + timeTaken + " ms");
		long zomis1 = time;
		
		time = System.nanoTime();
		DetailedResults<MinesweeperField> detail = analyze.getAnalyze().analyzeDetailed(new DetailNeighborImpl());
		time = System.nanoTime() - time;
		event.getPlayer().sendChat("Zomis other probabilities: " + UtilZomisUtils.nanoToMilli(time) + " milliseconds.");
		
		event.getPlayer().sendChat("Zomis total: " + UtilZomisUtils.nanoToMilli(zomis1 + time) + " milliseconds.");
		
		MinesweeperPlayingPlayer player = map.getCurrentPlayer();
		Bot mario = new MarioAnalyze().analyze(player).getBot();
		char[][] board = NightmareTools.fixBoard(player, mario);
		time = System.nanoTime();
		mario.move(board);
		time = System.nanoTime() - time;
		event.getPlayer().sendChat("Mario analyze: " + UtilZomisUtils.nanoToMilli(time) + " milliseconds.");
	}
	
	@Command(command = "duga", help = "Ett kommando som heter duga.", requiredPermission = PlayerCommandEvent.PERMISSION_TRUSTED_USER)
	public void duga(PlayerCommandEvent event) {
		if (event.getPlayer().getMap() == null) return;
		event.getPlayer().sendChat("Duga is analyzing...", 0xff00ff);
		
		long time = System.nanoTime();
		AnalyzeProvider analyzeProvider = AnalyzeFactory.analyze(event.getPlayer().getMap(), false);
		time = System.nanoTime() - time;
		double timeTaken = MineprobHelper.nanoToMilli(time);
		
		AnalyzeResult<MinesweeperField> analyze = analyzeProvider.getAnalyze();
		event.getPlayer().sendChat(analyze.getGroups().size() + " FieldGroups:");
		for (FieldGroup<MinesweeperField> group : analyze.getGroups()) {
			event.getPlayer().sendChat(group.toString() + " has probability " + group.getProbability());
		}
		event.getPlayer().sendChat("Total rules is " + analyze.getRules().size());
		event.getPlayer().sendChat("Total fields is " + analyze.getFields().size());
		event.getPlayer().sendChat("Total field groups is " + analyze.getGroups().size());
		event.getPlayer().sendChat("Solution groups: " + analyze.getSolutions().size());
		event.getPlayer().sendChat("Total combinations is " + analyze.getTotal());
		event.getPlayer().sendChat("Number of 100% " + count(analyze, 1.0));
		event.getPlayer().sendChat("Number of 0% " + count(analyze, 0.0));
		event.getPlayer().sendChat("Number of unclicked fields " + event.getMap().getAllUnclickedFields().size());
		event.getPlayer().sendChat("Analyze time: " + timeTaken + " ms");
	}
	private int count(AnalyzeResult<MinesweeperField> analyze, double probability) {
		int total = 0;
		for (FieldGroup<MinesweeperField> field : analyze.getGroups()) {
			if (Math.abs(field.getProbability() - probability) <= 0.00001) {
				total += field.size();
			}
		}
		return total;
	}

	@Command(command = "duga_sols", help = "Ett kommando som heter duga.", requiredPermission = PlayerCommandEvent.PERMISSION_TRUSTED_USER)
	public void dugaSolutions(PlayerCommandEvent event) {
		if (event.getPlayer().getMap() == null) return;
		
		event.getPlayer().sendChat("Duga is analyzing...", 0xff00ff);
		AnalyzeResult<MinesweeperField> analyze = new MineprobabilityAnalyze(event.getPlayer().getMap()).solve();
		List<Solution<MinesweeperField>> theSolutions = new ArrayList<Solution<MinesweeperField>>(analyze.getSolutions());
		
		event.getPlayer().sendChat(analyze.getSolutions().size() + " Solutions:");
		int remainShow = event.getParameterInt(0, -1);
		remainShow = Math.min(remainShow, theSolutions.size()); // Do not allow remainShow to be more than the actual solutions
		
		if (remainShow > 0) {
			if (remainShow > 100) return;
			
			while (remainShow > 0) {
				Solution<MinesweeperField> randSolution = UtilZomisList.getRandom(theSolutions);
				theSolutions.remove(randSolution);
				
				event.getPlayer().sendChat(randSolution.toString() + " with probability " + randSolution.getProbability());
				remainShow--;
			}
		}
		else {
			if (theSolutions.size() > 100) return;
			
			// Show all solutions
			for (Solution<MinesweeperField> sol : theSolutions) {
				event.getPlayer().sendChat(sol.toString() + " with probability " + sol.getProbability());
			}
		}
	}
	
	@Command(command = "duga_rules", help = "Ett kommando som heter duga.", requiredPermission = PlayerCommandEvent.PERMISSION_TRUSTED_USER)
	public void dugaRules(PlayerCommandEvent event) {
		if (event.getPlayer().getMap() == null) return;
		
		MineprobabilityAnalyze analyze = new MineprobabilityAnalyze(event.getPlayer().getMap());
		List<RuleConstraint<MinesweeperField>> rules = analyze.getRules();
		
		event.getPlayer().sendChat(rules.size() + " FieldRules:");
		for (RuleConstraint<MinesweeperField> rule : rules) {
			event.getPlayer().sendChat(rule.toString() + " with cause " + rule.getCause());
		}
	}

	@Command(command = "duga1", help = "Analyze", requiredPermission = PlayerCommandEvent.PERMISSION_ADMIN)
	public void duga1(PlayerCommandEvent event) {
		final StringBuilder str = new StringBuilder();
		final MinesweeperMap map = event.getMap();
		AnalyzeProvider analyze = AnalyzeFactory.analyze(map, false);

		str.append("Analyze:\n");
		str.append(analyze.getAnalyze().getTotal() + " combinations.\n");
		str.append("\n");

		str.append(analyze.getAnalyze().getRules().size() + " rules:\n");
		for (RuleConstraint<MinesweeperField> ee : analyze.getAnalyze().getRules()) str.append(ee + "\n");
		str.append("\n");

		str.append(analyze.getAnalyze().getGroups().size() + " groups:\n");
		for (FieldGroup<MinesweeperField> ee : analyze.getAnalyze().getGroups()) str.append(ee + "\n");
		str.append("\n");

		str.append(analyze.getAnalyze().getSolutions().size() + " solutions:\n");
		for (Solution<MinesweeperField> ee : analyze.getAnalyze().getSolutions()) str.append(ee + "\n");
		str.append("\n");
		event.getPlayer().sendChat(str.toString());
	}
	
	
	@Command(command = "tough_map", help = "Test", requiredPermission = PlayerCommandEvent.PERMISSION_ADMIN)
	public void onMap1(PlayerCommandEvent event) {
		this.mapLoad(event, "________________-_3_______3___3__-xxxxx__xxxxxxxx_-___3___3___3____-______x_________-___xx3x_________-________________-_______3___3____-xxxxxxxxxxxxx___-_3_______3______-____________x___-xxx3xxx3xxx3x___-__x_____x_______-_3___3_______3__-xx__xxx_____xxx_-________________");
	}
	@Command(command = "tough_map2", help = "Test", requiredPermission = PlayerCommandEvent.PERMISSION_ADMIN)
	public void onMap2(PlayerCommandEvent event) {
		this.mapLoad(event, "________________-_3_______3___3__-xxxxx__xxxxxxxx_-___3___3___3____-______x_________-____x3x_________-________________-_______3___3____-xxxxxxxxxxxxx___-_3_______4x_____-____________x___-xxx3xxx3xxx3x___-__x_____x_______-_3___3_______3__-xx__xxx_____xxx_-________________");
	}
	@Command(command = "tough_map3", help = "Test", requiredPermission = PlayerCommandEvent.PERMISSION_ADMIN)
	public void onMap3(PlayerCommandEvent event) {
		this.mapLoad(event, "________________-_3_______3___3__-xxxxx__xxxxxxxx_-___3___3___3____-______x_________-____x3x_________-________________-__3____3___32___-xxxxxxxxxxxxx___-_3_______4x_____-____________x2__-xxx3xxx3xxx3x___-__x_____x_______-_3___3_______3__-xx__xxx_____xxx_-________________");
		event.getPlayer().sendAlert("Warning: This map most likely results in GC overhead limit exceeded.");
	}
	
	private void mapLoad(PlayerCommandEvent event, String map) {
		MinesweeperMap game = event.getPlayer().getMap();
		if (game == null) {
			game = event.getPlayer().createInvitation(null).forceAdd(event.getPlayer().getServer().getPlayerByName("#AI_Hard")).startGame();
		}
		else throw new AssertionError("Cannot be inside a game for this command.");
		game.clear();
		game.loadMap(map);
		game.setCurrentPlayerTurn(0);
		
	}
	@Override
	public boolean canBeChosenBy(MinesweeperPlayer arg0) {
		return false;
	}

	@Override
	public void onDisable() {
		
	}

	@Override
	public void onEnable() {
		this.registerListener(this);
		this.registerListener(new TentaizuListener());
	}

	@Command(command = "history", help = "Get link to replay for game")
	public void onHistoryCommand(PlayerCommandEvent event) {
		MinesweeperMap map = event.getMap();
		
		if (map == null) {
			map = event.getServer().getGame(event.getParameterInt(0, -42));
			if (map == null) event.getPlayer().sendChat("Game not found.");
		}
		event.getPlayer().sendChat("History in game " + map);

		String mines = MapUtils.getMinesString(map);
		String clicks = MapUtils.getClickString(map);
		
		String link = Minesweeper.URL_STATS + "/replay/" + mines + "/" + clicks;
//		if (game.isStoredInDatabase() && game.isGameOver()) link = ...
		
		if (event.getPlayer().hasPermission(PlayerCommandEvent.PERMISSION_ADMIN)) {
			event.getPlayer().sendChat("Replay link: " + link);
		}
		else {
			if (!map.isGameOver()) {
				event.getPlayer().sendChat("Game is not finished.");
			}
			else event.getPlayer().sendChat("Replay link: " + link);
		}
	}
	
}
